/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib.Alias;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.pie.tlatoani.ProtocolLib.Alias.ExprPacketInfoAlias;
import com.pie.tlatoani.ProtocolLib.Alias.PacketInfoAlias;
import com.pie.tlatoani.Util.GroupedList;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.MundoEventScope;
import com.pie.tlatoani.Util.ScopeUtil;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.ExpressionConstraints;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.SyntaxParser;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.SyntaxPiece;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.VariableCollective;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.VariableUsage;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.event.Event;

public class ScopePacketInfoAliases
extends MundoEventScope {
    private PacketType packetType;
    private GroupedList.Key key;
    public static final Character SEPARATOR = Character.valueOf('=');
    public static final String SYNTAX_VAR_NAME = "p";

    @Override
    protected void afterInit() {
    }

    public void unregister(Trigger trigger) {
        ExprPacketInfoAlias.unregisterAliases(this.key);
    }

    public void unregisterAll() {
        ExprPacketInfoAlias.unregisterAllAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        this.packetType = (PacketType)literals[0].getSingle();
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        try {
            ArrayList<PacketInfoAlias> aliases = new ArrayList<PacketInfoAlias>();
            for (Node node : topNode) {
                SkriptLogger.setNode((Node)node);
                if (node instanceof SectionNode) {
                    Skript.error((String)"Packet info aliases should not be sections!");
                    boolean bl = false;
                    return bl;
                }
                int separatorIndex = node.getKey().indexOf(SEPARATOR.charValue());
                if (separatorIndex == -1) {
                    Skript.error((String)("Packet info aliases should be in the format '<new syntax> " + SEPARATOR + " <old syntax>'"));
                    boolean bl = false;
                    return bl;
                }
                String syntax = node.getKey().substring(0, separatorIndex).trim();
                Optional<String> validatedSyntax = ScopePacketInfoAliases.validateAliasSyntax(syntax);
                if (!validatedSyntax.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                String original = node.getKey().substring(separatorIndex + 1).trim();
                Optional<PacketInfoAlias> aliasOptional = PacketInfoAlias.create(this.packetType, validatedSyntax.get(), original);
                if (!aliasOptional.isPresent()) {
                    Skript.error((String)"Invalid target syntax in the packet info alias!");
                    boolean bl = false;
                    return bl;
                }
                aliases.add(aliasOptional.get());
            }
            this.key = ExprPacketInfoAlias.registerAliases(aliases);
            boolean bl = true;
            return bl;
        }
        finally {
            ScopeUtil.removeSubNodes(topNode);
        }
    }

    private static Optional<String> validateAliasSyntax(String syntax) {
        SyntaxPiece syntaxPiece;
        if (syntax.contains("%p=")) {
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        String spComptabile = syntax.replace("%packet%", "%p=packet%");
        try {
            syntaxPiece = SyntaxParser.parse(spComptabile);
        }
        catch (IllegalArgumentException e) {
            Logging.debug(ScopePacketInfoAliases.class, e);
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        VariableUsage usage = syntaxPiece.getVariableUsage(SYNTAX_VAR_NAME);
        if (usage == VariableUsage.NONE) {
            Skript.error((String)"Alias syntax does not contain '%packet%'!");
            return Optional.empty();
        }
        if (usage == VariableUsage.INCONISTENT) {
            Skript.error((String)"Alias syntax does not require the use of '%packet%' in its syntax!");
            return Optional.empty();
        }
        if (usage == VariableUsage.CONFLICTING) {
            Skript.error((String)"Alias syntax allows conflicting usage of '%packet%'!");
            return Optional.empty();
        }
        VariableCollective variableCollective = syntaxPiece.getVariables();
        if (variableCollective.size() > 1 || variableCollective.isVaryingOption(SYNTAX_VAR_NAME)) {
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        ExpressionConstraints constraints = variableCollective.getExpression(SYNTAX_VAR_NAME);
        for (ExpressionConstraints.Type type : constraints.types) {
            if (type.classInfo.getC() == PacketContainer.class && type.isSingle) continue;
            Skript.error((String)"Invalid alias syntax in the packet info alias!");
            return Optional.empty();
        }
        return Optional.of(syntaxPiece.actualSyntax(0));
    }

    public String toString(Event event, boolean b) {
        return null;
    }
}

