/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.DocumentationElement;
import com.pie.tlatoani.Util.ImmutableGroupedList;
import com.pie.tlatoani.Util.Logging;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public final class Documentation {
    public static final Comparator<DocumentationElement> DOCUMENTATION_ELEMENT_COMPARATOR = Comparator.comparing(docElem -> docElem.name.toLowerCase());
    private static List<DocumentationBuilder> builders = new LinkedList<DocumentationBuilder>();
    private static boolean built = false;
    private static List<String> categories = null;
    private static ImmutableGroupedList<DocumentationElement, String> allElements = null;
    private static ImmutableGroupedList<DocumentationElement.Effect, String> effects = null;
    private static ImmutableGroupedList<DocumentationElement.Condition, String> conditions = null;
    private static ImmutableGroupedList<DocumentationElement.Expression, String> expressions = null;
    private static ImmutableGroupedList<DocumentationElement.Event, String> events = null;
    private static ImmutableGroupedList<DocumentationElement.Type, String> types = null;
    private static ImmutableGroupedList<DocumentationElement.Scope, String> scopes = null;

    static void addBuilder(DocumentationBuilder builder) {
        builders.add(builder);
    }

    public static void buildDocumentation() {
        if (built) {
            throw new IllegalStateException("The documentation has already been built");
        }
        ImmutableGroupedList.OrderedBuilder allElementsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder effectsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder expressionsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder conditionsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder eventsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder typesBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder scopesBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        for (DocumentationBuilder builder : builders) {
            Object docElem = builder.build();
            allElementsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement)docElem);
            if (docElem instanceof DocumentationElement.Effect) {
                effectsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Effect)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Condition) {
                conditionsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Condition)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Expression) {
                expressionsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Expression)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Event) {
                eventsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Event)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Type) {
                typesBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Type)docElem);
                continue;
            }
            if (!(docElem instanceof DocumentationElement.Scope)) continue;
            scopesBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Scope)docElem);
        }
        allElements = allElementsBuilder.build();
        effects = effectsBuilder.build();
        conditions = conditionsBuilder.build();
        expressions = expressionsBuilder.build();
        events = eventsBuilder.build();
        types = typesBuilder.build();
        scopes = scopesBuilder.build();
        categories = allElements.getGroupKeys();
        built = true;
        Logging.debug(Documentation.class, "All DocElems: " + allElements);
    }

    public static List<String> getCategories() {
        return categories;
    }

    public static ImmutableGroupedList<DocumentationElement, String> getAllElements() {
        return allElements;
    }

    public static ImmutableGroupedList<DocumentationElement.Effect, String> getEffects() {
        return effects;
    }

    public static ImmutableGroupedList<DocumentationElement.Condition, String> getConditions() {
        return conditions;
    }

    public static ImmutableGroupedList<DocumentationElement.Expression, String> getExpressions() {
        return expressions;
    }

    public static ImmutableGroupedList<DocumentationElement.Event, String> getEvents() {
        return events;
    }

    public static ImmutableGroupedList<DocumentationElement.Type, String> getTypes() {
        return types;
    }

    public static ImmutableGroupedList<DocumentationElement.Scope, String> getScopes() {
        return scopes;
    }
}

