/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldManagement.WorldLoader;

import com.pie.tlatoani.Generator.ChunkGeneratorWithID;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Util.Logging;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.ChunkGenerator;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class WorldLoader {
    private static Map<String, WorldCreator> worldLoaderSaver = new HashMap<String, WorldCreator>();
    private static final String FILENAME = "worldloader.json";

    private WorldLoader() {
    }

    public static void load() {
        try {
            WorldLoader.readJSONObject(WorldLoader.getLoaderFile()).forEach((key, value) -> {
                String s = (String)key;
                JSONObject jsonObject = (JSONObject)value;
                WorldCreator creator = WorldLoader.getCreatorFromJSON(s, jsonObject);
                WorldLoader.setCreator(creator);
                creator.createWorld();
            });
            if (WorldLoader.getAllCreators().isEmpty()) {
                Logging.info("No worlds were assigned to load automatically");
            } else {
                Logging.info("Worlds to automatically load were loaded successfully!");
            }
        }
        catch (IOException | ClassCastException | ParseException e) {
            Logging.info("MundoSK encountered problems while reading the file for automatically loaded worlds");
            Logging.info("Any worlds set to automatically load were not loaded");
            Logging.reportException(WorldLoader.class, (Exception)e);
        }
    }

    public static void save() throws IOException {
        FileWriter writer = new FileWriter(WorldLoader.getLoaderFile());
        writer.write(WorldLoader.getJSONOfData().toString());
        writer.flush();
        writer.close();
    }

    public static File getLoaderFile() throws IOException {
        File result = new File(Mundo.INSTANCE.getDataFolder().getAbsolutePath() + File.separator + FILENAME);
        if (!result.exists()) {
            result.createNewFile();
            JSONObject emptyObject = new JSONObject();
            FileWriter writer = new FileWriter(result);
            writer.write(emptyObject.toString());
            writer.flush();
            writer.close();
        }
        return result;
    }

    public static JSONObject readJSONObject(File jsonFile) throws IOException, ParseException, ClassCastException {
        return (JSONObject)new JSONParser().parse((Reader)new FileReader(jsonFile));
    }

    public static JSONObject getJSONOfData() {
        final JSONObject jsonObject = new JSONObject();
        worldLoaderSaver.forEach(new BiConsumer<String, WorldCreator>(){

            @Override
            public void accept(String s, WorldCreator worldCreator) {
                jsonObject.put((Object)s, (Object)WorldLoader.getCreatorJSON(worldCreator));
            }
        });
        return jsonObject;
    }

    public static WorldCreator getCreator(String worldname) {
        return worldLoaderSaver.get(worldname);
    }

    public static void setCreator(WorldCreator worldCreator) {
        worldLoaderSaver.put(worldCreator.name(), worldCreator);
    }

    public static void removeCreator(String worldname) {
        worldLoaderSaver.remove(worldname);
    }

    public static List<WorldCreator> getAllCreators() {
        return new ArrayList<WorldCreator>(worldLoaderSaver.values());
    }

    public static void clearAllCreators() {
        worldLoaderSaver.clear();
    }

    public static JSONObject getCreatorJSON(WorldCreator creator) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"environment", (Object)creator.environment().toString());
        jsonObject.put((Object)"worldtype", (Object)creator.type().toString());
        jsonObject.put((Object)"structures", (Object)creator.generateStructures());
        jsonObject.put((Object)"seed", (Object)Long.toString(creator.seed()));
        jsonObject.put((Object)"generatorsettings", (Object)creator.generatorSettings());
        if (creator.generator() instanceof ChunkGeneratorWithID) {
            jsonObject.put((Object)"generator", (Object)((ChunkGeneratorWithID)creator.generator()).id);
        }
        return jsonObject;
    }

    public static WorldCreator getCreatorFromJSON(String worldname, JSONObject creatorJSON) {
        WorldCreator creator = new WorldCreator(worldname);
        creator.environment(World.Environment.valueOf((String)((String)creatorJSON.get((Object)"environment"))));
        creator.type(WorldType.valueOf((String)((String)creatorJSON.get((Object)"worldtype"))));
        creator.generateStructures(((Boolean)creatorJSON.get((Object)"structures")).booleanValue());
        creator.seed(Long.parseLong((String)creatorJSON.get((Object)"seed")));
        String generator = (String)creatorJSON.get((Object)"generator");
        if (generator != null) {
            creator.generator((ChunkGenerator)ChunkGeneratorWithID.getGenerator(generator));
        }
        creator.generatorSettings((String)creatorJSON.get((Object)"generatorsettings"));
        return creator;
    }
}

