/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Player.PlayerTablist;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import com.pie.tlatoani.Tablist.SupplementaryTablist;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.entity.Player;

public class Tablist {
    public final Player target;
    private boolean scoresEnabled;
    private final PlayerTablist playerTablist = new PlayerTablist(this);
    private SupplementaryTablist supplementaryTablist = new SimpleTablist(this.playerTablist);
    public static final Skin DEFAULT_SKIN_TEXTURE = Skin.ALL_WHITE;
    public static final String OBJECTIVE_NAME = "MundoSK_Tablist";

    public Tablist(Player target) {
        this.target = target;
    }

    public Optional<PlayerTablist> getPlayerTablist() {
        if (this.supplementaryTablist.allowExternalPlayerTabModification()) {
            return Optional.of(this.playerTablist);
        }
        return Optional.empty();
    }

    void onJoin(Player player) {
        this.playerTablist.onJoin(player);
    }

    void onQuit(Player player) {
        this.playerTablist.onQuit(player);
    }

    PlayerInfoData onPlayerInfoPacket(PlayerInfoData oldPlayerInfoData, Player objPlayer) {
        return this.playerTablist.onPlayerInfoPacket(oldPlayerInfoData, objPlayer);
    }

    public boolean arePlayersVisible() {
        return this.playerTablist.arePlayersVisible();
    }

    public boolean isPlayerVisible(Player player) {
        return this.playerTablist.isPlayerVisible(player);
    }

    public SupplementaryTablist getSupplementaryTablist() {
        return this.supplementaryTablist;
    }

    public void setSupplementaryTablist(Function<PlayerTablist, SupplementaryTablist> supplementaryTablistProvider) {
        this.supplementaryTablist.disable();
        this.supplementaryTablist = supplementaryTablistProvider.apply(this.playerTablist);
    }

    public boolean areScoresEnabled() {
        return this.scoresEnabled;
    }

    public void setScoresEnabled(boolean enabled) {
        if (enabled) {
            this.enableScores();
        } else {
            this.disableScores();
        }
    }

    public void enableScores() {
        if (!this.areScoresEnabled()) {
            this.scoresEnabled = true;
            PacketContainer createPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
            createPacket.getStrings().writeSafely(0, (Object)OBJECTIVE_NAME);
            createPacket.getStrings().writeSafely(1, (Object)OBJECTIVE_NAME);
            createPacket.getIntegers().writeSafely(0, (Object)0);
            PacketManager.sendPacket(createPacket, (Object)this, this.target);
            PacketContainer displayPacket = new PacketContainer(PacketType.Play.Server.SCOREBOARD_DISPLAY_OBJECTIVE);
            displayPacket.getIntegers().writeSafely(0, (Object)0);
            displayPacket.getStrings().writeSafely(0, (Object)OBJECTIVE_NAME);
            PacketManager.sendPacket(displayPacket, (Object)this, this.target);
        }
    }

    public void disableScores() {
        if (this.areScoresEnabled()) {
            this.scoresEnabled = false;
            PacketContainer removePacket = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
            removePacket.getStrings().writeSafely(0, (Object)OBJECTIVE_NAME);
            removePacket.getStrings().writeSafely(1, (Object)OBJECTIVE_NAME);
            removePacket.getIntegers().writeSafely(0, (Object)1);
            PacketManager.sendPacket(removePacket, (Object)this, this.target);
        }
    }
}

