/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tablist;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class PacketUtil {
    public static PacketContainer playerInfoPacket(String displayName, Integer latency, GameMode gameMode, String name, UUID uuid, Skin skin, EnumWrappers.PlayerInfoAction action) {
        PacketContainer result = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        WrappedGameProfile profile = new WrappedGameProfile(uuid, name);
        if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
            if (skin == null) {
                skin = Tablist.DEFAULT_SKIN_TEXTURE;
            }
            profile.getProperties().put((Object)Skin.MULTIMAP_KEY, (Object)skin.toWrappedSignedProperty());
        }
        PlayerInfoData playerInfoData = new PlayerInfoData(profile, Optional.ofNullable(latency).orElse(5).intValue(), Optional.ofNullable(gameMode).map(EnumWrappers.NativeGameMode::fromBukkit).orElse(EnumWrappers.NativeGameMode.NOT_SET), WrappedChatComponent.fromText((String)Optional.ofNullable(displayName).orElse("")));
        result.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
        result.getPlayerInfoAction().writeSafely(0, (Object)action);
        return result;
    }

    public static PacketContainer playerInfoPacket(Player player, EnumWrappers.PlayerInfoAction action) {
        PacketContainer result = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromText((String)player.getPlayerListName()));
        result.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
        result.getPlayerInfoAction().writeSafely(0, (Object)action);
        return result;
    }

    public static PacketContainer scorePacket(String scoreName, String objectiveName, Integer score, EnumWrappers.ScoreboardAction action) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().writeSafely(0, (Object)scoreName);
        packet.getStrings().writeSafely(1, (Object)objectiveName);
        packet.getIntegers().writeSafely(0, (Object)Optional.ofNullable(score).orElse(0));
        packet.getScoreboardActions().writeSafely(0, (Object)action);
        return packet;
    }
}

