/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WebSocket;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Util.UtilScope;
import com.pie.tlatoani.WebSocket.Events.WebSocketCloseEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketErrorEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketMessageEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketOpenEvent;
import java.util.Optional;

public class WebSocketClientFunctionality {
    public final String id;
    private boolean loaded = false;
    public Optional<TriggerItem> onOpen = Optional.empty();
    public Optional<TriggerItem> onClose = Optional.empty();
    public Optional<TriggerItem> onMessage = Optional.empty();
    public Optional<TriggerItem> onError = Optional.empty();

    public WebSocketClientFunctionality() {
        this(null);
    }

    public WebSocketClientFunctionality(String id) {
        this.id = id;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load(Nebula nebula) {
        this.loaded = true;
        this.onOpen = nebula.onOpen.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientOpen", (Class[])new Class[]{WebSocketOpenEvent.class});
            return UtilScope.loadSectionNode(sectionNode, null);
        });
        this.onClose = nebula.onClose.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientClose", (Class[])new Class[]{WebSocketCloseEvent.class});
            return UtilScope.loadSectionNode(sectionNode, null);
        });
        this.onMessage = nebula.onMessage.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientMessage", (Class[])new Class[]{WebSocketMessageEvent.class});
            return UtilScope.loadSectionNode(sectionNode, null);
        });
        this.onError = nebula.onError.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientError", (Class[])new Class[]{WebSocketErrorEvent.class});
            return UtilScope.loadSectionNode(sectionNode, null);
        });
    }

    public void unload() {
        this.loaded = false;
        this.onOpen = Optional.empty();
        this.onClose = Optional.empty();
        this.onMessage = Optional.empty();
        this.onError = Optional.empty();
    }

    public void debugTriggerItems() {
        Mundo.debug((Object)this, "TriggerItems: " + this.onOpen + "," + this.onClose + "," + this.onMessage + "," + this.onError);
    }

    public static class Nebula {
        public Optional<SectionNode> onOpen = Optional.empty();
        public Optional<SectionNode> onClose = Optional.empty();
        public Optional<SectionNode> onMessage = Optional.empty();
        public Optional<SectionNode> onError = Optional.empty();
    }
}

