/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WebSocket;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Util.UtilScope;
import com.pie.tlatoani.WebSocket.WebSocketManager;
import com.pie.tlatoani.WebSocket.WebSocketServerFunctionality;
import java.util.Optional;
import org.bukkit.event.Event;

public class ScopeWebSocketServer
extends SelfRegisteringSkriptEvent {
    private WebSocketServerFunctionality serverFunctionality;
    private WebSocketServerFunctionality.Nebula nebula;

    public void register(Trigger trigger) {
        this.serverFunctionality.load(this.nebula);
        this.serverFunctionality.debugTriggerItems();
    }

    public void unregister(Trigger trigger) {
        this.serverFunctionality.unload();
    }

    public void unregisterAll() {
        WebSocketManager.clearServerFunctionalities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(Literal<?>[] literals, int i, SkriptParser.ParseResult parseResult) {
        this.serverFunctionality = new WebSocketServerFunctionality((String)literals[0].getSingle());
        this.nebula = new WebSocketServerFunctionality.Nebula();
        SectionNode topNode = (SectionNode)SkriptLogger.getNode();
        try {
            if (this.serverFunctionality.isLoaded()) {
                Skript.error((String)"You cannot have two 'websocket server' instances with the same id!");
                boolean bl = false;
                return bl;
            }
            for (Node node : topNode) {
                SkriptLogger.setNode((Node)node);
                Mundo.debug((Object)this, "Current node: " + node.getKey());
                if (!(node instanceof SectionNode)) {
                    Skript.error((String)"'websocket server' should only have sections directly under it!");
                    boolean bl = false;
                    return bl;
                }
                SectionNode subNode = (SectionNode)node;
                if (subNode.getKey().equals("on start")) {
                    if (this.nebula.onStart.isPresent()) {
                        Skript.error((String)"You cannot have two 'on start' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onStart = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on stop")) {
                    if (this.nebula.onStop.isPresent()) {
                        Skript.error((String)"You cannot have two 'on stop' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onStop = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on open")) {
                    if (this.nebula.onOpen.isPresent()) {
                        Skript.error((String)"You cannot have two 'on open' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onOpen = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on close")) {
                    if (this.nebula.onClose.isPresent()) {
                        Skript.error((String)"You cannot have two 'on close' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onClose = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on message")) {
                    if (this.nebula.onMessage.isPresent()) {
                        Skript.error((String)"You cannot have two 'on message' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onMessage = Optional.of(subNode);
                    continue;
                }
                if (subNode.getKey().equals("on error")) {
                    if (this.nebula.onError.isPresent()) {
                        Skript.error((String)"You cannot have two 'on error' sections here!");
                        boolean bl = false;
                        return bl;
                    }
                    this.nebula.onError = Optional.of(subNode);
                    continue;
                }
                Skript.error((String)"The only sections allowed under 'websocket server' are 'on start', 'on stop', 'on open', 'on close', 'on message', and 'on error'!");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            UtilScope.removeSubNodes(topNode);
        }
    }

    public String toString(Event event, boolean b) {
        return "websocket server \"" + this.serverFunctionality.id + "\"";
    }
}

