/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Array;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.UtilPacketEvent;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tablist;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.entity.Player;

public class ArrayTablist {
    private final Tablist tablist;
    private final String[][] displayNames = new String[4][20];
    private final int[][] latencies = new int[4][20];
    private final Skin[][] heads = new Skin[4][20];
    private final int[][] scores = new int[4][20];
    private static final String uuidbeginning = "10001000-1000-3000-8000-10001000";
    private int columns = 0;
    private int rows = 0;
    public Skin initialIcon = Tablist.DEFAULT_SKIN_TEXTURE;

    public ArrayTablist(Tablist tablist) {
        this.tablist = tablist;
    }

    public static int getViableRowAmount(int columns, int rows) {
        return columns == 1 ? Mundo.limitToRange(1, rows, 20) : (columns == 2 ? Mundo.limitToRange(11, rows, 20) : (columns == 3 ? Mundo.limitToRange(14, rows, 20) : (columns == 4 ? Mundo.limitToRange(16, rows, 20) : 0)));
    }

    private void sendPacketToAll(int column, int row, EnumWrappers.PlayerInfoAction action) {
        this.sendPacket(column, row, action, this.tablist.players);
    }

    private void sendPacket(int column, int row, EnumWrappers.PlayerInfoAction action, Collection<Player> players) {
        Mundo.debug((Object)this, "SENDING PACKET col = " + column + ", row = " + row + " action = " + action + "players = " + players);
        int ping = this.latencies[column - 1][row - 1];
        String displayName = this.displayNames[column - 1][row - 1];
        Skin icon = this.heads[column - 1][row - 1];
        Mundo.debug((Object)this, "SP 1");
        WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(displayName));
        int identifier = (column - 1) * 20 + row;
        UUID uuid = UUID.fromString("10001000-1000-3000-8000-1000100010" + Mundo.toHexDigit(Mundo.divideNoRemainder(identifier, 10)) + identifier % 10);
        WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, "MundoSK::" + (identifier < 10 ? "0" : "") + identifier);
        Mundo.debug((Object)this, "SP 2");
        if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
            if (icon == null) {
                icon = Tablist.DEFAULT_SKIN_TEXTURE;
            }
            gameProfile.getProperties().put((Object)Skin.MULTIMAP_KEY, (Object)icon.toWrappedSignedProperty());
        }
        Mundo.debug((Object)this, "SP 3");
        PlayerInfoData playerInfoData = new PlayerInfoData(gameProfile, ping, EnumWrappers.NativeGameMode.NOT_SET, chatComponent);
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        packetContainer.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
        packetContainer.getPlayerInfoAction().writeSafely(0, (Object)action);
        Mundo.debug((Object)this, "SP 4");
        try {
            for (Player player : players) {
                Mundo.debug((Object)this, "SENDING PACKET col = " + column + ", row = " + row + " action = " + action + ", player = " + player);
                UtilPacketEvent.protocolManager.sendServerPacket(player, packetContainer);
            }
        }
        catch (InvocationTargetException e) {
            Mundo.reportException(this, e);
        }
    }

    private void sendScorePacketToAll(int column, int row) {
        this.sendScorePacket(column, row, this.tablist.players);
    }

    private void sendScorePacket(int column, int row, Collection<Player> players) {
        if (!this.tablist.areScoresEnabled()) {
            return;
        }
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        int identifier = (column - 1) * 20 + row;
        packet.getStrings().writeSafely(0, (Object)("MundoSK::" + (identifier < 10 ? "0" : "") + identifier));
        packet.getStrings().writeSafely(1, (Object)"MundoSK_Tablist");
        packet.getIntegers().writeSafely(0, (Object)this.scores[column - 1][row - 1]);
        packet.getScoreboardActions().writeSafely(0, (Object)EnumWrappers.ScoreboardAction.CHANGE);
        for (Player player : players) {
            try {
                UtilPacketEvent.protocolManager.sendServerPacket(player, packet);
            }
            catch (InvocationTargetException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        Mundo.debug((Object)this, "Got here, this.columns " + this.columns + ", this.rows " + this.rows + ", columns " + columns);
        columns = Mundo.limitToRange(0, columns, 4);
        if (columns == this.columns) {
            return;
        }
        if (columns != 0) {
            Mundo.debug((Object)this, "Columns != 0");
            this.tablist.simpleTablist.clear();
            if (columns != 4 && !this.tablist.areAllPlayersHidden()) {
                Mundo.debug((Object)this, "Hiding all players");
                this.tablist.hideAllPlayers();
            }
        }
        if (columns > this.columns) {
            Mundo.debug((Object)this, "columns > this.columns");
            if (this.columns == 0) {
                this.rows = ArrayTablist.getViableRowAmount(columns, this.rows);
            } else {
                this.setRows(ArrayTablist.getViableRowAmount(columns, this.rows));
            }
            for (int column = this.columns + 1; column <= columns; ++column) {
                for (int row = 1; row <= this.rows; ++row) {
                    Mundo.debug((Object)this, "col: " + column + ", ro: " + row);
                    this.displayNames[column - 1][row - 1] = "";
                    this.latencies[column - 1][row - 1] = 5;
                    this.heads[column - 1][row - 1] = this.initialIcon;
                    this.scores[column - 1][row - 1] = 0;
                    this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    if (!this.tablist.areScoresEnabled()) continue;
                    this.sendScorePacketToAll(column, row);
                }
            }
        } else {
            for (int column = columns + 1; column <= this.columns; ++column) {
                for (int row = 1; row <= this.rows; ++row) {
                    this.displayNames[column - 1][row - 1] = "";
                    this.latencies[column - 1][row - 1] = 5;
                    this.heads[column - 1][row - 1] = null;
                    this.scores[column - 1][row - 1] = 0;
                    this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    if (!this.tablist.areScoresEnabled()) continue;
                    this.sendScorePacketToAll(column, row);
                }
            }
        }
        this.columns = columns;
        if (columns == 0) {
            this.rows = 0;
        }
    }

    public void setRows(int rows) {
        Mundo.debug((Object)this, "Got here, this.columns " + this.columns + ", this.rows " + this.rows + ", rows " + rows);
        rows = ArrayTablist.getViableRowAmount(this.columns, rows);
        if (rows == this.rows) {
            return;
        }
        if (!this.tablist.areAllPlayersHidden()) {
            Mundo.debug((Object)this, "Rows != 20, Hiding all players");
            this.tablist.hideAllPlayers();
        }
        if (rows > this.rows) {
            for (int column = 1; column <= this.columns; ++column) {
                for (int row = this.rows + 1; row <= rows; ++row) {
                    this.displayNames[column - 1][row - 1] = "";
                    this.latencies[column - 1][row - 1] = 5;
                    this.heads[column - 1][row - 1] = this.initialIcon;
                    this.scores[column - 1][row - 1] = 0;
                    this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    this.sendScorePacketToAll(column, row);
                }
            }
        } else {
            for (int column = 1; column <= this.columns; ++column) {
                for (int row = rows + 1; row <= this.rows; ++row) {
                    this.displayNames[column - 1][row - 1] = "";
                    this.latencies[column - 1][row - 1] = 5;
                    this.heads[column - 1][row - 1] = null;
                    this.scores[column - 1][row - 1] = 0;
                    this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                }
            }
        }
        this.rows = rows;
    }

    public void addPlayers(Collection<Player> players) {
        for (int column = 1; column <= this.columns; ++column) {
            for (int row = 1; row <= this.rows; ++row) {
                this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER, players);
                this.sendScorePacketToAll(column, row);
            }
        }
    }

    public void removePlayers(Collection<Player> players) {
        for (int column = 1; column <= this.columns; ++column) {
            for (int row = 1; row <= this.rows; ++row) {
                this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER, players);
            }
        }
    }

    public String getDisplayName(int column, int row) {
        return Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows) ? this.displayNames[column - 1][row - 1] : null;
    }

    public int getLatency(int column, int row) {
        return Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows) ? this.latencies[column - 1][row - 1] : 0;
    }

    public Skin getHead(int column, int row) {
        return Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows) ? this.heads[column - 1][row - 1] : null;
    }

    public int getScore(int column, int row) {
        return Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows) ? this.scores[column - 1][row - 1] : 0;
    }

    public void setDisplayName(int column, int row, String displayName) {
        if (Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows)) {
            this.displayNames[column - 1][row - 1] = displayName;
            this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
        }
    }

    public void setLatency(int column, int row, int ping) {
        if (Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows)) {
            this.latencies[column - 1][row - 1] = ping;
            this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.UPDATE_LATENCY);
        }
    }

    public void setHead(int column, int row, Skin head) {
        if (Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows)) {
            this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            this.heads[column - 1][row - 1] = head;
            this.sendPacketToAll(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        }
    }

    public void setScore(int column, int row, int ping) {
        if (Mundo.isInRange(1.0, column, this.columns) && Mundo.isInRange(1.0, row, this.rows)) {
            this.scores[column - 1][row - 1] = ping;
            this.sendScorePacketToAll(column, row);
        }
    }
}

