/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental;

import com.google.common.collect.ImmutableList;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ZExperimental.ExpressionConstraints;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public abstract class SyntaxPiece {
    public final boolean containsVariables = this.containsVariables();
    public final int markLength = this.markLength();
    public final int expressionAmount = this.expressionAmount();

    public abstract boolean containsVariables();

    public abstract int markLength();

    public abstract int expressionAmount();

    public abstract void setConstraints(ExpressionConstraints.Collective var1);

    public abstract String readableSyntax();

    public abstract String actualSyntax(int var1);

    public abstract void setInformation(MarkSpecificInformation var1, int var2, int var3);

    public abstract String toString(int var1);

    public static class Concatenation
    extends SyntaxPiece {
        public final ImmutableList<SyntaxPiece> pieces;

        public Concatenation(ImmutableList<SyntaxPiece> pieces) {
            this.pieces = pieces;
        }

        @Override
        public boolean containsVariables() {
            for (SyntaxPiece syntaxPiece : this.pieces) {
                if (!syntaxPiece.containsVariables) continue;
                return true;
            }
            return false;
        }

        @Override
        public int markLength() {
            int result = 0;
            for (SyntaxPiece syntaxPiece : this.pieces) {
                result += syntaxPiece.markLength;
            }
            return result;
        }

        @Override
        public int expressionAmount() {
            int result = 0;
            for (SyntaxPiece syntaxPiece : this.pieces) {
                result += syntaxPiece.expressionAmount;
            }
            return result;
        }

        @Override
        public void setConstraints(ExpressionConstraints.Collective constraints) {
            for (SyntaxPiece piece : this.pieces) {
                piece.setConstraints(constraints);
            }
        }

        @Override
        public String readableSyntax() {
            StringJoiner joiner = new StringJoiner("");
            for (SyntaxPiece syntaxPiece : this.pieces) {
                joiner.add(syntaxPiece.readableSyntax());
            }
            return joiner.toString();
        }

        @Override
        public String actualSyntax(int prevMarkLength) {
            StringJoiner joiner = new StringJoiner("");
            for (SyntaxPiece syntaxPiece : this.pieces) {
                joiner.add(syntaxPiece.actualSyntax(prevMarkLength));
                prevMarkLength += syntaxPiece.markLength;
            }
            return joiner.toString();
        }

        @Override
        public void setInformation(MarkSpecificInformation information, int mark, int prevExprAmount) {
            for (SyntaxPiece syntaxPiece : this.pieces) {
                syntaxPiece.setInformation(information, mark % (2 ^ syntaxPiece.markLength), prevExprAmount);
                mark >>= syntaxPiece.markLength;
                prevExprAmount += syntaxPiece.expressionAmount;
            }
        }

        @Override
        public String toString(int mark) {
            String result = "";
            for (SyntaxPiece syntaxPiece : this.pieces) {
                String curr = syntaxPiece.toString(mark % (2 ^ syntaxPiece.markLength));
                if (result.length() > 0 && result.charAt(result.length() - 1) == ' ' && curr.length() > 0 && curr.charAt(0) == ' ') {
                    curr = curr.substring(1);
                }
                result = result + curr;
                mark >>= syntaxPiece.markLength;
            }
            return result;
        }
    }

    public static class Varying
    extends SyntaxPiece {
        public final ImmutableList<SyntaxPiece> options;
        public final Optional<String> variable;
        public final boolean isOptional = this.isOptional();

        public Varying(ImmutableList<SyntaxPiece> options, Optional<String> variable) {
            this.options = options;
            this.variable = variable;
        }

        public boolean isOptional() {
            return ((SyntaxPiece)this.options.get(0)).equals(Literal.EMPTY);
        }

        @Override
        public boolean containsVariables() {
            if (this.variable.isPresent()) {
                return true;
            }
            for (SyntaxPiece syntaxPiece : this.options) {
                if (!syntaxPiece.containsVariables) continue;
                return true;
            }
            return false;
        }

        @Override
        public int markLength() {
            int result = 0;
            for (SyntaxPiece syntaxPiece : this.options) {
                result = Math.max(result, syntaxPiece.markLength());
            }
            if (this.containsVariables()) {
                result += Mundo.digitsInBase(this.options.size() - 1, 2);
            }
            return result;
        }

        @Override
        public int expressionAmount() {
            int result = 0;
            for (SyntaxPiece syntaxPiece : this.options) {
                result += syntaxPiece.expressionAmount;
            }
            return result;
        }

        @Override
        public void setConstraints(ExpressionConstraints.Collective constraints) {
            for (SyntaxPiece option : this.options) {
                option.setConstraints(constraints);
            }
        }

        @Override
        public String readableSyntax() {
            StringJoiner joiner = new StringJoiner("|", this.isOptional ? "[" : "(", this.isOptional ? "]" : ")");
            for (SyntaxPiece syntaxPiece : this.options) {
                if (syntaxPiece.equals(Literal.EMPTY)) continue;
                joiner.add(syntaxPiece.readableSyntax());
            }
            return joiner.toString();
        }

        @Override
        public String actualSyntax(int prevMarkLength) {
            if (this.isOptional && this.options.size() == 2) {
                return "[" + ((SyntaxPiece)this.options.get(1)).actualSyntax(prevMarkLength) + "]";
            }
            StringJoiner joiner = new StringJoiner("|", this.isOptional ? "[(" : "(", this.isOptional ? ")]" : ")");
            if (this.containsVariables()) {
                int i;
                String markSuffix = String.join((CharSequence)"", Collections.nCopies(prevMarkLength, "0"));
                int n = i = this.isOptional() ? 1 : 0;
                while (i < this.options.size()) {
                    joiner.add(i + markSuffix + "\u00a6" + ((SyntaxPiece)this.options.get(i)).actualSyntax(prevMarkLength + this.markLength));
                    ++i;
                }
            } else {
                for (SyntaxPiece syntaxPiece : this.options) {
                    if (syntaxPiece.equals(Literal.EMPTY)) continue;
                    joiner.add(syntaxPiece.actualSyntax(prevMarkLength));
                }
            }
            return joiner.toString();
        }

        @Override
        public void setInformation(MarkSpecificInformation information, int mark, int prevExprAmount) {
            int optionIndex = mark % (2 ^ this.markLength);
            int nextMark = mark >> this.markLength;
            this.variable.ifPresent(var -> information.markVarValues.put((String)var, optionIndex));
            for (int i = 0; i < optionIndex; ++i) {
                prevExprAmount += ((SyntaxPiece)this.options.get((int)i)).expressionAmount;
            }
            ((SyntaxPiece)this.options.get(optionIndex)).setInformation(information, nextMark, prevExprAmount);
        }

        @Override
        public String toString(int mark) {
            if (!this.containsVariables()) {
                return ((SyntaxPiece)this.options.get(0)).toString(0);
            }
            int optionIndex = mark % (2 ^ this.markLength);
            int nextMark = mark >> this.markLength;
            return ((SyntaxPiece)this.options.get(optionIndex)).toString(nextMark);
        }
    }

    public static class Expression
    extends SyntaxPiece {
        public final String variable;
        public final String exprInfo;
        public final ExpressionConstraints constraints;

        public Expression(String variable, String exprInfo) {
            this.variable = variable;
            this.exprInfo = exprInfo;
            this.constraints = ExpressionConstraints.fromString(exprInfo);
        }

        @Override
        public boolean containsVariables() {
            return true;
        }

        @Override
        public int markLength() {
            return 0;
        }

        @Override
        public int expressionAmount() {
            return 1;
        }

        @Override
        public void setConstraints(ExpressionConstraints.Collective constraints) {
            constraints.addConstraints(this.variable, this.constraints);
        }

        @Override
        public String readableSyntax() {
            return "%" + this.exprInfo + "%";
        }

        @Override
        public String actualSyntax(int prevMarkLength) {
            return "%" + this.exprInfo + "%";
        }

        @Override
        public void setInformation(MarkSpecificInformation information, int mark, int prevExprAmount) {
            information.exprIndexes.put(this.variable, prevExprAmount);
        }

        @Override
        public String toString(int mark) {
            return "%" + this.variable + "%";
        }
    }

    public static class Literal
    extends SyntaxPiece {
        public final String text;
        public static final Literal EMPTY = new Literal("");

        public Literal(String text) {
            this.text = text;
        }

        public boolean equals(Object object) {
            return object instanceof Literal && this.text.equals(((Literal)object).text);
        }

        @Override
        public boolean containsVariables() {
            return false;
        }

        @Override
        public int markLength() {
            return 0;
        }

        @Override
        public int expressionAmount() {
            return 0;
        }

        @Override
        public void setConstraints(ExpressionConstraints.Collective constraints) {
        }

        @Override
        public String readableSyntax() {
            return this.text;
        }

        @Override
        public String actualSyntax(int prevMarkLength) {
            return this.text;
        }

        @Override
        public void setInformation(MarkSpecificInformation information, int mark, int prevExprAmount) {
        }

        @Override
        public String toString(int mark) {
            return this.text;
        }
    }

    public static class MarkSpecificInformation {
        public final Map<String, Integer> exprIndexes = new HashMap<String, Integer>();
        public final Map<String, Integer> markVarValues = new HashMap<String, Integer>();
    }
}

