/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WebSocket;

import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.WebSocket.SkriptWebSocketServer;
import com.pie.tlatoani.WebSocket.WebSocketClientFunctionality;
import com.pie.tlatoani.WebSocket.WebSocketServerFunctionality;
import java.util.HashMap;
import java.util.Map;

public class WebSocketManager {
    private static Map<String, WebSocketClientFunctionality> clientFunctionalities = new HashMap<String, WebSocketClientFunctionality>();
    private static Map<String, WebSocketServerFunctionality> serverFunctionalities = new HashMap<String, WebSocketServerFunctionality>();
    private static Map<Integer, SkriptWebSocketServer> servers = new HashMap<Integer, SkriptWebSocketServer>();

    public static WebSocketClientFunctionality getClientFunctionality(String id) {
        return clientFunctionalities.computeIfAbsent(id, __ -> new WebSocketClientFunctionality(id));
    }

    public static void clearClientFunctionalities() {
        clientFunctionalities.values().forEach(WebSocketClientFunctionality::unload);
    }

    public static WebSocketServerFunctionality getServerFunctionality(String id) {
        return serverFunctionalities.computeIfAbsent(id, __ -> new WebSocketServerFunctionality(id));
    }

    public static void clearServerFunctionalities() {
        serverFunctionalities.values().forEach(WebSocketServerFunctionality::unload);
    }

    public static SkriptWebSocketServer getServer(int port) {
        return servers.get(port);
    }

    public static SkriptWebSocketServer startServer(int port, String id) {
        SkriptWebSocketServer server = new SkriptWebSocketServer(WebSocketManager.getServerFunctionality(id), port);
        if (servers.computeIfAbsent(port, __ -> server) != server) {
            throw new IllegalArgumentException("There is already a WebSocketServer put at the port " + port);
        }
        server.start();
        return server;
    }

    public static void stopServer(int port, int timeout) {
        SkriptWebSocketServer server = servers.get(port);
        if (server != null) {
            try {
                server.stop(timeout);
                servers.remove(port);
            }
            catch (InterruptedException e) {
                Mundo.reportException(WebSocketManager.class, e);
            }
        }
    }
}

