/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.PacketInfoConverter;
import com.pie.tlatoani.Util.UtilReflection;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ExprObjectOfPacket
extends SimpleExpression<Object> {
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private boolean isSingle;
    private Class aClass;
    private PacketInfoConverter converter;
    private static Map<String, PacketInfoConverter> singleConverters = new LinkedHashMap<String, PacketInfoConverter>();
    private static Map<String, PacketInfoConverter<Object[]>> pluralConverters = new LinkedHashMap<String, PacketInfoConverter<Object[]>>();

    private static <T> void registerSingleConverter(String key, PacketInfoConverter<T> converter) {
        singleConverters.put(key, converter);
    }

    private static void registerPluralConverter(String key, PacketInfoConverter<Object[]> converter) {
        pluralConverters.put(key, converter);
    }

    private static PacketInfoConverter getConverter(String key, Boolean isSingle) {
        return isSingle != false ? singleConverters.get(key) : pluralConverters.get(key);
    }

    public static String getConverterNamesPattern(Boolean isSingle) {
        String result = "";
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            result = result + "|" + ++i + "\u00a6" + name;
        }
        return result;
    }

    public static String getConverterNameByIndex(int index, Boolean isSingle) {
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            if (++i != index) continue;
            return name;
        }
        return null;
    }

    private static PacketInfoConverter createConverter(final Method method) {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.CHAT);
        try {
            StructureModifier tempStructureModifier = (StructureModifier)method.invoke((Object)packetContainer, new Object[0]);
            if (!tempStructureModifier.getFieldType().isArray()) {
                return new PacketInfoConverter(){

                    public Object get(PacketContainer packet, Integer index) {
                        try {
                            StructureModifier structureModifier = (StructureModifier)method.invoke((Object)packet, new Object[0]);
                            return structureModifier.readSafely(index.intValue());
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            Mundo.debug((Object)this, e);
                            return null;
                        }
                    }

                    public void set(PacketContainer packet, Integer index, Object value) {
                        try {
                            StructureModifier structureModifier = (StructureModifier)method.invoke((Object)packet, new Object[0]);
                            structureModifier.writeSafely(index.intValue(), value);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            Mundo.debug((Object)this, e);
                        }
                    }
                };
            }
            return new PacketInfoConverter(){

                public Object get(PacketContainer packet, Integer index) {
                    try {
                        StructureModifier structureModifier = (StructureModifier)method.invoke((Object)packet, new Object[0]);
                        return structureModifier.readSafely(index.intValue());
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        Mundo.debug((Object)this, e);
                        return null;
                    }
                }

                public void set(PacketContainer packet, Integer index, Object value) {
                    try {
                        StructureModifier structureModifier = (StructureModifier)method.invoke((Object)packet, new Object[0]);
                        Object[] valueArray = (Object[])value;
                        Object[] result = (Object[])Array.newInstance(structureModifier.getFieldType().getComponentType(), valueArray.length);
                        for (int i = 0; i < valueArray.length; ++i) {
                            result[i] = valueArray[i];
                        }
                        structureModifier.writeSafely(index.intValue(), (Object)result);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        Mundo.debug((Object)this, e);
                    }
                }
            };
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Mundo.reportException(ExprObjectOfPacket.class, e);
            return null;
        }
    }

    protected Object[] get(Event event) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        if (this.isSingle) {
            return new Object[]{this.converter.get(packet, index)};
        }
        return (Object[])this.converter.get(packet, index);
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<?> getReturnType() {
        return this.aClass;
    }

    public String toString(Event event, boolean b) {
        return "%type/string% packetinfo %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String methodGetName;
        String key;
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        this.isSingle = i % 2 == 0;
        Class clazz = this.aClass = this.isSingle ? Object.class : Object[].class;
        if (expressions[0] == null) {
            key = ExprObjectOfPacket.getConverterNameByIndex(parseResult.mark, this.isSingle);
            methodGetName = null;
        } else if (expressions[0] instanceof Literal && expressions[0].getReturnType() == ClassInfo.class) {
            ClassInfo classInfo = (ClassInfo)((Literal)expressions[0]).getSingle();
            key = classInfo.getCodeName();
            this.aClass = this.isSingle ? classInfo.getC() : Array.newInstance(classInfo.getC(), 0).getClass();
            String classname = classInfo.getC().getSimpleName();
            Mundo.debug((Object)this, "Class simple name: " + classname);
            methodGetName = !this.isSingle ? classname + "Arrays" : (classname.substring(classname.length() - 1).equals("y") ? classname.substring(0, classname.length() - 1) + "ies" : classname + "s");
        } else {
            if (!(expressions[0] instanceof VariableString)) {
                Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the %string% pinfo expression!"));
                return false;
            }
            String fullstring = ((VariableString)expressions[0]).toString();
            methodGetName = fullstring.substring(1, fullstring.length() - 1);
            key = methodGetName.toLowerCase();
        }
        this.converter = ExprObjectOfPacket.getConverter(key, this.isSingle);
        if (this.converter != null) {
            this.aClass = Optional.ofNullable(this.converter.getType()).orElse(this.aClass);
            Mundo.debug((Object)this, "Converter to PLib type: " + key + ", aClass = " + this.aClass);
            return true;
        }
        try {
            Method method = PacketContainer.class.getMethod("get" + methodGetName, new Class[0]);
            Mundo.debug((Object)this, "Method: " + method.toString() + ", aClass = " + this.aClass);
            this.converter = ExprObjectOfPacket.createConverter(method);
            return true;
        }
        catch (NoSuchMethodException e) {
            Mundo.debug((Object)this, e);
            Skript.error((String)(key + " is not applicable for the '%type/string% pinfo [array] %number% of %packet%' expression."));
            return false;
        }
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        this.converter.set(packet, index, this.isSingle ? delta[0] : delta);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.aClass});
        }
        return null;
    }

    static {
        ExprObjectOfPacket.registerSingleConverter("object", new PacketInfoConverter<Object>(){

            @Override
            public Object get(PacketContainer packet, Integer index) {
                return packet.getModifier().readSafely(index.intValue());
            }

            @Override
            public void set(PacketContainer packet, Integer index, Object value) {
                packet.getModifier().writeSafely(index.intValue(), value);
            }
        });
        ExprObjectOfPacket.registerSingleConverter("location", new PacketInfoConverter<Location>(){

            @Override
            public Location get(PacketContainer packet, Integer index) {
                StructureModifier structureModifier = packet.getBlockPositionModifier();
                BlockPosition blockPosition = (BlockPosition)structureModifier.readSafely(index.intValue());
                if (blockPosition == null) {
                    return null;
                }
                return blockPosition.toLocation((World)Bukkit.getWorlds().get(0));
            }

            @Override
            public void set(PacketContainer packet, Integer index, Location value) {
                StructureModifier structureModifier = packet.getBlockPositionModifier();
                BlockPosition blockPosition = new BlockPosition(value.toVector());
                structureModifier.writeSafely(index.intValue(), (Object)blockPosition);
            }

            @Override
            public Class<Location> getType() {
                return Location.class;
            }
        });
        ExprObjectOfPacket.registerSingleConverter("uuid", new PacketInfoConverter<String>(){

            @Override
            public String get(PacketContainer packet, Integer index) {
                return Optional.ofNullable(packet.getUUIDs().readSafely(index.intValue())).map(UUID::toString).orElse(null);
            }

            @Override
            public void set(PacketContainer packet, Integer index, String value) {
                packet.getUUIDs().writeSafely(index.intValue(), (Object)UUID.fromString(value));
            }

            @Override
            public Class<String> getType() {
                return String.class;
            }
        });
        ExprObjectOfPacket.registerSingleConverter("material", new PacketInfoConverter<ItemStack>(){

            @Override
            public ItemStack get(PacketContainer packet, Integer index) {
                Material material = (Material)packet.getBlocks().readSafely(index.intValue());
                return material == null ? null : new ItemStack(material);
            }

            @Override
            public void set(PacketContainer packet, Integer index, ItemStack value) {
                Material material = value.getType();
                packet.getBlocks().writeSafely(index.intValue(), (Object)material);
            }

            @Override
            public Class<ItemStack> getType() {
                return ItemStack.class;
            }
        });
        try {
            final Class<?> nmsItemClass = UtilReflection.getMinecraftClass("Item");
            final UtilReflection.MethodInvoker asNMSCopy = UtilReflection.getTypedMethod(UtilReflection.getCraftBukkitClass("inventory.CraftItemStack"), "asNMSCopy", UtilReflection.getMinecraftClass("ItemStack"), ItemStack.class);
            final UtilReflection.MethodInvoker getNMSItem = UtilReflection.getTypedMethod(UtilReflection.getMinecraftClass("ItemStack"), "getItem", nmsItemClass, new Class[0]);
            final UtilReflection.MethodInvoker asNewCraftStack = UtilReflection.getTypedMethod(UtilReflection.getCraftBukkitClass("inventory.CraftItemStack"), "asNewCraftStack", UtilReflection.getCraftBukkitClass("inventory.CraftItemStack"), nmsItemClass);
            EquivalentConverter<ItemStack> itemConvert = new EquivalentConverter<ItemStack>(){

                public ItemStack getSpecific(Object o) {
                    return (ItemStack)asNewCraftStack.invoke(null, o);
                }

                public Object getGeneric(Class<?> aClass, ItemStack itemStack) {
                    return getNMSItem.invoke(asNMSCopy.invoke(null, itemStack), new Object[0]);
                }

                public Class<ItemStack> getSpecificType() {
                    return ItemStack.class;
                }
            };
            ExprObjectOfPacket.registerSingleConverter("item", new PacketInfoConverter<ItemStack>((EquivalentConverter)itemConvert){
                final /* synthetic */ EquivalentConverter val$itemConvert;
                {
                    this.val$itemConvert = equivalentConverter;
                }

                @Override
                public ItemStack get(PacketContainer packet, Integer index) {
                    StructureModifier structureModifier = packet.getModifier().withType(nmsItemClass, this.val$itemConvert);
                    return (ItemStack)structureModifier.readSafely(index.intValue());
                }

                @Override
                public void set(PacketContainer packet, Integer index, ItemStack value) {
                    StructureModifier structureModifier = packet.getModifier().withType(nmsItemClass, this.val$itemConvert);
                    structureModifier.writeSafely(index.intValue(), (Object)value);
                }

                @Override
                public Class<ItemStack> getType() {
                    return ItemStack.class;
                }
            });
        }
        catch (Exception e) {
            Mundo.reportException(ExprObjectOfPacket.class, e);
        }
        ExprObjectOfPacket.registerSingleConverter("blockdata", new PacketInfoConverter<ItemStack>(){

            @Override
            public ItemStack get(PacketContainer packet, Integer index) {
                WrappedBlockData blockData = (WrappedBlockData)packet.getBlockData().readSafely(index.intValue());
                ItemStack itemStack = new ItemStack(blockData.getType());
                itemStack.setData(new MaterialData(blockData.getType(), new Integer(blockData.getData()).byteValue()));
                return itemStack;
            }

            @Override
            public void set(PacketContainer packet, Integer index, ItemStack value) {
                WrappedBlockData blockData = WrappedBlockData.createData((Material)value.getType(), (int)value.getData().getData());
                packet.getBlockData().writeSafely(index.intValue(), (Object)blockData);
            }

            @Override
            public Class<ItemStack> getType() {
                return ItemStack.class;
            }
        });
        ExprObjectOfPacket.registerPluralConverter("collection", new PacketInfoConverter<Object[]>(){

            @Override
            public Object[] get(PacketContainer packet, Integer index) {
                Collection collection = (Collection)packet.getSpecificModifier(Collection.class).readSafely(index.intValue());
                return collection == null ? new Object[]{} : collection.toArray();
            }

            @Override
            public void set(PacketContainer packet, Integer index, Object[] value) {
                packet.getSpecificModifier(Collection.class).writeSafely(index.intValue(), Arrays.asList(value));
            }
        });
        final UtilReflection.ConstructorInvoker packetDataSerializerConstructor = UtilReflection.getConstructor(UtilReflection.getMinecraftClass("PacketDataSerializer"), ByteBuf.class);
        ExprObjectOfPacket.registerPluralConverter("bytebuffer", new PacketInfoConverter<Object[]>(){

            @Override
            public Object[] get(PacketContainer packet, Integer index) {
                ByteBuf byteBuf = (ByteBuf)packet.getSpecificModifier(ByteBuf.class).readSafely(index.intValue());
                byte[] bytes = byteBuf.array();
                Object[] result = new Object[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    result[i] = bytes[i];
                }
                return result;
            }

            @Override
            public void set(PacketContainer packet, Integer index, Object[] value) {
                byte[] bytes = new byte[value.length];
                for (int i = 0; i < value.length; ++i) {
                    bytes[i] = ((Number)value[i]).byteValue();
                }
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
                ByteBuf packetDataSerializer = (ByteBuf)packetDataSerializerConstructor.invoke(byteBuf);
                packet.getSpecificModifier(ByteBuf.class).writeSafely(index.intValue(), (Object)packetDataSerializer);
            }

            @Override
            public Class<Number[]> getType() {
                return Number[].class;
            }
        });
    }
}

