/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Chunk;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprChunk
extends SimpleExpression<Chunk> {
    private Expression<Number> x1Expr;
    private Expression<Number> z1Expr;
    private Expression<Number> x2Expr;
    private Expression<Number> z2Expr;
    private Expression<World> worldExpression;
    private Expression<Location> loc1Expr;
    private Expression<Location> loc2Expr;
    private boolean single;
    private boolean coords;

    protected Chunk[] get(Event event) {
        int z2;
        int x2;
        World world;
        int z1;
        int x1;
        if (this.coords) {
            x1 = ((Number)this.x1Expr.getSingle(event)).intValue();
            z1 = ((Number)this.z1Expr.getSingle(event)).intValue();
            world = (World)this.worldExpression.getSingle(event);
        } else {
            Location loc1 = (Location)this.loc1Expr.getSingle(event);
            x1 = loc1.getBlockX() >> 4;
            z1 = loc1.getBlockZ() >> 4;
            world = loc1.getWorld();
        }
        if (this.single) {
            return new Chunk[]{world.getChunkAt(x1, z1)};
        }
        if (this.coords) {
            x2 = ((Number)this.x2Expr.getSingle(event)).intValue();
            z2 = ((Number)this.z2Expr.getSingle(event)).intValue();
        } else {
            Location loc2 = (Location)this.loc2Expr.getSingle(event);
            if (!world.equals(loc2.getWorld())) {
                return new Chunk[0];
            }
            x2 = loc2.getBlockX() >> 4;
            z2 = loc2.getBlockZ() >> 4;
        }
        int xmin = Math.min(x1, x2);
        int xmax = Math.max(x1, x2);
        int zmin = Math.min(z1, z2);
        int zmax = Math.max(z1, z2);
        int zn = zmax - zmin + 1;
        Chunk[] chunks = new Chunk[(xmax - xmin + 1) * zn];
        for (int x = xmin; x <= xmax; ++x) {
            for (int z = zmin; z <= zmax; ++z) {
                chunks[(x - xmin) * zn + z - zmin] = world.getChunkAt(x, z);
            }
        }
        return chunks;
    }

    public Iterator<Chunk> iterator(Event event) {
        int z2;
        int x2;
        int z1;
        int x1;
        World world;
        if (this.coords) {
            world = (World)this.worldExpression.getSingle(event);
            x1 = ((Number)this.x1Expr.getSingle(event)).intValue();
            z1 = ((Number)this.z1Expr.getSingle(event)).intValue();
            x2 = ((Number)this.x2Expr.getSingle(event)).intValue();
            z2 = ((Number)this.z2Expr.getSingle(event)).intValue();
        } else {
            Location loc1 = (Location)this.loc1Expr.getSingle(event);
            Location loc2 = (Location)this.loc2Expr.getSingle(event);
            if (!loc1.getWorld().equals(loc2.getWorld())) {
                return Iterators.emptyIterator();
            }
            world = loc1.getWorld();
            x1 = loc1.getBlockX() >> 4;
            z1 = loc1.getBlockZ() >> 4;
            x2 = loc2.getBlockX() >> 4;
            z2 = loc2.getBlockZ() >> 4;
        }
        final int xmin = Math.min(x1, x2);
        final int xmax = Math.max(x1, x2);
        final int zmin = Math.min(z1, z2);
        final int zmax = Math.max(z1, z2);
        return new Iterator<Chunk>(){
            int x;
            int z;
            {
                this.x = xmin;
                this.z = zmin;
            }

            @Override
            public boolean hasNext() {
                return this.x <= xmax;
            }

            @Override
            public Chunk next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Chunk result = world.getChunkAt(this.x, this.z);
                if (this.z < zmax) {
                    ++this.z;
                } else {
                    this.z = zmin;
                    ++this.x;
                }
                return result;
            }
        };
    }

    public boolean isSingle() {
        return this.single;
    }

    public Class<? extends Chunk> getReturnType() {
        return Chunk.class;
    }

    public String toString(Event event, boolean b) {
        if (this.coords) {
            if (this.single) {
                return "chunk " + this.x1Expr + ", " + this.z1Expr + " in " + this.worldExpression;
            }
            return "chunks from " + this.x1Expr + ", " + this.z1Expr + " to " + this.x2Expr + ", " + this.z2Expr + " in " + this.worldExpression;
        }
        if (this.single) {
            return "chunk at " + this.loc1Expr;
        }
        return "chunks from " + this.loc1Expr + " to " + this.loc2Expr;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.single = i % 2 == 0;
        boolean bl = this.coords = i < 2;
        if (this.coords) {
            this.x1Expr = expressions[0];
            this.z1Expr = expressions[1];
            if (this.single) {
                this.worldExpression = expressions[2];
            } else {
                this.x2Expr = expressions[2];
                this.z2Expr = expressions[3];
                this.worldExpression = expressions[4];
            }
        } else {
            this.loc1Expr = expressions[0];
            if (!this.single) {
                this.loc2Expr = expressions[1];
            }
        }
        return true;
    }
}

