/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Skin.SkinManager;
import com.pie.tlatoani.Tablist.Array.ArrayTablist;
import com.pie.tlatoani.Tablist.Simple.SimpleTablist;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Tablist {
    public final HashSet<Player> players = new HashSet();
    public final SimpleTablist simpleTablist = new SimpleTablist(this);
    public final ArrayTablist arrayTablist = new ArrayTablist(this);
    private HashSet<Player> hiddenPlayers = new HashSet();
    private HashMap<Player, String> tablistNames = new HashMap();
    private HashMap<Player, Integer> scores = new HashMap();
    private boolean allPlayersHidden = false;
    private boolean scoresEnabled = false;
    public static final String OBJECTIVE_NAME = "MundoSK_Tablist";
    public static final Skin DEFAULT_SKIN_TEXTURE = new Skin.Simple("eyJ0aW1lc3RhbXAiOjE0NzAwMjgwNDU3MzUsInByb2ZpbGVJZCI6IjQzYTgzNzNkNjQyOTQ1MTBhOWFhYjMwZjViM2NlYmIzIiwicHJvZmlsZU5hbWUiOiJTa3VsbENsaWVudFNraW42Iiwic2lnbmF0dXJlUmVxdWlyZWQiOnRydWUsInRleHR1cmVzIjp7IlNLSU4iOnsidXJsIjoiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9iNTg3OTM1YzdmYmVjYzJmYWMxMDY0OWZjZGZiODM1YjQ2NTA3MzZiOWJmMWQ0NGVhZjc2ZDNiOWVmN2UwIn19fQ==", "eTy8+/waBl22GpAyTHx+QY40J3DY57F2FSkVupjJxAuuUfstvX/DxmJANKtIcYCYP9LUHh9DkP1T2bXUobHcx8GAICi8S/uEWXx96PHHjSr7wQ9uBC4NMCkV7dHHMKdVqEJ9jDpMvSax9vs1tOc2NWaeMbzc/345K95JaYVD+AV4W1+IuppXlMgDmCatUCgGDbzTuQKO8An9zFPciCRq1VSGaOPCj4PoIDQyMhSPqb1cPML/wH26Wtl4DEjnyVIyemk7oDBK29DXxtBLmzX6Ni1C8VM3UmG2StDC7dSwxJNLBHQ/aqXwupK4j0bZghiRbiaq4kAlPcpMeL+TTHac7oYFGihj/s/OVWaL0Fo2KgFZgKuZ26kDepCLEEOOoj2Zq8ohtxufPdTDqw032AyA/HbldnBIsCnQCDiq3XXdZHz0R+pvuf73BSHc7CiG2pwjSdSQ8XetlP70A9SddJu+iFuKGwzh/cvQ2H+sqoUYmIYIXcl2xJTy+Y/shxJDZZVxGCSHmj+4SYzJCg+nsNlEJ9HBG//LfeY+WhacbC9pPPy8wKnDqvIx0QX2YakyBFy659DEBEhSSNRQjOm78Zd9K7pP1QOrS2RDwsDSIXaR0gxT69Bv+Z/r+w8GJY6tHvT8aqTNQHpmv+kwMVdGOWMj3wMErW2aqjH9ffc1nuWht/E=");
    private static HashMap<Player, Tablist> tablistMap = new HashMap();
    private static ArrayList<UUID> playersRespawning = new ArrayList();

    public static void onJoin(final Player player) {
        if (!tablistMap.containsKey(player)) {
            Tablist.setTablistForPlayer(Arrays.asList(player), new Tablist());
        }
        Mundo.syncDelay(1, new Runnable(){

            @Override
            public void run() {
                HashSet tablistSet = new HashSet(tablistMap.values());
                for (Tablist tablist : tablistSet) {
                    if (!tablist.areAllPlayersHidden()) continue;
                    tablist.hidePlayers(Arrays.asList(player));
                }
            }
        });
    }

    public static void onQuit(Player player) {
        Tablist.getTablistForPlayer(player).removePlayers(Arrays.asList(player));
        HashSet<Tablist> tablistSet = new HashSet<Tablist>(tablistMap.values());
        for (Tablist tablist : tablistSet) {
            tablist.hiddenPlayers.remove(player);
        }
    }

    public static Tablist getTablistForPlayer(Player player) {
        return tablistMap.get(player);
    }

    public static void setTablistForPlayer(Collection<Player> players, Tablist newTablist) {
        for (Player player : players) {
            Tablist oldTablist = Tablist.getTablistForPlayer(player);
            if (oldTablist != null) {
                oldTablist.removePlayers(Arrays.asList(player));
            }
            tablistMap.put(player, newTablist);
        }
        newTablist.addPlayers(players);
    }

    private void addPlayers(Collection<Player> players) {
        this.players.addAll(players);
        this.simpleTablist.addPlayers(players);
        this.arrayTablist.addPlayers(players);
        Tablist.hideInTablist(this.hiddenPlayers, players);
        ArrayList visiblePlayers = new ArrayList();
        visiblePlayers.addAll(Bukkit.getOnlinePlayers());
        visiblePlayers.removeAll(this.hiddenPlayers);
        Tablist.updateTablistName(visiblePlayers, players);
        if (this.scoresEnabled) {
            Tablist.enableTablistObjective(players);
            for (Player visiblePlayer : visiblePlayers) {
                Tablist.updateScore(visiblePlayer, players, this.getScore(visiblePlayer));
            }
        }
    }

    private void removePlayers(Collection<Player> players) {
        this.players.removeAll(players);
        this.simpleTablist.removePlayers(players);
        this.arrayTablist.removePlayers(players);
        Tablist.showInTablist(this.hiddenPlayers, players);
        if (this.scoresEnabled) {
            Tablist.disableTablistObjective(players);
        }
    }

    public void hidePlayers(Collection<Player> playersToHide) {
        playersToHide.removeAll(this.hiddenPlayers);
        Tablist.hideInTablist(playersToHide, this.players);
        this.hiddenPlayers.addAll(playersToHide);
    }

    public void showPlayers(Collection<Player> playersToShow) {
        if (this.allPlayersHidden) {
            this.arrayTablist.setColumns(0);
        }
        this.allPlayersHidden = false;
        Tablist.showInTablist(playersToShow, this.players);
        this.hiddenPlayers.removeAll(playersToShow);
    }

    public void hideAllPlayers() {
        if (!this.allPlayersHidden) {
            this.allPlayersHidden = true;
            this.hidePlayers(new ArrayList<Player>(Bukkit.getOnlinePlayers()));
        }
    }

    public void showAllPlayers() {
        this.arrayTablist.setColumns(0);
        this.allPlayersHidden = false;
        Tablist.showInTablist(Bukkit.getOnlinePlayers(), this.players);
        this.hiddenPlayers.clear();
    }

    public boolean isPlayerHidden(Player player) {
        return this.allPlayersHidden || this.hiddenPlayers.contains(player);
    }

    public boolean areAllPlayersHidden() {
        return this.allPlayersHidden;
    }

    public boolean areScoresEnabled() {
        return this.scoresEnabled;
    }

    public void setScoresEnabled(boolean value) {
        if (this.scoresEnabled != value) {
            this.scoresEnabled = value;
            if (this.scoresEnabled) {
                Tablist.enableTablistObjective(this.players);
            } else {
                Tablist.disableTablistObjective(this.players);
                this.scores.clear();
            }
        }
    }

    public String getTablistName(Player player) {
        return this.tablistNames.getOrDefault(player, SkinManager.getTablistName(player));
    }

    public void setTablistName(Player player, String value) {
        this.tablistNames.put(player, value);
        if (!this.isPlayerHidden(player)) {
            Tablist.updateTablistName(Collections.singleton(player), this.players);
        }
    }

    public Integer getScore(Player player) {
        return this.scores.getOrDefault(player, 0);
    }

    public void setScore(Player player, int score) {
        if (!this.scoresEnabled) {
            return;
        }
        this.scores.put(player, score);
        Tablist.updateScore(player, this.players, score);
    }

    public static void hideInTablist(Collection<? extends Player> objects, Collection<Player> subjects) {
        for (Player player : objects) {
            PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(player.getPlayerListName())));
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
            packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            try {
                for (Player subject : subjects) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(subject, packet);
                }
            }
            catch (InvocationTargetException e) {
                Mundo.reportException(Tablist.class, e);
            }
        }
    }

    public static void showInTablist(Collection<? extends Player> objects, Collection<Player> subjects) {
        for (Player player : objects) {
            PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(player.getPlayerListName())));
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
            packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            try {
                for (Player subject : subjects) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(subject, packet);
                }
            }
            catch (InvocationTargetException e) {
                Mundo.reportException(Tablist.class, e);
            }
        }
    }

    public static void updateTablistName(Collection<? extends Player> objects, Collection<Player> subjects) {
        for (Player player : objects) {
            PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(player.getPlayerListName())));
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
            packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
            try {
                for (Player subject : subjects) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(subject, packet);
                }
            }
            catch (InvocationTargetException e) {
                Mundo.reportException(Tablist.class, e);
            }
        }
    }

    public static void updateScore(Player object, Collection<Player> subjects, Integer score) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().writeSafely(0, (Object)SkinManager.getNameTag(object));
        packet.getStrings().writeSafely(1, (Object)OBJECTIVE_NAME);
        packet.getIntegers().writeSafely(0, (Object)score);
        packet.getScoreboardActions().writeSafely(0, (Object)EnumWrappers.ScoreboardAction.CHANGE);
        try {
            for (Player subject : subjects) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(subject, packet);
            }
        }
        catch (InvocationTargetException e) {
            Mundo.reportException(Tablist.class, e);
        }
    }

    public static void enableTablistObjective(Collection<? extends Player> players) {
        PacketContainer createPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        createPacket.getStrings().writeSafely(0, (Object)OBJECTIVE_NAME);
        createPacket.getStrings().writeSafely(1, (Object)OBJECTIVE_NAME);
        createPacket.getIntegers().writeSafely(0, (Object)0);
        PacketContainer displayPacket = new PacketContainer(PacketType.Play.Server.SCOREBOARD_DISPLAY_OBJECTIVE);
        displayPacket.getIntegers().writeSafely(0, (Object)0);
        displayPacket.getStrings().writeSafely(0, (Object)OBJECTIVE_NAME);
        try {
            for (Player player : players) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, createPacket);
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, displayPacket);
            }
        }
        catch (InvocationTargetException e) {
            Mundo.reportException(Tablist.class, e);
        }
    }

    public static void disableTablistObjective(Collection<? extends Player> players) {
        PacketContainer removePacket = new PacketContainer(PacketType.Play.Server.SCOREBOARD_OBJECTIVE);
        removePacket.getStrings().writeSafely(0, (Object)OBJECTIVE_NAME);
        removePacket.getStrings().writeSafely(1, (Object)OBJECTIVE_NAME);
        removePacket.getIntegers().writeSafely(0, (Object)1);
        try {
            for (Player player : players) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, removePacket);
            }
        }
        catch (InvocationTargetException e) {
            Mundo.reportException(Tablist.class, e);
        }
    }

    public static String colorStringToJson(String original) {
        if (original == null) {
            throw new NullPointerException("original String cannot be null!");
        }
        char colorChar = '\u00a7';
        String template = "{text:\"TEXT\",color:COLOR,bold:BOLD,underlined:UNDERLINED,italic:ITALIC,strikethrough:STRIKETHROUGH,obfuscated:OBFUSCATED,extra:[EXTRA]}";
        String json = "";
        ArrayList<String> parts = new ArrayList<String>();
        int first = 0;
        int last = 0;
        while ((first = original.indexOf(colorChar, last)) != -1) {
            int offset = 2;
            while ((last = original.indexOf(colorChar, first + offset)) - 2 == first) {
                offset += 2;
            }
            if (last == -1) {
                parts.add(original.substring(first));
                break;
            }
            parts.add(original.substring(first, last));
        }
        if (parts.isEmpty()) {
            parts.add(original);
        }
        Pattern colorFinder = Pattern.compile("(" + colorChar + "([a-f0-9]))");
        for (String part : parts) {
            json = json.isEmpty() ? template : json.replace("EXTRA", template);
            Matcher matcher = colorFinder.matcher(part);
            ChatColor color = matcher.find() ? ChatColor.getByChar((char)matcher.group().charAt(1)) : ChatColor.WHITE;
            json = json.replace("COLOR", color.name().toLowerCase());
            json = json.replace("BOLD", String.valueOf(part.contains(ChatColor.BOLD.toString())));
            json = json.replace("ITALIC", String.valueOf(part.contains(ChatColor.ITALIC.toString())));
            json = json.replace("UNDERLINED", String.valueOf(part.contains(ChatColor.UNDERLINE.toString())));
            json = json.replace("STRIKETHROUGH", String.valueOf(part.contains(ChatColor.STRIKETHROUGH.toString())));
            json = json.replace("OBFUSCATED", String.valueOf(part.contains(ChatColor.MAGIC.toString())));
            json = json.replace("TEXT", part.replaceAll("(" + colorChar + "([a-z0-9]))", ""));
        }
        json = json.replace(",extra:[EXTRA]", "");
        return json;
    }

    static {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isCancelled()) {
                    List playerInfoDatas = (List)event.getPacket().getPlayerInfoDataLists().readSafely(0);
                    ArrayList<PlayerInfoData> newPlayerInfoDatas = new ArrayList<PlayerInfoData>();
                    for (PlayerInfoData playerInfoData : playerInfoDatas) {
                        Player player = Bukkit.getPlayer((UUID)playerInfoData.getProfile().getUUID());
                        PlayerInfoData newPlayerInfoData = playerInfoData;
                        if (player != null && event.getPlayer() != null) {
                            Tablist tablist = Tablist.getTablistForPlayer(event.getPlayer());
                            Mundo.debug(Tablist.class, "getTablistForPlayer = " + tablist);
                            HashMap tablistNames = tablist.tablistNames;
                            Mundo.debug(Tablist.class, "tablistNames = " + tablistNames);
                            String tablistName = (String)tablist.tablistNames.get(player);
                            Mundo.debug(Tablist.class, "tablistName = " + tablistName);
                            if (tablistName != null) {
                                newPlayerInfoData = new PlayerInfoData(playerInfoData.getProfile(), playerInfoData.getLatency(), playerInfoData.getGameMode(), WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(tablistName)));
                            }
                        }
                        newPlayerInfoDatas.add(newPlayerInfoData);
                    }
                    event.getPacket().getPlayerInfoDataLists().writeSafely(0, newPlayerInfoDatas);
                }
            }
        });
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.NAMED_ENTITY_SPAWN}){

            public void onPacketSending(PacketEvent event) {
                Player player = Bukkit.getPlayer((UUID)((UUID)event.getPacket().getUUIDs().read(0)));
                if (player != null && event.getPlayer() != null && Tablist.getTablistForPlayer(event.getPlayer()).isPlayerHidden(player) && !event.isCancelled()) {
                    Mundo.debug(Tablist.class, "Player is hidden");
                    PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(player.getPlayerListName())));
                    PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    packet.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
                    packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    try {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(event.getPlayer(), packet);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    PacketContainer removePacket = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    removePacket.getPlayerInfoDataLists().writeSafely(0, Collections.singletonList(playerInfoData));
                    removePacket.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    Mundo.sync(new PacketSender(removePacket, event.getPlayer()));
                }
            }
        });
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.RESPAWN}){

            public void onPacketSending(PacketEvent event) {
                final Player player = event.getPlayer();
                if (player != null && Tablist.getTablistForPlayer(event.getPlayer()).isPlayerHidden(player) && !playersRespawning.contains(player.getUniqueId()) && !event.isCancelled()) {
                    Mundo.debug(Tablist.class, "Player is hidden");
                    playersRespawning.add(player.getUniqueId());
                    PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(player.getPlayerListName())));
                    PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
                    packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    try {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    final PacketContainer removePacket = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    removePacket.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
                    removePacket.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    Mundo.syncDelay(2, new Runnable(){

                        @Override
                        public void run() {
                            playersRespawning.remove(player.getUniqueId());
                            try {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(player, removePacket);
                            }
                            catch (InvocationTargetException e) {
                                Mundo.reportException(Tablist.class, e);
                            }
                        }
                    });
                }
            }
        });
    }

    public static class PacketSender
    implements Runnable {
        private PacketContainer packet;
        private Player[] players;

        public PacketSender(PacketContainer packet, Player ... players) {
            this.packet = packet;
            this.players = players;
        }

        @Override
        public void run() {
            for (Player player : this.players) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, this.packet);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

