/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Simple;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.Multimap;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.UtilPacketEvent;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tablist;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SimpleTablist {
    private final Tablist tablist;
    private final HashMap<String, String> displayNames = new HashMap();
    private final HashMap<String, Integer> latencies = new HashMap();
    private final HashMap<String, Skin> heads = new HashMap();
    private final HashMap<String, Integer> scores = new HashMap();
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public SimpleTablist(Tablist tablist) {
        this.tablist = tablist;
    }

    private void sendPacketToAll(String id, EnumWrappers.PlayerInfoAction action) {
        this.sendPacket(id, action, this.tablist.players);
    }

    private void sendPacket(String id, EnumWrappers.PlayerInfoAction action, Collection<Player> players) {
        int ping = this.latencies.get(id);
        String displayName = this.displayNames.get(id);
        WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)Tablist.colorStringToJson(displayName));
        UUID uuid = UUID.nameUUIDFromBytes(("MundoSKTablist::" + id).getBytes(UTF_8));
        Skin icon = this.heads.get(id);
        WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, id + "-MSK");
        if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
            if (icon == null) {
                icon = Tablist.DEFAULT_SKIN_TEXTURE;
            }
            icon.retrieveSkinTextures((Multimap<String, WrappedSignedProperty>)gameProfile.getProperties());
        }
        PlayerInfoData playerInfoData = new PlayerInfoData(gameProfile, ping, EnumWrappers.NativeGameMode.NOT_SET, chatComponent);
        List<PlayerInfoData> playerInfoDatas = Arrays.asList(playerInfoData);
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        packetContainer.getPlayerInfoDataLists().writeSafely(0, playerInfoDatas);
        packetContainer.getPlayerInfoAction().writeSafely(0, (Object)action);
        for (Player player : players) {
            try {
                UtilPacketEvent.protocolManager.sendServerPacket(player, packetContainer);
            }
            catch (InvocationTargetException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private void sendScorePacketToAll(String id) {
        this.sendScorePacket(id, this.tablist.players);
    }

    private void sendScorePacket(String id, Collection<Player> players) {
        if (!this.tablist.areScoresEnabled()) {
            return;
        }
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SCOREBOARD_SCORE);
        packet.getStrings().writeSafely(0, (Object)(id + "-MSK"));
        packet.getStrings().writeSafely(1, (Object)"MundoSK_Tablist");
        packet.getIntegers().writeSafely(0, (Object)this.scores.get(id));
        packet.getScoreboardActions().writeSafely(0, (Object)EnumWrappers.ScoreboardAction.CHANGE);
        for (Player player : players) {
            try {
                UtilPacketEvent.protocolManager.sendServerPacket(player, packet);
            }
            catch (InvocationTargetException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    public void addPlayers(Collection<Player> players) {
        for (String s : this.heads.keySet()) {
            this.sendPacket(s, EnumWrappers.PlayerInfoAction.ADD_PLAYER, players);
        }
    }

    public void removePlayers(Collection<Player> players) {
        for (String s : this.heads.keySet()) {
            this.sendPacket(s, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER, players);
        }
    }

    public void clear() {
        String[] ids = this.displayNames.keySet().toArray(new String[0]);
        for (int i = 0; i < ids.length; ++i) {
            this.deleteTab(ids[i]);
        }
    }

    public boolean tabExists(String id) {
        return id.length() <= 12 && this.displayNames.containsKey(id);
    }

    public void createTab(String id, String displayName, Integer ping, Skin head, Integer score) {
        this.tablist.arrayTablist.setColumns(0);
        if (id.length() <= 12 && !this.tabExists(id)) {
            ping = Math.max(ping, 0);
            ping = Math.min(ping, 5);
            this.latencies.put(id, ping);
            this.displayNames.put(id, displayName);
            this.heads.put(id, head);
            this.scores.put(id, score);
            this.sendPacketToAll(id, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            if (score != 0) {
                this.sendScorePacketToAll(id);
            }
        }
    }

    public void deleteTab(String id) {
        if (this.tabExists(id)) {
            this.sendPacketToAll(id, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            this.displayNames.remove(id);
            this.latencies.remove(id);
            this.heads.remove(id);
        }
    }

    public String getDisplayName(String id) {
        return this.displayNames.get(id);
    }

    public Integer getLatency(String id) {
        return this.latencies.get(id);
    }

    public Skin getHead(String id) {
        return this.heads.get(id);
    }

    public Integer getScore(String id) {
        return this.scores.get(id);
    }

    public void setDisplayName(String id, String displayName) {
        if (this.tabExists(id)) {
            this.displayNames.put(id, displayName);
            this.sendPacketToAll(id, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
        }
    }

    public void setLatency(String id, Integer ping) {
        if (this.tabExists(id)) {
            this.latencies.put(id, ping);
            this.sendPacketToAll(id, EnumWrappers.PlayerInfoAction.UPDATE_LATENCY);
        }
    }

    public void setHead(String id, Skin icon) {
        if (this.tabExists(id)) {
            this.sendPacketToAll(id, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            this.heads.put(id, icon);
            this.sendPacketToAll(id, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        }
    }

    public void setScore(String id, Integer ping) {
        if (this.tabExists(id)) {
            this.scores.put(id, ping);
            this.sendScorePacketToAll(id);
        }
    }
}

