/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Socket2;

import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Socket2.Socket2;
import com.pie.tlatoani.Util.BaseEvent;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SocketListener
implements Runnable {
    private int port;
    private ServerSocket serverSocket = null;
    private boolean listening;
    private String password;
    private static Map<Integer, SocketListener> listenerMap = new HashMap<Integer, SocketListener>();

    public boolean isListeningOnPort(int port) {
        SocketListener listener = listenerMap.get(port);
        return listener == null ? false : listener.listening;
    }

    public String getPasswordOfPort(int port) {
        SocketListener listener = listenerMap.get(port);
        return listener == null ? null : listener.password;
    }

    public void startListeningOnPort(int port, String password) {
        if (password != null) {
            SocketListener socketListener = listenerMap.get(port);
            if (socketListener == null) {
                socketListener = new SocketListener(port);
                listenerMap.put(port, socketListener);
            }
            socketListener.password = password;
            socketListener.start();
        }
    }

    public void stopListeningOnPort(int port) {
        SocketListener socketListener = listenerMap.get(port);
        if (socketListener != null) {
            socketListener.stop();
            listenerMap.remove(port);
        }
    }

    public void setPasswordOfPort(int port, String password) {
        if (password != null && this.isListeningOnPort(port)) {
            SocketListener.listenerMap.get((Object)Integer.valueOf((int)port)).password = password;
        }
    }

    private SocketListener(int port) {
        this.port = port;
    }

    private void start() {
        if (!this.listening) {
            this.listening = true;
            Mundo.scheduler.runTaskAsynchronously((Plugin)Mundo.instance, (Runnable)this);
        }
    }

    private void stop() {
        if (this.listening) {
            this.listening = false;
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.serverSocket.setReuseAddress(true);
            while (this.listening) {
                try {
                    Socket socket = this.serverSocket.accept();
                    this.onSocketConnection(socket);
                }
                catch (SocketException e) {
                    if (!this.listening) continue;
                    Mundo.reportException(SocketListener.class, e);
                }
            }
            this.serverSocket = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void onSocketConnection(final Socket socket) {
        Mundo.sync(new Runnable(){

            @Override
            public void run() {
                try {
                    final Socket2 socket2 = new Socket2();
                    socket2.use(socket, SocketListener.this.password, new Runnable(){

                        @Override
                        public void run() {
                            if (socket2.getState() == Socket2.State.CONNECTED) {
                                ConnectEvent event = new ConnectEvent(socket2);
                                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Mundo.reportException(SocketListener.class, e);
                }
            }
        });
    }

    public static class ConnectEvent
    extends BaseEvent {
        public final Socket2 socket2;

        public ConnectEvent(Socket2 socket2) {
            this.socket2 = socket2;
        }
    }
}

