/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.PacketInfoConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprObjectOfPacket
extends SimpleExpression<Object> {
    private Method getObjects = null;
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private static Field structureModifier;
    private boolean isSingle = true;
    private boolean collection = false;
    private Class aClass;
    private PacketInfoConverter converter;
    public static Map<Class, PacketInfoConverter> converterMap;

    private static <T> void registerConverter(Class<T> aClass, PacketInfoConverter<T> converter) {
        converterMap.put(aClass, converter);
    }

    private static <T> PacketInfoConverter<T> getConverter(Class<T> aClass, Boolean isSingle) {
        return converterMap.get(aClass);
    }

    protected Object[] get(Event event) {
        StructureModifier structureModifier = null;
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        if (this.getObjects != null) {
            try {
                structureModifier = (StructureModifier)this.getObjects.invoke((Object)packet, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Mundo.debug((Object)this, e);
            }
            catch (InvocationTargetException e) {
                Mundo.debug((Object)this, e);
            }
        } else {
            if (this.converter != null && this.isSingle) {
                return new Object[]{this.converter.get(packet, index)};
            }
            if (this.collection) {
                Collection collection1 = (Collection)packet.getSpecificModifier(Collection.class).readSafely(index);
                return collection1 == null ? new Object[]{} : collection1.toArray();
            }
            try {
                structureModifier = (StructureModifier)ExprObjectOfPacket.structureModifier.get(this.packetContainerExpression.getSingle(event));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.isSingle) {
            return new Object[]{structureModifier.readSafely(index)};
        }
        return (Object[])structureModifier.readSafely(index);
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<?> getReturnType() {
        return this.aClass;
    }

    public String toString(Event event, boolean b) {
        return "%type% packetinfo %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (i == 0 || i == 1) {
            String pluralclassname;
            Literal literal = (Literal)expressions[0];
            this.index = expressions[1];
            this.packetContainerExpression = expressions[2];
            this.aClass = ((ClassInfo)literal.getSingle()).getC();
            this.converter = ExprObjectOfPacket.getConverter(this.aClass, true);
            if (this.converter != null) {
                Mundo.debug((Object)this, "Converter to PLib type: " + this.aClass);
                this.isSingle = true;
                return true;
            }
            String classname = this.aClass.getSimpleName();
            if (this.aClass == Object.class) {
                return true;
            }
            Mundo.debug((Object)this, "Class simple name: " + classname);
            if (i == 1) {
                pluralclassname = classname + "Arrays";
                this.isSingle = false;
            } else {
                pluralclassname = classname.substring(classname.length() - 1).equals("y") ? classname.substring(0, classname.length() - 1) + "ies" : classname + "s";
            }
            Mundo.debug((Object)this, "Class plural name: " + pluralclassname);
            try {
                Method method = PacketContainer.class.getMethod("get" + pluralclassname, new Class[0]);
                Mundo.debug((Object)this, "Method: " + method.toString());
                this.getObjects = method;
            }
            catch (NoSuchMethodException e) {
                Mundo.debug((Object)this, e);
                Skript.error((String)("The type " + literal + " is not applicable for the '%type% %number% of %packet%' expression."));
                return false;
            }
            return true;
        }
        if (!(expressions[0] instanceof VariableString)) {
            Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the %string% pinfo expression!"));
            return false;
        }
        String fullstring = ((VariableString)expressions[0]).toString();
        String classname = fullstring.substring(1, fullstring.length() - 1);
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        if (classname.equalsIgnoreCase("collection")) {
            this.isSingle = false;
            this.collection = true;
            this.aClass = Object.class;
            return true;
        }
        Mundo.debug((Object)this, "Method name without 'get': " + classname);
        try {
            Method method = PacketContainer.class.getMethod("get" + classname, new Class[0]);
            Mundo.debug((Object)this, "Method: " + method.toString());
            this.getObjects = method;
            this.aClass = Object.class;
        }
        catch (NoSuchMethodException e) {
            Mundo.debug((Object)this, e);
            Skript.error((String)("There is no packet info method called 'get" + classname + "'!"));
            return false;
        }
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        StructureModifier structureModifier = null;
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        if (this.getObjects != null) {
            try {
                structureModifier = (StructureModifier)this.getObjects.invoke((Object)packet, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Mundo.debug((Object)this, e);
            }
        } else if (this.converter != null && this.isSingle) {
            this.converter.set(packet, index, delta[0]);
        } else if (this.collection) {
            packet.getSpecificModifier(Collection.class).writeSafely(index, Arrays.asList(delta));
        } else {
            try {
                structureModifier = (StructureModifier)ExprObjectOfPacket.structureModifier.get(packet);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (structureModifier != null) {
            if (this.isSingle) {
                structureModifier.writeSafely(index, delta[0]);
            } else {
                Object[] result = (Object[])Array.newInstance(this.aClass, delta.length);
                for (int i = 0; i < delta.length; ++i) {
                    result[i] = delta[i];
                }
                structureModifier.writeSafely(index, (Object)result);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (this.isSingle) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{this.aClass});
            }
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    static {
        converterMap = new HashMap<Class, PacketInfoConverter>();
        try {
            structureModifier = PacketContainer.class.getDeclaredField("structureModifier");
            structureModifier.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        ExprObjectOfPacket.registerConverter(Location.class, new PacketInfoConverter<Location>(){

            @Override
            public Location get(PacketContainer packet, Integer index) {
                StructureModifier structureModifier = packet.getBlockPositionModifier();
                BlockPosition blockPosition = (BlockPosition)structureModifier.readSafely(index.intValue());
                if (blockPosition == null) {
                    return null;
                }
                return blockPosition.toLocation((World)Bukkit.getWorlds().get(0));
            }

            @Override
            public void set(PacketContainer packet, Integer index, Location value) {
                StructureModifier structureModifier = packet.getBlockPositionModifier();
                BlockPosition blockPosition = new BlockPosition(value.toVector());
                structureModifier.writeSafely(index.intValue(), (Object)blockPosition);
            }
        });
    }
}

