/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import com.google.common.collect.ImmutableSet;
import com.pie.tlatoani.Mundo;
import java.util.HashMap;

public class ExpressionConstraints {
    public final ImmutableSet<Type> types;
    public final Kleenean isLiteral;
    public final int time;
    public final boolean nullable;

    private ExpressionConstraints(ImmutableSet<Type> types, Kleenean isLiteral, int time, boolean nullable) {
        this.types = types;
        this.isLiteral = isLiteral;
        this.time = time;
        this.nullable = nullable;
    }

    public static ExpressionConstraints fromString(String string) {
        int time;
        boolean nullable;
        Kleenean isLiteral;
        if (string.charAt(0) == '*') {
            isLiteral = Kleenean.TRUE;
            string = string.substring(1);
        } else if (string.charAt(0) == '~') {
            isLiteral = Kleenean.FALSE;
            string = string.substring(1);
        } else {
            isLiteral = Kleenean.UNKNOWN;
        }
        if (string.charAt(0) == '-') {
            nullable = true;
            string = string.substring(0);
        } else {
            nullable = false;
        }
        if (string.endsWith("@1")) {
            time = 1;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("@-1")) {
            time = -1;
            string = string.substring(0, string.length() - 2);
        } else {
            time = 0;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String typeStr : string.split("/")) {
            boolean isSingle;
            if (typeStr.endsWith("s")) {
                isSingle = false;
                typeStr = typeStr.substring(0, typeStr.length() - 1);
            } else {
                isSingle = true;
            }
            ClassInfo classInfo = Classes.getClassInfo((String)typeStr);
            builder.add((Object)new Type(classInfo, isSingle));
        }
        return new ExpressionConstraints((ImmutableSet<Type>)builder.build(), isLiteral, time, nullable);
    }

    public Class getSuperClass() {
        Class[] classes = new Class[this.types.size()];
        int i = 0;
        for (Type type : this.types) {
            classes[i] = type.classInfo.getC();
            ++i;
        }
        return Mundo.commonSuperClass(classes);
    }

    public static class Collective {
        private HashMap<String, ExpressionConstraints> constraintsMap = new HashMap();

        public void addConstraints(String variable, ExpressionConstraints constraints) {
            ExpressionConstraints prevConstraints = this.constraintsMap.get(variable);
            if (prevConstraints != null) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.addAll(prevConstraints.types);
                builder.addAll(constraints.types);
                Kleenean isLiteral = constraints.isLiteral == prevConstraints.isLiteral ? constraints.isLiteral : Kleenean.UNKNOWN;
                int time = constraints.time == prevConstraints.time ? constraints.time : 0;
                boolean nullable = constraints.nullable || prevConstraints.nullable;
                ExpressionConstraints newConstraints = new ExpressionConstraints(builder.build(), isLiteral, time, nullable);
                this.constraintsMap.put(variable, newConstraints);
            } else {
                this.constraintsMap.put(variable, constraints);
            }
        }
    }

    public static class Type {
        public final ClassInfo classInfo;
        public final boolean isSingle;

        public Type(ClassInfo classInfo, boolean isSingle) {
            this.classInfo = classInfo;
            this.isSingle = isSingle;
        }

        public boolean equals(Object object) {
            if (object instanceof Type) {
                Type type = (Type)object;
                return this.isSingle == type.isSingle && this.classInfo.equals(type.classInfo);
            }
            return false;
        }
    }
}

