/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.PacketInfoConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ExprJSONObjectOfPacket
extends SimpleExpression<JSONObject> {
    private PacketInfoConverter<JSONObject> singleConverter = null;
    private PacketInfoConverter<JSONObject[]> pluralConverter = null;
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private boolean isSingle;
    public static Map<String, PacketInfoConverter<JSONObject>> singleConverters = new LinkedHashMap<String, PacketInfoConverter<JSONObject>>();
    public static Map<String, PacketInfoConverter<JSONObject[]>> pluralConverters = new LinkedHashMap<String, PacketInfoConverter<JSONObject[]>>();

    public static void registerSingleConverter(String name, PacketInfoConverter<JSONObject> converter) {
        singleConverters.put(name, converter);
    }

    public static void registerPluralConverter(String name, PacketInfoConverter<JSONObject[]> converter) {
        pluralConverters.put(name, converter);
    }

    public static PacketInfoConverter<JSONObject> getSingleConverter(String name) {
        return singleConverters.get(name);
    }

    public static PacketInfoConverter<JSONObject[]> getPluralConverter(String name) {
        return pluralConverters.get(name);
    }

    public static String getConverterNamesPattern(Boolean isSingle) {
        String result = "";
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            result = result + "|" + ++i + "\u00a6" + name;
        }
        return result;
    }

    public static String getConverterNameByIndex(int index, Boolean isSingle) {
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            if (++i != index) continue;
            return name;
        }
        return null;
    }

    protected JSONObject[] get(Event event) {
        JSONObject[] jSONObjectArray;
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        Mundo.debug((Object)this, "Packet before calling function :" + packet);
        Mundo.debug((Object)this, "Converters == " + this.singleConverter + " , " + this.pluralConverter);
        if (this.isSingle) {
            JSONObject[] jSONObjectArray2 = new JSONObject[1];
            jSONObjectArray = jSONObjectArray2;
            jSONObjectArray2[0] = this.singleConverter.get(packet, index);
        } else {
            jSONObjectArray = this.pluralConverter.get(packet, index);
        }
        return jSONObjectArray;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<JSONObject> getReturnType() {
        return JSONObject.class;
    }

    public String toString(Event event, boolean b) {
        return "%string% pjson %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String string;
        boolean bl = this.isSingle = i == 0;
        if (expressions[0] == null) {
            string = ExprJSONObjectOfPacket.getConverterNameByIndex(parseResult.mark, this.isSingle);
        } else if (expressions[0] instanceof Literal) {
            string = (String)((Literal)expressions[0]).getSingle();
        } else if (expressions[0] instanceof VariableString) {
            String fullstring = ((VariableString)expressions[0]).toString();
            string = fullstring.substring(1, fullstring.length() - 1);
        } else {
            Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the pjson expression!"));
            return false;
        }
        Mundo.debug((Object)this, "String == " + string + " isSingle == " + this.isSingle);
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        this.singleConverter = ExprJSONObjectOfPacket.getSingleConverter(string.toLowerCase());
        this.pluralConverter = ExprJSONObjectOfPacket.getPluralConverter(string.toLowerCase());
        Mundo.debug((Object)this, "Converters == " + this.singleConverter + " , " + this.pluralConverter);
        if (this.isSingle ? this.singleConverter == null : this.pluralConverter == null) {
            Skript.error((String)("The string " + string + " is not a valid packetinfo!"));
            return false;
        }
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        Mundo.debug((Object)this, "Packet before calling function :" + packet);
        if (this.isSingle) {
            this.singleConverter.set(packet, index, (JSONObject)delta[0]);
        } else {
            JSONObject[] deltaJSON = new JSONObject[delta.length];
            for (int i = 0; i < delta.length; ++i) {
                deltaJSON[i] = (JSONObject)delta[i];
            }
            this.pluralConverter.set(packet, index, deltaJSON);
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{JSONObject.class});
        }
        return null;
    }

    static {
        ExprJSONObjectOfPacket.registerSingleConverter("chatcomponent", new PacketInfoConverter<JSONObject>(){

            @Override
            public JSONObject get(PacketContainer packet, Integer index) {
                WrappedChatComponent chatComponent = (WrappedChatComponent)packet.getChatComponents().readSafely(index.intValue());
                String fromjson = chatComponent.getJson();
                JSONParser parser = new JSONParser();
                JSONObject tojson = null;
                try {
                    tojson = (JSONObject)parser.parse(fromjson);
                }
                catch (ClassCastException | ParseException e) {
                    Mundo.debug(ExprJSONObjectOfPacket.class, (Exception)e);
                }
                return tojson;
            }

            @Override
            public void set(PacketContainer packet, Integer index, JSONObject value) {
                WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)value.toString());
                packet.getChatComponents().writeSafely(index.intValue(), (Object)chatComponent);
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("serverping", new PacketInfoConverter<JSONObject>(){

            @Override
            public JSONObject get(PacketContainer packet, Integer index) {
                try {
                    return (JSONObject)new JSONParser().parse(((WrappedServerPing)packet.getServerPings().readSafely(0)).toJson());
                }
                catch (ClassCastException | ParseException e) {
                    Mundo.reportException(ExprJSONObjectOfPacket.class, (Exception)e);
                    return null;
                }
            }

            @Override
            public void set(PacketContainer packet, Integer index, JSONObject value) {
                packet.getServerPings().writeSafely(0, (Object)WrappedServerPing.fromJson((String)value.toJSONString()));
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("datawatcher", new PacketInfoConverter<JSONObject>(){

            @Override
            public JSONObject get(PacketContainer packet, Integer index) {
                JSONObject jsonObject = new JSONObject();
                WrappedDataWatcher dataWatcher = (WrappedDataWatcher)packet.getDataWatcherModifier().readSafely(index.intValue());
                jsonObject.put((Object)"entity", (Object)dataWatcher.getEntity());
                if (dataWatcher != null) {
                    for (WrappedWatchableObject wrappedWatchableObject : dataWatcher) {
                        jsonObject.put((Object)(wrappedWatchableObject.getIndex() + ""), wrappedWatchableObject.getValue());
                    }
                }
                return jsonObject;
            }

            @Override
            public void set(PacketContainer packet, Integer index, JSONObject value) {
                final ArrayList wrappedWatchableObjects = new ArrayList();
                Entity entity = (Entity)value.get((Object)"entity");
                value.forEach(new BiConsumer(){

                    public void accept(Object o, Object o2) {
                        try {
                            String key = (String)o;
                            int i = Integer.parseInt(key);
                            WrappedWatchableObject watchableObject = new WrappedWatchableObject(i, o2);
                            wrappedWatchableObjects.add(watchableObject);
                        }
                        catch (ClassCastException | NumberFormatException runtimeException) {
                            // empty catch block
                        }
                    }
                });
                WrappedDataWatcher dataWatcher = new WrappedDataWatcher(wrappedWatchableObjects);
                dataWatcher.setEntity(entity);
                packet.getDataWatcherModifier().writeSafely(index.intValue(), (Object)dataWatcher);
            }
        });
        ExprJSONObjectOfPacket.registerSingleConverter("watchablecollection", new PacketInfoConverter<JSONObject>(){

            @Override
            public JSONObject get(PacketContainer packet, Integer index) {
                JSONObject jsonObject = new JSONObject();
                Collection wrappedWatchableObjects = (Collection)packet.getWatchableCollectionModifier().readSafely(index.intValue());
                for (WrappedWatchableObject wrappedWatchableObject : wrappedWatchableObjects) {
                    jsonObject.put((Object)("" + wrappedWatchableObject.getIndex()), wrappedWatchableObject.getValue());
                }
                return jsonObject;
            }

            @Override
            public void set(PacketContainer packet, Integer index, JSONObject value) {
                final ArrayList wrappedWatchableObjects = new ArrayList();
                value.forEach(new BiConsumer(){

                    public void accept(Object o, Object o2) {
                        try {
                            String key = (String)o;
                            int i = Integer.parseInt(key);
                            WrappedWatchableObject watchableObject = new WrappedWatchableObject(i, o2);
                            wrappedWatchableObjects.add(watchableObject);
                        }
                        catch (ClassCastException | NumberFormatException runtimeException) {
                            // empty catch block
                        }
                    }
                });
                packet.getWatchableCollectionModifier().writeSafely(index.intValue(), wrappedWatchableObjects);
            }
        });
        ExprJSONObjectOfPacket.registerPluralConverter("chatcomponent", new PacketInfoConverter<JSONObject[]>(){

            @Override
            public JSONObject[] get(PacketContainer packet, Integer index) {
                WrappedChatComponent[] chatComponents = (WrappedChatComponent[])packet.getChatComponentArrays().readSafely(index.intValue());
                JSONObject[] result = new JSONObject[chatComponents.length];
                for (int i = 0; i < chatComponents.length; ++i) {
                    WrappedChatComponent chatComponent = chatComponents[i];
                    String fromjson = chatComponent.getJson();
                    JSONParser parser = new JSONParser();
                    JSONObject tojson = null;
                    try {
                        tojson = (JSONObject)parser.parse(fromjson);
                    }
                    catch (ClassCastException | ParseException e) {
                        Mundo.debug(ExprJSONObjectOfPacket.class, (Exception)e);
                    }
                    result[i] = tojson;
                }
                return result;
            }

            @Override
            public void set(PacketContainer packet, Integer index, JSONObject[] value) {
                WrappedChatComponent[] result = new WrappedChatComponent[value.length];
                for (int i = 0; i < value.length; ++i) {
                    result[i] = WrappedChatComponent.fromJson((String)value[i].toJSONString());
                }
                packet.getChatComponentArrays().writeSafely(index.intValue(), (Object)result);
            }
        });
    }
}

