/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Skin;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Skin.Skin;
import com.pie.tlatoani.Tablist.Tablist;
import com.pie.tlatoani.Util.UtilReflection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public class SkinManager {
    private static HashMap<Player, Skin> actualSkins = new HashMap();
    private static HashMap<Player, Skin> displayedSkins = new HashMap();
    private static Table<Player, Player, Skin> personalDisplayedSkins = Tables.newCustomTable(new HashMap(), (Supplier)new Supplier<Map<Player, Skin>>(){

        public Map<Player, Skin> get() {
            return new HashMap<Player, Skin>();
        }
    });
    private static HashMap<Player, String> nameTags = new HashMap();
    private static HashMap<Player, String> tabNames = new HashMap();
    private static ArrayList<Player> spawnedPlayers = new ArrayList();
    private static UtilReflection.MethodInvoker craftPlayerGetHandle = null;
    private static UtilReflection.MethodInvoker moveToWorld = null;

    private SkinManager() {
    }

    public static void onJoin(Player player) {
        nameTags.put(player, player.getName());
        SkinManager.getActualSkin(player);
        SkinManager.getNameTag(player);
        SkinManager.getTablistName(player);
    }

    public static void onQuit(Player player) {
        actualSkins.remove(player);
        displayedSkins.remove(player);
        for (Player target : Bukkit.getOnlinePlayers()) {
            personalDisplayedSkins.remove((Object)player, (Object)target);
            personalDisplayedSkins.remove((Object)target, (Object)player);
        }
        personalDisplayedSkins.remove((Object)player, (Object)player);
        nameTags.remove(player);
    }

    public static Skin getActualSkin(Player player) {
        Skin skin = actualSkins.get(player);
        if (skin == null) {
            skin = new Skin.Collected(WrappedGameProfile.fromPlayer((Player)player).getProperties().get((Object)"textures"));
            Mundo.debug(SkinManager.class, "SKINTEXTURE GIVEN BY PROTOCOLLIB FOR PLAYER " + player.getName() + " = " + skin);
            if (!skin.toString().equals("[]")) {
                actualSkins.put(player, skin);
                if (!displayedSkins.containsKey(player)) {
                    displayedSkins.put(player, skin);
                }
            }
        }
        Mundo.debug(SkinManager.class, "ACTUALSKIN OF PLAYER " + player.getName() + " = " + skin);
        return skin;
    }

    public static Skin getDisplayedSkin(Player player) {
        return displayedSkins.get(player);
    }

    public static void setDisplayedSkin(Player player, Skin skin) {
        Mundo.debug(SkinManager.class, "SETTING DISPLAYED SKIN OF" + player.getName() + " TO " + skin);
        if (skin != null && !skin.toString().equals("[]")) {
            displayedSkins.put(player, skin);
        } else {
            displayedSkins.put(player, SkinManager.getActualSkin(player));
        }
        if (spawnedPlayers.contains(player)) {
            ArrayList<Player> targets = new ArrayList<Player>();
            targets.addAll(Bukkit.getOnlinePlayers());
            targets.removeAll(personalDisplayedSkins.row((Object)player).keySet());
            SkinManager.specificallyRefreshPlayer(player, targets);
            if (!personalDisplayedSkins.contains((Object)player, (Object)player)) {
                SkinManager.respawnPlayer(player);
            }
        }
    }

    public static Skin getPersonalDisplayedSkin(Player player, Player target) {
        Skin result = (Skin)personalDisplayedSkins.get((Object)player, (Object)target);
        if (result == null) {
            result = SkinManager.getDisplayedSkin(player);
        }
        return result;
    }

    public static void setPersonalDisplayedSkin(Player player, Collection<Player> targets, Skin value) {
        for (Player target : targets) {
            if (value != null) {
                personalDisplayedSkins.put((Object)player, (Object)target, (Object)value);
                continue;
            }
            personalDisplayedSkins.remove((Object)player, (Object)target);
        }
        if (spawnedPlayers.contains(player)) {
            SkinManager.specificallyRefreshPlayer(player, targets);
            if (targets.contains(player)) {
                SkinManager.respawnPlayer(player);
            }
        }
    }

    public static void setDisplayedSkinExcluding(Player player, Collection<Player> excludes, Skin value) {
        Skin oldSkin = displayedSkins.get(player);
        for (Player exclude : excludes) {
            if (personalDisplayedSkins.contains((Object)player, (Object)exclude)) continue;
            personalDisplayedSkins.put((Object)player, (Object)exclude, (Object)oldSkin);
        }
        SkinManager.setDisplayedSkin(player, value);
    }

    public static String getNameTag(Player player) {
        String nameTag = nameTags.get(player);
        if (nameTag == null) {
            nameTag = player.getName();
            nameTags.put(player, nameTag);
        }
        return nameTag;
    }

    public static void setNameTag(final Player player, String nameTag) {
        Team team;
        if (nameTag != null && nameTag.length() > 16) {
            nameTag = nameTag.substring(0, 16);
        }
        Mundo.debug(SkinManager.class, "Setting nametag of " + player.getName() + " to " + nameTag);
        final String oldNameTag = SkinManager.getNameTag(player);
        if (nameTag == null) {
            nameTag = player.getName();
        }
        Team team2 = team = player.getScoreboard() != null ? player.getScoreboard().getEntryTeam(player.getName()) : null;
        if (team != null) {
            team.removeEntry(player.getName());
            Mundo.scheduler.runTaskLater((Plugin)Mundo.instance, new Runnable(){

                @Override
                public void run() {
                    team.addEntry(player.getName());
                }
            }, 1L);
        }
        Objective objective = player.getScoreboard() != null ? player.getScoreboard().getObjective(DisplaySlot.BELOW_NAME) : null;
        Score score = null;
        int actualScore = 0;
        if (objective != null) {
            score = objective.getScore(player.getName());
            actualScore = score.getScore();
            score.setScore(0);
        }
        nameTags.put(player, nameTag);
        SkinManager.refreshPlayer(player);
        SkinManager.updateTablistName(player);
        if (objective != null) {
            score.setScore(actualScore);
        }
        nameTags.forEach(new BiConsumer<Player, String>(){

            @Override
            public void accept(final Player nameTagOwner, String s) {
                if (s.equals(oldNameTag)) {
                    Team team1;
                    Team team = team1 = nameTagOwner.getScoreboard() != null ? nameTagOwner.getScoreboard().getEntryTeam(nameTagOwner.getName()) : null;
                    if (team1 != null) {
                        team1.removeEntry(nameTagOwner.getName());
                        Mundo.scheduler.runTaskLater((Plugin)Mundo.instance, new Runnable(){

                            @Override
                            public void run() {
                                team1.addEntry(nameTagOwner.getName());
                            }
                        }, 1L);
                    }
                }
            }
        });
    }

    public static String getTablistName(Player player) {
        String tablistName = tabNames.get(player);
        if (tablistName == null) {
            tablistName = player.getName();
            tabNames.put(player, tablistName);
        }
        return tablistName;
    }

    public static void setTablistName(Player player, String tablistName) {
        if (tablistName == null) {
            tablistName = player.getName();
        }
        tabNames.put(player, tablistName);
        SkinManager.updateTablistName(player);
    }

    private static void refreshPlayer(final Player player) {
        Mundo.debug(SkinManager.class, "Now hiding player " + player.getName());
        for (Player target : Bukkit.getOnlinePlayers()) {
            if (target.equals(player)) continue;
            target.hidePlayer(player);
        }
        Mundo.scheduler.scheduleSyncDelayedTask((Plugin)Mundo.instance, new Runnable(){

            @Override
            public void run() {
                Mundo.debug(SkinManager.class, "Now showing player " + player.getName());
                for (Player target : Bukkit.getOnlinePlayers()) {
                    if (target.equals(player)) continue;
                    target.showPlayer(player);
                }
            }
        }, 1L);
    }

    private static void specificallyRefreshPlayer(final Player player, final Collection<Player> targets) {
        for (Player target : targets) {
            if (target.equals(player)) continue;
            target.hidePlayer(player);
        }
        Mundo.syncDelay(1, new Runnable(){

            @Override
            public void run() {
                for (Player target : targets) {
                    if (target.equals(player)) continue;
                    target.showPlayer(player);
                }
            }
        });
    }

    private static void respawnPlayer(Player player) {
        boolean playerHidden = Tablist.getTablistForPlayer(player).isPlayerHidden(player);
        if (!playerHidden) {
            List<Player> singlePlayer = Collections.singletonList(player);
            Tablist.hideInTablist(singlePlayer, singlePlayer);
            Tablist.showInTablist(singlePlayer, singlePlayer);
        }
        Location playerLoc = player.getLocation();
        Mundo.debug(SkinManager.class, "playerLoc1 = " + playerLoc);
        World mainWorld = (World)Bukkit.getWorlds().get(0);
        if (mainWorld.getName().equals(player.getWorld().getName())) {
            try {
                moveToWorld.invoke(UtilReflection.nmsServer, craftPlayerGetHandle.invoke(player, new Object[0]), SkinManager.convertDimension(player.getWorld().getEnvironment()), true, playerLoc, true);
            }
            catch (Exception e) {
                Mundo.debug(SkinManager.class, "Failed to make player see his skin change");
                Mundo.reportException(SkinManager.class, e);
            }
        } else {
            player.teleport(mainWorld.getHighestBlockAt(mainWorld.getSpawnLocation()).getLocation());
            player.teleport(playerLoc);
        }
    }

    private static void checkForTeamChanges() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            String fullTablistName;
            Team team = player.getScoreboard() != null ? player.getScoreboard().getEntryTeam(player.getName()) : null;
            String string = fullTablistName = team == null ? SkinManager.getTablistName(player) : team.getPrefix() + SkinManager.getTablistName(player) + team.getSuffix();
            if (player.getPlayerListName().equals(fullTablistName)) continue;
            SkinManager.updateTablistName(player);
        }
    }

    private static void updateTablistName(Player player) {
        Team team;
        Team team2 = team = player.getScoreboard() != null ? player.getScoreboard().getEntryTeam(player.getName()) : null;
        if (team == null) {
            player.setPlayerListName(SkinManager.getTablistName(player));
        } else {
            player.setPlayerListName(team.getPrefix() + SkinManager.getTablistName(player) + team.getSuffix());
        }
    }

    private static int convertDimension(World.Environment dimension) {
        switch (dimension) {
            case NETHER: {
                return -1;
            }
            case THE_END: {
                return 1;
            }
        }
        return 0;
    }

    static {
        if (Mundo.implementPacketStuff.booleanValue()) {
            try {
                craftPlayerGetHandle = UtilReflection.getTypedMethod(UtilReflection.getCraftBukkitClass("entity.CraftPlayer"), "getHandle", UtilReflection.getMinecraftClass("EntityPlayer"), new Class[0]);
                moveToWorld = UtilReflection.getMethod(UtilReflection.getMinecraftClass("DedicatedPlayerList"), "moveToWorld", UtilReflection.getMinecraftClass("EntityPlayer"), Integer.TYPE, Boolean.TYPE, Location.class, Boolean.TYPE);
            }
            catch (Exception e) {
                Mundo.reportException(SkinManager.class, e);
            }
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

                public void onPacketSending(PacketEvent event) {
                    if (!event.isCancelled() && event.getPlayer() != null && event.getPacket().getPlayerInfoAction().read(0) == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
                        Mundo.debug(SkinManager.class, "EVENT.GETPLAYER = " + event.getPlayer().getName());
                        List playerInfoDatas = (List)event.getPacket().getPlayerInfoDataLists().readSafely(0);
                        ArrayList<PlayerInfoData> newPlayerInfoDatas = new ArrayList<PlayerInfoData>();
                        for (PlayerInfoData playerInfoData : playerInfoDatas) {
                            Player player = Bukkit.getPlayer((UUID)playerInfoData.getProfile().getUUID());
                            PlayerInfoData newPlayerInfoData = playerInfoData;
                            if (player != null && !spawnedPlayers.contains(player)) {
                                Mundo.debug(SkinManager.class, "NEW PLAYER !");
                                spawnedPlayers.add(player);
                                if (!actualSkins.containsKey(player) && !actualSkins.containsKey(player)) {
                                    Skin.Collected skin = new Skin.Collected(playerInfoData.getProfile().getProperties().get((Object)"textures"));
                                    Mundo.debug(SkinManager.class, "ALTERNATIVE SKINTEXTURE FOUND IN PACKET = " + skin);
                                    if (!skin.toString().equals("[]")) {
                                        actualSkins.put(player, skin);
                                        displayedSkins.put(player, skin);
                                    }
                                }
                            }
                            if (player != null) {
                                Mundo.debug(SkinManager.class, "Pre Namtatg: " + playerInfoData.getProfile().getName());
                                String nameTag = SkinManager.getNameTag(player);
                                String tabName = player.getPlayerListName();
                                newPlayerInfoData = new PlayerInfoData(playerInfoData.getProfile().withName(nameTag), playerInfoData.getLatency(), playerInfoData.getGameMode(), nameTag.equals(tabName) ? null : WrappedChatComponent.fromText((String)player.getPlayerListName()));
                                Mundo.debug(SkinManager.class, "Post Namtatg: " + newPlayerInfoData.getProfile().getName());
                                Skin skin = SkinManager.getPersonalDisplayedSkin(player, event.getPlayer());
                                Mundo.debug(SkinManager.class, "PLAYER ACTUAL NAME: " + player.getName());
                                Mundo.debug(SkinManager.class, "SKINTEXTURE REPLACEMENT (MAY OR MAY NOT EXIST): " + skin);
                                if (skin != null) {
                                    skin.retrieveSkinTextures((Multimap<String, WrappedSignedProperty>)newPlayerInfoData.getProfile().getProperties());
                                }
                            }
                            newPlayerInfoDatas.add(newPlayerInfoData);
                        }
                        event.getPacket().getPlayerInfoDataLists().writeSafely(0, newPlayerInfoDatas);
                    }
                }
            });
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.SCOREBOARD_TEAM}){

                public void onPacketSending(PacketEvent event) {
                    if (!event.isCancelled() && event.getPlayer() != null) {
                        Collection playerNames = (Collection)event.getPacket().getSpecificModifier(Collection.class).readSafely(0);
                        Mundo.debug(SkinManager.class, "playerNames: " + playerNames);
                        ArrayList<String> addedNames = new ArrayList<String>();
                        for (String s : playerNames) {
                            Player player = Bukkit.getPlayerExact((String)s);
                            if (player == null) continue;
                            String nameTag = SkinManager.getNameTag(player);
                            if (!nameTag.equals(s)) {
                                addedNames.add(nameTag);
                            }
                            Mundo.debug(SkinManager.class, "Player " + s + ", Nametag " + nameTag);
                        }
                        Mundo.debug(SkinManager.class, "addedNames: " + addedNames);
                        HashSet<String> finalNames = new HashSet<String>();
                        finalNames.addAll(playerNames);
                        finalNames.addAll(addedNames);
                        Mundo.debug(SkinManager.class, "finalNames: " + finalNames);
                        event.getPacket().getSpecificModifier(Collection.class).writeSafely(0, finalNames);
                        SkinManager.checkForTeamChanges();
                    }
                }
            });
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.SCOREBOARD_SCORE}){

                public void onPacketSending(PacketEvent event) {
                    Player player;
                    StructureModifier stringStructureModifier = event.getPacket().getStrings();
                    String actualString = (String)stringStructureModifier.read(0);
                    Player player2 = player = actualString == null ? null : Bukkit.getPlayerExact((String)actualString);
                    if (player != null) {
                        stringStructureModifier.writeSafely(0, (Object)SkinManager.getNameTag(player));
                        Mundo.debug(SkinManager.class, "REPLACING SCORE IN NAME " + actualString);
                    }
                }
            });
        }
    }
}

