/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.PacketInfoConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprObjectOfPacket
extends SimpleExpression<Object> {
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    private boolean isSingle = true;
    private Class aClass = Object.class;
    private PacketInfoConverter converter = null;
    private static Map<String, PacketInfoConverter> singleConverters = new LinkedHashMap<String, PacketInfoConverter>();
    private static Map<String, PacketInfoConverter<Object[]>> pluralConverters = new LinkedHashMap<String, PacketInfoConverter<Object[]>>();

    private static <T> void registerSingleConverter(String key, PacketInfoConverter<T> converter) {
        singleConverters.put(key, converter);
    }

    private static void registerPluralConverter(String key, PacketInfoConverter<Object[]> converter) {
        pluralConverters.put(key, converter);
    }

    private static PacketInfoConverter getConverter(String key, Boolean isSingle) {
        return isSingle != false ? singleConverters.get(key) : pluralConverters.get(key);
    }

    public static String getConverterNamesPattern(Boolean isSingle) {
        String result = "";
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            result = result + "|" + ++i + "\u00a6" + name;
        }
        return result;
    }

    public static String getConverterNameByIndex(int index, Boolean isSingle) {
        int i = 0;
        for (String name : isSingle != false ? singleConverters.keySet() : pluralConverters.keySet()) {
            if (++i != index) continue;
            return name;
        }
        return null;
    }

    private static PacketInfoConverter createConverter(final Method method) {
        return new PacketInfoConverter(){

            public Object get(PacketContainer packet, Integer index) {
                try {
                    StructureModifier structureModifier = (StructureModifier)method.invoke((Object)packet, new Object[0]);
                    return structureModifier.readSafely(index.intValue());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Mundo.debug((Object)this, e);
                    return null;
                }
            }

            public void set(PacketContainer packet, Integer index, Object value) {
                try {
                    StructureModifier structureModifier = (StructureModifier)method.invoke((Object)packet, new Object[0]);
                    structureModifier.writeSafely(index.intValue(), value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Mundo.debug((Object)this, e);
                }
            }
        };
    }

    protected Object[] get(Event event) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        if (this.isSingle) {
            return new Object[]{this.converter.get(packet, index)};
        }
        return (Object[])this.converter.get(packet, index);
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public Class<?> getReturnType() {
        return this.aClass;
    }

    public String toString(Event event, boolean b) {
        return "%type/string% packetinfo %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String methodGetName;
        String key;
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        boolean bl = this.isSingle = i % 2 == 0;
        if (expressions[0] == null) {
            key = ExprObjectOfPacket.getConverterNameByIndex(parseResult.mark, this.isSingle);
            methodGetName = null;
        } else if (expressions[0] instanceof Literal && expressions[0].getReturnType() == ClassInfo.class) {
            ClassInfo classInfo = (ClassInfo)((Literal)expressions[0]).getSingle();
            key = classInfo.getCodeName();
            this.aClass = classInfo.getC();
            String classname = this.aClass.getSimpleName();
            Mundo.debug((Object)this, "Class simple name: " + classname);
            if (!this.isSingle) {
                methodGetName = classname + "Arrays";
                this.isSingle = false;
            } else {
                methodGetName = classname.substring(classname.length() - 1).equals("y") ? classname.substring(0, classname.length() - 1) + "ies" : classname + "s";
            }
        } else {
            if (!(expressions[0] instanceof VariableString)) {
                Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the %string% pinfo expression!"));
                return false;
            }
            String fullstring = ((VariableString)expressions[0]).toString();
            methodGetName = fullstring.substring(1, fullstring.length() - 1);
            key = methodGetName.toLowerCase();
        }
        this.converter = ExprObjectOfPacket.getConverter(key, this.isSingle);
        if (this.converter != null) {
            Mundo.debug((Object)this, "Converter to PLib type: " + key);
            return true;
        }
        try {
            Method method = PacketContainer.class.getMethod("get" + methodGetName, new Class[0]);
            Mundo.debug((Object)this, "Method: " + method.toString());
            this.converter = ExprObjectOfPacket.createConverter(method);
            return true;
        }
        catch (NoSuchMethodException e) {
            Mundo.debug((Object)this, e);
            Skript.error((String)(key + " is not applicable for the '%type/string% pinfo [array] %number% of %packet%' expression."));
            return false;
        }
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        this.converter.set(packet, index, this.isSingle ? delta[0] : delta);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            if (this.isSingle) {
                return (Class[])CollectionUtils.array((Object[])new Class[]{this.aClass});
            }
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    static {
        ExprObjectOfPacket.registerSingleConverter("object", new PacketInfoConverter<Object>(){

            @Override
            public Object get(PacketContainer packet, Integer index) {
                return packet.getModifier().readSafely(index.intValue());
            }

            @Override
            public void set(PacketContainer packet, Integer index, Object value) {
                packet.getModifier().writeSafely(index.intValue(), value);
            }
        });
        ExprObjectOfPacket.registerSingleConverter("location", new PacketInfoConverter<Location>(){

            @Override
            public Location get(PacketContainer packet, Integer index) {
                StructureModifier structureModifier = packet.getBlockPositionModifier();
                BlockPosition blockPosition = (BlockPosition)structureModifier.readSafely(index.intValue());
                if (blockPosition == null) {
                    return null;
                }
                return blockPosition.toLocation((World)Bukkit.getWorlds().get(0));
            }

            @Override
            public void set(PacketContainer packet, Integer index, Location value) {
                StructureModifier structureModifier = packet.getBlockPositionModifier();
                BlockPosition blockPosition = new BlockPosition(value.toVector());
                structureModifier.writeSafely(index.intValue(), (Object)blockPosition);
            }
        });
        ExprObjectOfPacket.registerSingleConverter("material", new PacketInfoConverter<ItemStack>(){

            @Override
            public ItemStack get(PacketContainer packet, Integer index) {
                Material material = (Material)packet.getBlocks().readSafely(index.intValue());
                return material == null ? null : new ItemStack(material);
            }

            @Override
            public void set(PacketContainer packet, Integer index, ItemStack value) {
                Material material = value.getType();
                packet.getBlocks().writeSafely(index.intValue(), (Object)material);
            }
        });
        ExprObjectOfPacket.registerPluralConverter("collection", new PacketInfoConverter<Object[]>(){

            @Override
            public Object[] get(PacketContainer packet, Integer index) {
                Collection collection = (Collection)packet.getSpecificModifier(Collection.class).readSafely(index.intValue());
                return collection == null ? new Object[]{} : collection.toArray();
            }

            @Override
            public void set(PacketContainer packet, Integer index, Object[] value) {
                packet.getSpecificModifier(Collection.class).writeSafely(index.intValue(), Arrays.asList(value));
            }
        });
    }
}

