/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Socket2;

import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Util.Notification;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;

public class Socket2 {
    private Socket socket;
    private volatile State state = State.NEW;
    private BufferedWriter writer = null;
    private Notification.Query<CloseNotification> closeQuery = new Notification.Query();
    private HashMap<String, Notification.Query<ReadNotification>> readQueries = new HashMap();

    public String getLocalHost() {
        return this.socket.getLocalAddress().getHostName();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public String getExternalHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public int getExternalPort() {
        return this.socket.getPort();
    }

    public State getState() {
        return this.state;
    }

    public void connect(String host, int port, int timeout, String password, Runnable whenDone) throws Exception {
        if (this.state != State.NEW) {
            throw new Exception("You can only connect a new socket!");
        }
        this.state = State.CONNECTING;
        Mundo.async(new Connector(whenDone, host, port, timeout, password));
    }

    public void use(Socket socket, String password, Runnable whenDone) throws Exception {
        if (this.state != State.NEW) {
            throw new Exception("You can only connect a new socket!");
        }
        if (!socket.isConnected()) {
            throw new IllegalArgumentException("The socket " + socket + " should have been already connected prior to use with the Socket2(Socket socket) constructor!");
        }
        this.socket = socket;
        Mundo.async(new Reader(password, whenDone));
    }

    public void write(String title, String message) {
        if (this.state == State.CONNECTED && title.indexOf(58) == -1) {
            Mundo.async(new Writer(title + ":" + message));
        }
    }

    public void close() throws Exception {
        if (this.state == State.CONNECTED) {
            this.state = State.CLOSED;
            Mundo.async(new Closer());
        }
    }

    public void setCloseHandler(Notification.Handler<CloseNotification> handler) {
        this.closeQuery.setHandler(handler);
    }

    public void setReadHandler(String title, Notification.Handler<ReadNotification> handler) {
        this.getReadQuery(title).setHandler(handler);
    }

    private void onClose() {
        Mundo.sync(new Runnable(){

            @Override
            public void run() {
                Socket2.this.closeQuery.notify(new CloseNotification());
            }
        });
    }

    private void onRead(final String title, final String message) {
        Mundo.sync(new Runnable(){

            @Override
            public void run() {
                Socket2.this.getReadQuery(title).notify(new ReadNotification(message));
            }
        });
    }

    private Notification.Query<ReadNotification> getReadQuery(String title) {
        if (!this.readQueries.containsKey(title)) {
            this.readQueries.put(title, new Notification.Query());
        }
        return this.readQueries.get(title);
    }

    public static class ReadNotification
    extends Notification {
        public final String message;

        private ReadNotification(String message) {
            this.message = message;
        }
    }

    public static class CloseNotification
    extends Notification {
    }

    private class Closer
    implements Runnable {
        private Closer() {
        }

        @Override
        public void run() {
            try {
                Socket2.this.socket.close();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private class Writer
    implements Runnable {
        final String message;

        Writer(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                Socket2.this.writer.newLine();
                Socket2.this.writer.write(this.message);
                Socket2.this.writer.flush();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private class Reader
    implements Runnable {
        final String password;
        final BufferedReader reader;
        final Runnable whenDone;

        Reader(String password, Runnable whenDone) {
            this.password = password;
            this.reader = null;
            this.whenDone = whenDone;
        }

        Reader(BufferedReader reader) {
            this.password = null;
            this.reader = reader;
            this.whenDone = null;
        }

        @Override
        public void run() {
            try {
                String line;
                if (this.reader == null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Socket2.this.socket.getInputStream()));
                    Socket2.this.writer = new BufferedWriter(new OutputStreamWriter(Socket2.this.socket.getOutputStream()));
                    line = reader.readLine();
                    if (line == null || !line.startsWith("MundoSK_1.7.3:")) {
                        Socket2.this.state = State.INCOMPATIBLE_SOCKET_FAILURE;
                        if (line != null) {
                            Socket2.this.socket.close();
                        }
                        Mundo.sync(this.whenDone);
                    } else if (this.password.substring(14).equals(line)) {
                        Socket2.this.state = State.CONNECTED;
                        Socket2.this.writer.write("PASSWORD_CORRECT");
                        Socket2.this.writer.flush();
                        Mundo.sync(this.whenDone);
                    } else {
                        Socket2.this.state = State.INCORRECT_PASSWORD_FAILURE;
                        Socket2.this.writer.write("PASSWORD_INCORRECT");
                        Socket2.this.writer.flush();
                        Socket2.this.socket.close();
                        Mundo.sync(this.whenDone);
                        return;
                    }
                }
                while ((line = this.reader.readLine()) != null) {
                    int colon = line.indexOf(58);
                    if (colon < 0) continue;
                    Socket2.this.onRead(line.substring(0, colon), line.substring(colon + 1));
                }
                Socket2.this.state = State.CLOSED;
                Socket2.this.onClose();
            }
            catch (IOException e) {
                Mundo.reportException(this, e);
            }
        }
    }

    private class Connector
    implements Runnable {
        Runnable whenDone;
        String host;
        int port;
        int timeout;
        String password;

        Connector(Runnable whenDone, String host, int port, int timeout, String password) {
            this.whenDone = whenDone;
            this.host = host;
            this.port = port;
            this.timeout = timeout;
            this.password = password;
        }

        @Override
        public void run() {
            Socket2.this.socket = new Socket();
            try {
                Socket2.this.socket.connect(new InetSocketAddress(this.host, this.port), this.timeout);
                Socket2.this.writer = new BufferedWriter(new OutputStreamWriter(Socket2.this.socket.getOutputStream()));
                BufferedReader reader = new BufferedReader(new InputStreamReader(Socket2.this.socket.getInputStream()));
                Socket2.this.writer.write("MundoSK_1.7.3:" + this.password);
                String verification = reader.readLine();
                if ("PASSWORD_CORRECT".equals(verification)) {
                    Socket2.this.state = State.CONNECTED;
                    Mundo.sync(this.whenDone);
                    new Reader(reader).run();
                } else if ("PASSWORD_INCORRECT".equals(verification)) {
                    Socket2.this.state = State.INCORRECT_PASSWORD_FAILURE;
                    Mundo.sync(this.whenDone);
                } else {
                    Socket2.this.state = State.INCOMPATIBLE_SOCKET_FAILURE;
                    Mundo.sync(this.whenDone);
                }
            }
            catch (SocketTimeoutException e) {
                Socket2.this.state = State.TIMEOUT_FAILURE;
            }
            catch (IOException e) {
                Socket2.this.state = State.UNKNOWN_FAILURE;
                Mundo.reportException(this, e);
            }
        }
    }

    public static enum State {
        NEW,
        CONNECTING,
        CONNECTED,
        CLOSED,
        TIMEOUT_FAILURE,
        INCORRECT_PASSWORD_FAILURE,
        INCOMPATIBLE_SOCKET_FAILURE,
        UNKNOWN_FAILURE;

    }
}

