/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani;

import ch.njol.skript.Skript;
import com.pie.tlatoani.Achievement.AchievementMundo;
import com.pie.tlatoani.Book.BookMundo;
import com.pie.tlatoani.Chunk.ChunkMundo;
import com.pie.tlatoani.CodeBlock.CodeBlockMundo;
import com.pie.tlatoani.CustomEvent.CustomEventMundo;
import com.pie.tlatoani.EnchantedBook.EnchantedBookMundo;
import com.pie.tlatoani.Generator.GeneratorManager;
import com.pie.tlatoani.ListUtil.ListUtil;
import com.pie.tlatoani.Miscellaneous.MiscMundo;
import com.pie.tlatoani.Probability.ProbabilityMundo;
import com.pie.tlatoani.ProtocolLib.PacketManager;
import com.pie.tlatoani.Registration.Documentation;
import com.pie.tlatoani.Registration.DocumentationCommand;
import com.pie.tlatoani.Registration.Registration;
import com.pie.tlatoani.Skin.SkinMundo;
import com.pie.tlatoani.Socket.SocketMundo;
import com.pie.tlatoani.Socket.UtilFunctionSocket;
import com.pie.tlatoani.Tablist.TablistManager;
import com.pie.tlatoani.TerrainControl.TerrainControlMundo;
import com.pie.tlatoani.Throwable.ThrowableMundo;
import com.pie.tlatoani.Util.Config;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.Metrics;
import com.pie.tlatoani.Util.MundoUtil;
import com.pie.tlatoani.Util.Scheduling;
import com.pie.tlatoani.WebSocket.WebSocketManager;
import com.pie.tlatoani.WorldBorder.WorldBorderMundo;
import com.pie.tlatoani.WorldCreator.WorldCreatorMundo;
import com.pie.tlatoani.WorldManagement.WorldLoader.WorldLoader;
import com.pie.tlatoani.WorldManagement.WorldManagementMundo;
import com.pie.tlatoani.ZExperimental.ZExperimentalMundo;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.java.JavaPlugin;

public class Mundo
extends JavaPlugin {
    public static Mundo INSTANCE;
    public static final ChatColor PRIMARY_CHAT_COLOR;
    public static final ChatColor ALT_CHAT_COLOR;
    public static final ChatColor TRI_CHAT_COLOR;

    public void onEnable() {
        INSTANCE = this;
        Config.reload();
        Logging.load(this.getLogger());
        Scheduling.load();
        WorldLoader.load();
        Skript.registerAddon((JavaPlugin)this);
        Logging.info("Pie is awesome :D");
        if (this.getDescription().getVersion().toUpperCase().contains("BETA")) {
            Logging.info("You are currently running a BETA version of MundoSK");
            Logging.info("You should only run BETA versions of MundoSK on test servers unless Tlatoani or another reliable source has recommended otherwise");
        }
        if (!Config.DEBUG_PACKAGES.getCurrentValue().isEmpty()) {
            Logging.info("You have enabled debug for certain packages in MundoSK config");
            Logging.info("Debug should only be enabled when you are trying to fix a bug or assist someone else with fixing a bug in MundoSK");
            Logging.info("By having debug enabled, you will have tons of random annoying spam in your console");
            Logging.info("If you would like to disable debug, simply go to your 'plugins' folder, go to the 'MundoSK' folder, open 'config.yml', and where it says 'debug', remove all following text");
        }
        Registration.register("Book", BookMundo::load, new String[0]);
        Registration.register("Chunk", ChunkMundo::load, new String[0]);
        Registration.register("CodeBlock", CodeBlockMundo::load, new String[0]);
        Registration.register("EnchantedBook", EnchantedBookMundo::load, new String[0]);
        Registration.register("Generator", GeneratorManager::load, new String[0]);
        Registration.register("ListUtil", ListUtil::load, new String[0]);
        Registration.register("Miscellaneous", MiscMundo::load, new String[0]);
        Registration.register("Probability", ProbabilityMundo::load, new String[0]);
        Registration.register("Socket", SocketMundo::load, new String[0]);
        Registration.register("Throwable", ThrowableMundo::load, new String[0]);
        Registration.register("WebSocket", WebSocketManager::load, new String[0]);
        Registration.register("WorldBorder", WorldBorderMundo::load, new String[0]);
        Registration.register("WorldCreator", WorldCreatorMundo::load, new String[0]);
        Registration.register("WorldManagement", WorldManagementMundo::load, new String[0]);
        if (MundoUtil.serverHasPlugin("ProtocolLib")) {
            Registration.register("Packet", PacketManager::load, "ProtocolLib");
            if (Config.IMPLEMENT_PACKET_STUFF.getCurrentValue().booleanValue()) {
                Registration.register("Skin", SkinMundo::load, "ProtocolLib");
                Registration.register("Tablist", TablistManager::load, "ProtocolLib");
            }
        }
        if (MundoUtil.serverHasPlugin("TerrainControl")) {
            Registration.register("TerrainControl", TerrainControlMundo::load, "TerrainControl");
        }
        if (Bukkit.getVersion().contains("1.8") || Bukkit.getVersion().contains("1.9") || Bukkit.getVersion().contains("1.10") || Bukkit.getVersion().contains("1.11")) {
            Registration.register("Achievement", AchievementMundo::load, new String[0]);
        }
        Registration.register("ZExperimental", ZExperimentalMundo::load, new String[0]);
        Registration.register("CustomEvent", CustomEventMundo::load, new String[0]);
        Logging.info("Awesome syntaxes have been registered!");
        Scheduling.sync(Documentation::buildDocumentation);
        Scheduling.sync(Metrics::enableMundoSKMetrics);
    }

    public void onDisable() {
        UtilFunctionSocket.onDisable();
        Logging.info("Closed all function sockets (if any were open)");
        WebSocketManager.stopAllServers(0);
        Logging.info("Stopped all WebSocket servers (if any were open)");
        try {
            WorldLoader.save();
            Logging.info("Successfully saved all (if any) world loaders");
        }
        catch (IOException e) {
            Logging.info("A problem occurred while saving world loaders");
            Logging.reportException((Object)this, e);
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String unusedWorldName, String id) {
        return GeneratorManager.getSkriptGenerator(id);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equals("mundosk")) {
            if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
                sender.sendMessage(PRIMARY_CHAT_COLOR + "MundoSK Command Help");
                sender.sendMessage(Mundo.formatCommandDescription("[help]", "Prints this list of commands"));
                sender.sendMessage(Mundo.formatCommandDescription("desc[ription]", "Prints a description of MundoSK"));
                sender.sendMessage(Mundo.formatCommandDescription("ver[sion]", "Prints the version of MundoSK running on this server"));
                sender.sendMessage(Mundo.formatCommandDescription("config", "Prints the current config options"));
                sender.sendMessage(Mundo.formatCommandDescription("config reload", "Reloads MundoSK's config"));
            } else if (args[0].equalsIgnoreCase("desc") || args[0].equalsIgnoreCase("description")) {
                sender.sendMessage(PRIMARY_CHAT_COLOR + "MundoSK is a Skript Addon that has features including Packets, World Borders, World Management, Custom World Generation, Tablist, Skin Modification, Sockets, and more!");
                sender.sendMessage(Mundo.formatMundoSKInfo("Your MundoSK Version", Mundo.getVersion()));
                sender.sendMessage(Mundo.formatMundoSKInfo("skUnity Forums Page", "https://forums.skunity.com/resources/mundosk.69/"));
                sender.sendMessage(Mundo.formatMundoSKInfo("GitHub", "https://github.com/MundoSK/MundoSK"));
                sender.sendMessage(Mundo.formatMundoSKInfo("Skript Addon Discord Invite", "https://discord.gg/vb9dGbu"));
            } else if (args[0].equalsIgnoreCase("ver") || args[0].equalsIgnoreCase("version")) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Your MundoSK Version", Mundo.getVersion()));
            } else if (args[0].equalsIgnoreCase("config")) {
                if (args.length >= 2 && args[1].equalsIgnoreCase("reload")) {
                    Config.reload();
                    sender.sendMessage(PRIMARY_CHAT_COLOR + "Reloaded MundoSK's Config!");
                }
                sender.sendMessage(PRIMARY_CHAT_COLOR + "MundoSK Config");
                Config.displayConfig(sender);
            } else if (args[0].equalsIgnoreCase("doc") || args[0].equalsIgnoreCase("docs")) {
                DocumentationCommand.accessDocumentation(sender, args);
            } else {
                sender.sendMessage(PRIMARY_CHAT_COLOR + "MundoSK didn't understand this command argument: " + ALT_CHAT_COLOR + args[0]);
                sender.sendMessage(PRIMARY_CHAT_COLOR + "Do " + ALT_CHAT_COLOR + "/mundosk " + PRIMARY_CHAT_COLOR + "to show a list of MundoSK commands");
            }
            return true;
        }
        return false;
    }

    public static String formatCommandDescription(String args, String desc) {
        return ALT_CHAT_COLOR + "/mundosk " + args + " " + PRIMARY_CHAT_COLOR + desc;
    }

    public static String formatMundoSKInfo(String name, String info) {
        return PRIMARY_CHAT_COLOR + name + " " + ALT_CHAT_COLOR + info;
    }

    public static String getVersion() {
        return INSTANCE.getDescription().getVersion();
    }

    static {
        PRIMARY_CHAT_COLOR = ChatColor.DARK_GREEN;
        ALT_CHAT_COLOR = ChatColor.GREEN;
        TRI_CHAT_COLOR = ChatColor.DARK_AQUA;
    }
}

