/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental.SyntaxPiece;

import com.google.common.collect.ImmutableList;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.Concatenation;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.Expression;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.Literal;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.SyntaxPiece;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.Varying;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SyntaxParser {
    public static SyntaxPiece concatenate(List<SyntaxPiece> pieces) {
        if (pieces.size() == 1) {
            return pieces.get(0);
        }
        return new Concatenation((ImmutableList<SyntaxPiece>)ImmutableList.copyOf(pieces));
    }

    public static SyntaxPiece parse(final String string) {
        return new ParsingConsumer(){
            ArrayList<SyntaxPiece> syntaxPieces = new ArrayList();
            StringBuilder literalBuilder = new StringBuilder();
            ParsingIterator parsingIterator = new ParsingIterator(string);

            public SyntaxPiece parse() {
                while (this.parsingIterator.hasNext()) {
                    this.parsingIterator.next(this);
                }
                return SyntaxParser.concatenate(this.syntaxPieces);
            }

            @Override
            public void consumeChar(char chara) {
                this.literalBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol) {
                if (this.literalBuilder.length() > 0) {
                    this.syntaxPieces.add(new Literal(this.literalBuilder.toString()));
                    this.literalBuilder = new StringBuilder();
                }
                switch (symbol) {
                    case EXPRESSION_IDENTIFIER: {
                        this.syntaxPieces.add(SyntaxParser.parseExpression(this.parsingIterator));
                        break;
                    }
                    case VARYING_OPENER: 
                    case OPTIONAL_OPENER: {
                        this.syntaxPieces.add(SyntaxParser.parseVarying(this.parsingIterator, symbol == Symbol.OPTIONAL_OPENER));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal " + (Object)((Object)symbol) + " found");
                    }
                }
            }
        }.parse();
    }

    public static Expression parseExpression(final ParsingIterator parsingIterator) {
        String variable = new ParsingConsumer(){
            StringBuilder stringBuilder = new StringBuilder();
            boolean continu = true;

            public String extract() {
                while (this.continu) {
                    parsingIterator.next(this);
                }
                return this.stringBuilder.toString();
            }

            @Override
            public void consumeChar(char chara) {
                this.stringBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol) {
                if (symbol != Symbol.VARIABLE_IDENTIFIER) {
                    throw new IllegalArgumentException("Baaaad");
                }
                this.continu = false;
            }
        }.extract();
        String exprInfo = new ParsingConsumer(){
            StringBuilder stringBuilder = new StringBuilder();
            boolean continu = true;

            public String extract() {
                while (this.continu) {
                    parsingIterator.next(this);
                }
                return this.stringBuilder.toString();
            }

            @Override
            public void consumeChar(char chara) {
                this.stringBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol) {
                if (symbol != Symbol.EXPRESSION_IDENTIFIER) {
                    throw new IllegalArgumentException("Baaaad");
                }
                this.continu = false;
            }
        }.extract();
        return new Expression(variable, exprInfo);
    }

    public static Varying parseVarying(final ParsingIterator parsingIterator, final boolean optional) {
        return new ParsingConsumer(){
            ArrayList<SyntaxPiece> options = new ArrayList();
            ArrayList<SyntaxPiece> syntaxPieces = new ArrayList();
            StringBuilder literalBuilder = new StringBuilder();
            Optional<String> variable = Optional.empty();
            boolean continu;

            public Varying parse() {
                if (optional) {
                    this.options.add(Literal.EMPTY);
                }
                while (parsingIterator.hasNext() && this.continu) {
                    parsingIterator.next(this);
                }
                if (this.continu) {
                    throw new IllegalArgumentException("Varying never terminated");
                }
                return new Varying((ImmutableList<SyntaxPiece>)ImmutableList.copyOf(this.options), this.variable);
            }

            @Override
            public void consumeChar(char chara) {
                this.literalBuilder.append(chara);
            }

            @Override
            public void consumeSymbol(Symbol symbol) {
                if (this.literalBuilder.length() > 0 && symbol != Symbol.VARIABLE_IDENTIFIER) {
                    this.syntaxPieces.add(new Literal(this.literalBuilder.toString()));
                    this.literalBuilder = new StringBuilder();
                }
                switch (symbol) {
                    case EXPRESSION_IDENTIFIER: {
                        this.syntaxPieces.add(SyntaxParser.parseExpression(parsingIterator));
                        break;
                    }
                    case VARYING_OPENER: 
                    case OPTIONAL_OPENER: {
                        this.syntaxPieces.add(SyntaxParser.parseVarying(parsingIterator, symbol == Symbol.OPTIONAL_OPENER));
                        break;
                    }
                    case VARIABLE_IDENTIFIER: {
                        if (this.variable.isPresent() || !this.syntaxPieces.isEmpty() || !this.options.isEmpty()) {
                            throw new IllegalArgumentException("Illegal " + (Object)((Object)symbol) + "found");
                        }
                        this.variable = Optional.of(this.literalBuilder.toString());
                        this.literalBuilder = new StringBuilder();
                        break;
                    }
                    case VARYING_SEPARATOR: {
                        this.options.add(SyntaxParser.concatenate(this.syntaxPieces));
                        this.syntaxPieces = new ArrayList();
                        break;
                    }
                    default: {
                        this.options.add(SyntaxParser.concatenate(this.syntaxPieces));
                        if (symbol == Symbol.OPTIONAL_CLOSER == optional) {
                            this.continu = false;
                            break;
                        }
                        throw new IllegalArgumentException("Illegal closer: " + (Object)((Object)symbol));
                    }
                }
            }
        }.parse();
    }

    public static interface ParsingConsumer {
        public void consumeChar(char var1);

        public void consumeSymbol(Symbol var1);
    }

    public static class ParsingIterator {
        private String string;

        public ParsingIterator(String string) {
            this.string = string;
        }

        public boolean hasNext() {
            return !this.string.isEmpty();
        }

        public void next(ParsingConsumer consumer) {
            if (this.string.charAt(0) == '\\') {
                consumer.consumeChar(this.string.charAt(1));
                this.string = this.string.substring(2);
            } else {
                Optional<Symbol> symbolOptional = Symbol.fromChar(this.string.charAt(0));
                if (symbolOptional.isPresent()) {
                    consumer.consumeSymbol(symbolOptional.get());
                } else {
                    consumer.consumeChar(this.string.charAt(0));
                }
                this.string = this.string.substring(1);
            }
        }
    }

    public static enum Symbol {
        VARIABLE_IDENTIFIER('='),
        EXPRESSION_IDENTIFIER('%'),
        VARYING_OPENER('('),
        VARYING_CLOSER(')'),
        VARYING_SEPARATOR('|'),
        OPTIONAL_OPENER('['),
        OPTIONAL_CLOSER(']');

        public final char chara;

        private Symbol(char chara) {
            this.chara = chara;
        }

        public static Optional<Symbol> fromChar(char chara) {
            for (Symbol symbol : Symbol.values()) {
                if (symbol.chara != chara) continue;
                return Optional.of(symbol);
            }
            return Optional.empty();
        }
    }
}

