/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WebSocket;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import com.pie.tlatoani.Util.ScopeUtil;
import com.pie.tlatoani.WebSocket.Events.WebSocketCloseEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketErrorEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketHandshakeEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketMessageEvent;
import com.pie.tlatoani.WebSocket.Events.WebSocketOpenEvent;
import java.util.Optional;

public class WebSocketClientFunctionality {
    public final String id;
    private boolean loaded = false;
    public Optional<TriggerItem> onOpen = Optional.empty();
    public Optional<TriggerItem> onHandshake = Optional.empty();
    public Optional<TriggerItem> onClose = Optional.empty();
    public Optional<TriggerItem> onMessage = Optional.empty();
    public Optional<TriggerItem> onError = Optional.empty();

    public WebSocketClientFunctionality() {
        this(null);
    }

    public WebSocketClientFunctionality(String id) {
        this.id = id;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load(Nebula nebula) {
        this.loaded = true;
        this.onOpen = nebula.onOpen.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientOpen", (Class[])new Class[]{WebSocketOpenEvent.Client.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.onHandshake = nebula.onHandshake.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientHandshake", (Class[])new Class[]{WebSocketHandshakeEvent.Client.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.onClose = nebula.onClose.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientClose", (Class[])new Class[]{WebSocketCloseEvent.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.onMessage = nebula.onMessage.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientMessage", (Class[])new Class[]{WebSocketMessageEvent.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.onError = nebula.onError.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)"WebSocketClientError", (Class[])new Class[]{WebSocketErrorEvent.class});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
    }

    public void unload() {
        this.loaded = false;
        this.onOpen = Optional.empty();
        this.onHandshake = Optional.empty();
        this.onClose = Optional.empty();
        this.onMessage = Optional.empty();
        this.onError = Optional.empty();
    }

    public String toString() {
        return "WebSocketClientFunctionality(TriggerItems: " + String.join((CharSequence)", ", this.onOpen.toString(), this.onHandshake.toString(), this.onClose.toString(), this.onMessage.toString(), this.onError.toString()) + ")";
    }

    public static class Nebula {
        public Optional<SectionNode> onOpen = Optional.empty();
        public Optional<SectionNode> onHandshake = Optional.empty();
        public Optional<SectionNode> onClose = Optional.empty();
        public Optional<SectionNode> onMessage = Optional.empty();
        public Optional<SectionNode> onError = Optional.empty();
    }
}

