/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.util.Pair;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public abstract class DocumentationElement {
    public final String name;
    public final String category;
    public final String[] syntaxes;
    public final String[] description;
    public final String originVersion;
    public final String[] requiredPlugins;

    public abstract ElementType getType();

    public abstract void display(CommandSender var1);

    public String toString() {
        return "DocumentationElement(" + this.category + " " + (Object)((Object)this.getType()) + ": " + this.name + ")";
    }

    private DocumentationElement(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins) {
        this.name = name;
        this.category = category;
        this.syntaxes = (String[])Arrays.stream(syntaxes).map(syntax -> syntax.replaceAll("\\d+\u00a6", "")).toArray(String[]::new);
        this.description = description;
        this.originVersion = originVersion;
        this.requiredPlugins = requiredPlugins;
    }

    public static class Scope
    extends DocumentationElement {
        @Override
        public ElementType getType() {
            return ElementType.EFFECT;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Scope", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Since", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            if (this.description.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Description");
                for (String descLine : this.description) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + descLine);
                }
            }
        }

        public Scope(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
        }
    }

    public static class Type
    extends DocumentationElement {
        public final String[] usages;

        public Type(String name, String category, String[] syntaxes, String[] usages, String[] description, String originVersion, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
            this.usages = usages;
        }

        @Override
        public ElementType getType() {
            return ElementType.TYPE;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Type", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Since", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Usages", this.syntaxes.length == 0 ? "Cannot be written in scripts" : String.join((CharSequence)", ", this.usages)));
            if (this.description.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Description");
                for (String descLine : this.description) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + descLine);
                }
            }
        }
    }

    public static class EventValue {
        public final Event parent;
        public final ClassInfo type;
        public final String description;
        public final String originVersion;

        public EventValue(Event parent, ClassInfo type, String description, String originVersion) {
            this.parent = parent;
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "event-" + this.type.getCodeName() + (this.originVersion.equals(this.parent.originVersion) ? "" : Mundo.TRI_CHAT_COLOR + " Since " + this.originVersion) + Mundo.ALT_CHAT_COLOR + " " + this.description);
        }
    }

    public static class Event
    extends DocumentationElement {
        public final boolean cancellable;
        public final EventValue[] eventValues;

        public Event(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, boolean cancellable, Collection<DocumentationBuilder.EventValue> eventValueBuilders) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
            this.cancellable = cancellable;
            this.eventValues = (EventValue[])eventValueBuilders.stream().map(builder -> builder.build(this)).toArray(EventValue[]::new);
        }

        @Override
        public ElementType getType() {
            return ElementType.EVENT;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Event", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Since", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Cancellable", this.cancellable ? "Yes" : "No"));
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            if (this.description.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Description");
                for (String descLine : this.description) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + descLine);
                }
            }
            if (this.eventValues.length > 0) {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Event Values");
                for (EventValue eventValue : this.eventValues) {
                    eventValue.display(sender);
                }
            }
        }
    }

    public static class Changer {
        public final DocumentationElement parent;
        public final Changer.ChangeMode mode;
        public final Optional<Pair<ClassInfo, Boolean>> type;
        public final String description;
        public final String originVersion;

        public Changer(DocumentationElement parent, Changer.ChangeMode mode, Optional<Pair<ClassInfo, Boolean>> type, String description, String originVersion) {
            this.parent = parent;
            this.mode = mode;
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public static String modeSyntax(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: 
                case REMOVE: 
                case RESET: {
                    return mode.name().toLowerCase();
                }
                case SET: {
                    return "set to";
                }
                case DELETE: {
                    return "clear/delete";
                }
                case REMOVE_ALL: {
                    return "remove all";
                }
            }
            throw new IllegalArgumentException("Mode: " + mode);
        }

        public void display(CommandSender sender) {
            String typeSyntax = this.type.map(pair -> " " + ((ClassInfo)pair.getFirst()).getCodeName() + ((Boolean)pair.getSecond() != false ? "" : "s")).orElse("");
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + Changer.modeSyntax(this.mode) + typeSyntax + (this.originVersion.equals(this.parent.originVersion) ? "" : Mundo.TRI_CHAT_COLOR + " Since " + this.originVersion) + Mundo.ALT_CHAT_COLOR + " " + this.description);
        }
    }

    public static class Expression
    extends DocumentationElement {
        public final ClassInfo type;
        public final Changer[] changers;

        public Expression(String name, String category, String[] syntaxes, String[] description, String originVersion, ClassInfo type, String[] requiredPlugins, Collection<DocumentationBuilder.Changer> changerBuilders) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
            this.type = type;
            this.changers = (Changer[])changerBuilders.stream().map(builder -> builder.build(this)).toArray(Changer[]::new);
        }

        @Override
        public ElementType getType() {
            return ElementType.EXPRESSION;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Expression", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Since", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Type", this.type.getDocName()));
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            if (this.description.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Description");
                for (String descLine : this.description) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + descLine);
                }
            }
            if (this.changers.length > 0) {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Changers");
                for (Changer changer : this.changers) {
                    changer.display(sender);
                }
            }
        }
    }

    public static class Condition
    extends DocumentationElement {
        public final Changer[] changers;

        public Condition(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, Collection<DocumentationBuilder.Changer> changerBuilders) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
            this.changers = (Changer[])changerBuilders.stream().map(builder -> builder.build(this)).toArray(Changer[]::new);
        }

        @Override
        public ElementType getType() {
            return ElementType.CONDITION;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Condition", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Since", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            if (this.description.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Description");
                for (String descLine : this.description) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + descLine);
                }
            }
            if (this.changers.length > 0) {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Changers");
                for (Changer changer : this.changers) {
                    changer.display(sender);
                }
            }
        }
    }

    public static class Effect
    extends DocumentationElement {
        @Override
        public ElementType getType() {
            return ElementType.EFFECT;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Effect", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Since", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            if (this.description.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Description");
                for (String descLine : this.description) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + descLine);
                }
            }
        }

        public Effect(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
        }
    }

    public static enum ElementType {
        EFFECT("Effect"),
        CONDITION("Condition"),
        EXPRESSION("Expression"),
        EVENT("Event"),
        TYPE("Type"),
        SCOPE("Scope");

        public final String toString;

        private ElementType(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

