/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldManagement;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.registrations.Converters;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.Registration;
import com.pie.tlatoani.WorldCreator.WorldCreatorData;
import com.pie.tlatoani.WorldManagement.EffCreateWorld;
import com.pie.tlatoani.WorldManagement.EffCreateWorldUsingCreator;
import com.pie.tlatoani.WorldManagement.EffDeleteWorld;
import com.pie.tlatoani.WorldManagement.EffDuplicateWorld;
import com.pie.tlatoani.WorldManagement.EffUnloadWorld;
import com.pie.tlatoani.WorldManagement.ExprCurrentWorlds;
import com.pie.tlatoani.WorldManagement.WorldLoader.EffLoadWorldAutomatically;
import com.pie.tlatoani.WorldManagement.WorldLoader.ExprAllAutomaticCreators;
import com.pie.tlatoani.WorldManagement.WorldLoader.ExprAutomaticCreator;
import org.bukkit.World;
import org.bukkit.WorldCreator;

public class WorldManagementMundo {
    public static void load() {
        Converters.registerConverter(World.class, WorldCreator.class, (Converter)new Converter<World, WorldCreator>(){

            public WorldCreator convert(World world) {
                WorldCreator worldCreator = new WorldCreator(world.getName());
                worldCreator.copy(world);
                worldCreator.type(world.getWorldType());
                worldCreator.generateStructures(world.canGenerateStructures());
                worldCreator.generatorSettings("");
                return worldCreator;
            }
        });
        Registration.registerEffect(EffCreateWorld.class, "create [new] world named %string%[( with|,)] [(dim[ension]|env[ironment]) %-dimension%][,] [seed %-string%][,] [type %-worldtype%][,] [gen[erator] %-string%][,] [gen[erator] settings %-string%][,] [struct[ures] %-boolean%]").document("Create World", "1.6.4", new String[]{"Creates a world with the specified name, optionally with a few settings. See the environment type and worldtype type for valid environments and worldtypes respectively. Generator settings can either be custom superflat codes or customized world codes (for customized world codes the worldtype needs to be 'customized')."});
        Registration.registerEffect(EffCreateWorldUsingCreator.class, "create [new] world [named %-string%] using %creator%").document("Create World Using Creator", "1.8", new String[]{"Creates a world using the specified creator, optionally specifying the world's name (this is required if the creator doesn't specify a name).See the creator expressions for more information on how to specify the world's name and other settings. If a world with the name (specified or from the creator) already exists, this will just load that world instead of creating a new one."});
        Registration.registerEffect(EffUnloadWorld.class, "unload %world% [save %-boolean%]").document("Unload World", "Before 1.4", new String[]{"Unloads the specified world. You can specify whether or not to save before unloading (this defaults to true)."});
        Registration.registerEffect(EffDeleteWorld.class, "delete %world%").document("Delete World", "Before 1.4", new String[]{"Deletes the specified world. The specified world must be loaded in order to be deleted."});
        Registration.registerEffect(EffDuplicateWorld.class, "duplicate %world% (with|using) name %string%").document("Duplicate World", "Before 1.4", new String[]{"Creates a copy of the specified world using the specified string as a name. The specified world must be loaded in order for this to work."});
        Registration.registerExpression(ExprCurrentWorlds.class, World.class, ExpressionType.SIMPLE, "[all] current worlds").document("All Current Worlds", "1.8", new String[]{"An expression for all worlds that are currently loaded. This differs from Skript's 'all worlds' expression in that it still parses as being a list even if there is only one world at the time of parsing."});
        WorldManagementMundo.loadWorldLoader();
    }

    private static void loadWorldLoader() {
        Registration.registerEffect(EffLoadWorldAutomatically.class, "[(1\u00a6don't|1\u00a6do not)] load %world% automatically").document("Load World Automatically", "1.8", new String[]{"Tells MundoSK whether it should load the specified world automatically on server start. This is useful for simple and straightforward world management without the need for a world management plugin. Don't run this effect with the main world, as Bukkit will already load that world automatically, and this effect can't be used to enable/disable that behavior."});
        ((DocumentationBuilder.Changeable)((DocumentationBuilder.Changeable)((DocumentationBuilder.Changeable)((DocumentationBuilder.Changeable)Registration.registerExpression(ExprAllAutomaticCreators.class, WorldCreatorData.class, ExpressionType.SIMPLE, "[all] automatic creators").document("All Automatic Creators", "1.8", new String[]{"An expression for all of the world creators that MundoSK is currently set to automatically run on server start."})).changer(Changer.ChangeMode.ADD, WorldCreatorData.class, "1.8", "Specifies that given creator should be used as an automatic creator.")).changer(Changer.ChangeMode.REMOVE, WorldCreatorData.class, "1.8", "Specifies that the world with the worldname of the given creator should not be loaded automatically.")).changer(Changer.ChangeMode.REMOVE, String.class, "1.8", "Specifies that the world with the given worldname should not be loaded automatically")).changer(Changer.ChangeMode.DELETE, "1.8", "Specifies that no worlds should be loaded automatically.");
        ((DocumentationBuilder.Changeable)((DocumentationBuilder.Changeable)Registration.registerPropertyExpression(ExprAutomaticCreator.class, WorldCreatorData.class, "string", "automatic creator %", "automatic creator for world %", "automatic creator for world named %").document("Automatic Creator", "1.8", new String[]{"An expression for the automatic creator (if there is one) that MundoSK is currently set to run for the world with the specified name."})).changer(Changer.ChangeMode.SET, WorldCreatorData.class, "1.8", "Specifies an automatic creator for the specified world.")).changer(Changer.ChangeMode.DELETE, "1.8", "Specifies that the specified world should not be loaded automatically.");
    }
}

