/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ZExperimental.SyntaxPiece;

import com.google.common.collect.ImmutableList;
import com.pie.tlatoani.Util.MathUtil;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.ExpressionConstraints;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.Literal;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.SyntaxPiece;
import com.pie.tlatoani.ZExperimental.SyntaxPiece.VariableUsage;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class Varying
extends SyntaxPiece {
    public final ImmutableList<SyntaxPiece> options;
    public final Optional<String> variable;
    public final boolean isOptional = this.isOptional();

    public Varying(ImmutableList<SyntaxPiece> options, Optional<String> variable) {
        this.options = options;
        this.variable = variable;
    }

    public boolean isOptional() {
        return ((SyntaxPiece)this.options.get(0)).equals(Literal.EMPTY);
    }

    @Override
    public boolean containsVariables() {
        if (this.variable.isPresent()) {
            return true;
        }
        for (SyntaxPiece syntaxPiece : this.options) {
            if (!syntaxPiece.containsVariables()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addVariableNames(Set<String> set) {
        this.variable.ifPresent(set::add);
        for (SyntaxPiece option : this.options) {
            option.addVariableNames(set);
        }
    }

    @Override
    public VariableUsage getVariableUsage(String variable) {
        VariableUsage highestUsage = VariableUsage.NONE;
        for (SyntaxPiece option : this.options) {
            switch (option.getVariableUsage(variable)) {
                case NONE: {
                    break;
                }
                case SPECIFIC: {
                    if (highestUsage == VariableUsage.CONSISTENT) {
                        return VariableUsage.CONFLICTING;
                    }
                    highestUsage = VariableUsage.SPECIFIC;
                    break;
                }
                case CONSISTENT: {
                    if (highestUsage == VariableUsage.NONE) {
                        highestUsage = VariableUsage.CONSISTENT;
                        break;
                    }
                    return VariableUsage.CONFLICTING;
                }
                case CONFLICTING: {
                    return VariableUsage.CONFLICTING;
                }
            }
        }
        return highestUsage;
    }

    @Override
    public int markLength() {
        int result = 0;
        for (SyntaxPiece syntaxPiece : this.options) {
            result = Math.max(result, syntaxPiece.markLength());
        }
        if (this.containsVariables()) {
            result += MathUtil.digitsInBase(this.options.size() - 1, 2);
        }
        return result;
    }

    @Override
    public int expressionAmount() {
        int result = 0;
        for (SyntaxPiece syntaxPiece : this.options) {
            result += syntaxPiece.expressionAmount();
        }
        return result;
    }

    @Override
    public void setConstraints(ExpressionConstraints.Collective constraints) {
        for (SyntaxPiece option : this.options) {
            option.setConstraints(constraints);
        }
    }

    @Override
    public String readableSyntax() {
        StringJoiner joiner = new StringJoiner("|", this.isOptional ? "[" : "(", this.isOptional ? "]" : ")");
        for (SyntaxPiece syntaxPiece : this.options) {
            if (syntaxPiece.equals(Literal.EMPTY)) continue;
            joiner.add(syntaxPiece.readableSyntax());
        }
        return joiner.toString();
    }

    @Override
    public String actualSyntax(int prevMarkLength) {
        if (this.isOptional && this.options.size() == 2) {
            return "[" + ((SyntaxPiece)this.options.get(1)).actualSyntax(prevMarkLength) + "]";
        }
        StringJoiner joiner = new StringJoiner("|", this.isOptional ? "[(" : "(", this.isOptional ? ")]" : ")");
        int markLength = this.markLength();
        if (this.containsVariables()) {
            int i;
            String markSuffix = String.join((CharSequence)"", Collections.nCopies(prevMarkLength, "0"));
            int n = i = this.isOptional() ? 1 : 0;
            while (i < this.options.size()) {
                joiner.add(i + markSuffix + "\u00a6" + ((SyntaxPiece)this.options.get(i)).actualSyntax(prevMarkLength + markLength));
                ++i;
            }
        } else {
            for (SyntaxPiece syntaxPiece : this.options) {
                if (syntaxPiece.equals(Literal.EMPTY)) continue;
                joiner.add(syntaxPiece.actualSyntax(prevMarkLength));
            }
        }
        return joiner.toString();
    }

    @Override
    public String originalSyntax() {
        StringJoiner joiner = new StringJoiner("|", (this.isOptional ? "[" : "(") + this.variable.map(name -> name + "=").orElse(""), this.isOptional ? "]" : ")");
        for (SyntaxPiece syntaxPiece : this.options) {
            if (syntaxPiece.equals(Literal.EMPTY)) continue;
            joiner.add(syntaxPiece.originalSyntax());
        }
        return joiner.toString();
    }

    @Override
    public void setInformation(SyntaxPiece.MarkSpecificInformation information, int mark, int prevExprAmount) {
        int markLength = this.markLength();
        int optionIndex = mark % (2 ^ markLength);
        int nextMark = mark >> markLength;
        this.variable.ifPresent(var -> information.markVarValues.put((String)var, optionIndex));
        for (int i = 0; i < optionIndex; ++i) {
            prevExprAmount += ((SyntaxPiece)this.options.get(i)).expressionAmount();
        }
        ((SyntaxPiece)this.options.get(optionIndex)).setInformation(information, nextMark, prevExprAmount);
    }

    @Override
    public String toString(int mark) {
        int markLength = this.markLength();
        if (!this.containsVariables()) {
            return ((SyntaxPiece)this.options.get(0)).toString(0);
        }
        int optionIndex = mark % (2 ^ markLength);
        int nextMark = mark >> markLength;
        return ((SyntaxPiece)this.options.get(optionIndex)).toString(nextMark);
    }

    @Override
    public String toString() {
        return "Varying(" + this.options.stream().map(SyntaxPiece::toString).collect(Collectors.joining(", ")) + ")";
    }
}

