/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldBorder;

import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.util.Timespan;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Registration.Registration;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.Reflection;
import com.pie.tlatoani.WorldBorder.BorderEvent.BorderStabilizeEvent;
import com.pie.tlatoani.WorldBorder.BorderEvent.CondBorderMoving;
import com.pie.tlatoani.WorldBorder.BorderEvent.EvtBorderStabilize;
import com.pie.tlatoani.WorldBorder.BorderEvent.ExprBorderMovingValue;
import com.pie.tlatoani.WorldBorder.BorderEvent.ExprTimeRemainingUntilBorderStabilize;
import com.pie.tlatoani.WorldBorder.BorderEvent.WorldBorderImpl;
import com.pie.tlatoani.WorldBorder.BorderEvent.WorldBorderImplExt;
import com.pie.tlatoani.WorldBorder.CondBeyondBorder;
import com.pie.tlatoani.WorldBorder.EffChangeBorderDiameter;
import com.pie.tlatoani.WorldBorder.EffResetBorder;
import com.pie.tlatoani.WorldBorder.ExprCenterOfBorder;
import com.pie.tlatoani.WorldBorder.ExprPropertyOfBorder;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;

public class WorldBorderMundo {
    public static final String DIAMETER_SYNTAX = "(0\u00a6diameter|8\u00a6size)";
    private static Function<World, WorldBorder> BORDER_REPLACER = null;
    private static Reflection.FieldAccessor<WorldBorder> CRAFT_WORLD_WORLD_BORDER = null;

    public static void load() {
        Registration.registerEffect(EffResetBorder.class, "reset %world%").document("Reset World Border", "Before 1.2", new String[]{"Resets the border properties of the specified world to their default values. These values can be found at https://minecraft.gamepedia.com/World_border#Commands"});
        Registration.registerEffect(EffChangeBorderDiameter.class, "set (0\u00a6diameter|8\u00a6size) of %world% to %number% over %timespan%", "set %world%'s (0\u00a6diameter|8\u00a6size) to %number% over %timespan%", "set (0\u00a6diameter|8\u00a6size) of %world% over %timespan% to %number%", "set %world%'s (0\u00a6diameter|8\u00a6size) over %timespan% to %number%", "add %number% to (0\u00a6diameter|8\u00a6size) of %world% over %timespan%", "add %number% to %world%'s (0\u00a6diameter|8\u00a6size) over %timespan%", "(remove|subtract) %number% from (0\u00a6diameter|8\u00a6size) of %world% over %timespan%", "(remove|subtract) %number% from %world%'s (0\u00a6diameter|8\u00a6size) over %timespan%").document("Change Border Diameter", "1.8", new String[]{"Changes the diameter, or size, of the specified world's border over the specified timespan."});
        Registration.registerExpression(ExprPropertyOfBorder.class, Number.class, ExpressionType.PROPERTY, "(0\u00a6(0\u00a6diameter|8\u00a6size)|1\u00a6damage amount|2\u00a6damage buffer|3\u00a6warning distance|4\u00a6warning time) of %world%", "%world%'s (0\u00a6(0\u00a6diameter|8\u00a6size)|1\u00a6damage amount|2\u00a6damage buffer|3\u00a6warning distance|4\u00a6warning time)").document("Property of Border", "1.8", "An expression for a certain property of the specified world's border:", "diameter: The diameter/size/side length", "damage amount: The amount of damage a player will take per second if they are outside both the border and the damage buffer", "damage buffer: The distance (in blocks) outside of the border a player can be before taking damage", "warning distance: The distance a player has to be within the border to see the red warning effect", "warning time: The amount of time the border should be within of reaching a player to show that player the red warning effect.");
        Registration.registerPropertyExpression(ExprCenterOfBorder.class, Location.class, "world", "center").document("Center of Border", "Before 1.2", "The center of the specified world's border. This isn't necessarily the same as the spawn.");
        Registration.registerExpression(CondBeyondBorder.class, Boolean.class, ExpressionType.PROPERTY, "%locations% (is|are) (0\u00a6within|1\u00a6beyond) border").document("Is Beyond Border", "1.4.9", "Checks whether a location/entity is beyond or within the border in its world.");
        WorldBorderMundo.loadBorderEvent();
    }

    private static void loadBorderEvent() {
        Bukkit.getWorlds().forEach(WorldBorderMundo::replaceBorderForWorld);
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onWorldLoad(WorldLoadEvent event) {
                WorldBorderMundo.replaceBorderForWorld(event.getWorld());
            }
        }, (Plugin)Mundo.INSTANCE);
        Registration.registerEvent("Border Stabilize", EvtBorderStabilize.class, BorderStabilizeEvent.class, "border stabilize [in %-worlds%]").document("Border Stabilize", "1.4.6", new String[]{"Called when a border (optionally only of the specified world(s)) stops moving."});
        Registration.registerExpression(ExprBorderMovingValue.class, Number.class, ExpressionType.PROPERTY, "(0\u00a6original (0\u00a6diameter|8\u00a6size)|1\u00a6(eventual|final) (0\u00a6diameter|8\u00a6size)|2\u00a6remaining distance until [the] border stabilize[s]) of %world%", "%world%'s (0\u00a6original (0\u00a6diameter|8\u00a6size)|1\u00a6(eventual|final) (0\u00a6diameter|8\u00a6size)|2\u00a6remaining distance until [the] border stabilize[s])").document("Moving Border Diameter", "1.8", "An expression for a certain property of the moving border of the specified world:original diameter: The diameter of the border when it was last stablefinal diameter: The diameter that the border will be when it stabilizesremaining distance: The distance the border still has to go before it stabilizes");
        Registration.registerExpression(CondBorderMoving.class, Boolean.class, ExpressionType.PROPERTY, "border of %world% is (0\u00a6moving|1\u00a6stable)", "%world%'s border is (0\u00a6moving|1\u00a6stable)").document("Border is Moving", "1.8", "Checks whether the border of the specified world is moving or stable (not moving).");
        Registration.registerExpression(ExprTimeRemainingUntilBorderStabilize.class, Timespan.class, ExpressionType.PROPERTY, "(time remaining|remaining time) until [the] border stabilize[s] (of|in) %world%", "%world%'s (time remaining|remaining time) until [the] border stabilize[s]").document("Time Remaining Until Border Stabilize", "1.4.6", "An expression for the timespan remaining until the border of the specified world stops moving.");
    }

    private static WorldBorder getBorderReplacement(World world) {
        if (BORDER_REPLACER == null) {
            BORDER_REPLACER = Reflection.methodExists(WorldBorder.class, "isInside", Location.class) ? WorldBorderImplExt::new : WorldBorderImpl::new;
        }
        return BORDER_REPLACER.apply(world);
    }

    private static void setWorldBorderField(World world, WorldBorder value) {
        if (CRAFT_WORLD_WORLD_BORDER == null) {
            CRAFT_WORLD_WORLD_BORDER = Reflection.getField(Reflection.getCraftBukkitClass("CraftWorld"), "worldBorder", WorldBorder.class);
        }
        CRAFT_WORLD_WORLD_BORDER.set(world, value);
    }

    public static void replaceBorderForWorld(World world) {
        if (world.getWorldBorder() instanceof WorldBorderImpl) {
            return;
        }
        WorldBorderMundo.setWorldBorderField(world, WorldBorderMundo.getBorderReplacement(world));
        Logging.debug(WorldBorderMundo.class, "Replaced the border for world: " + world);
    }
}

