/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Pair;
import com.pie.tlatoani.Registration.Documentation;
import com.pie.tlatoani.Registration.DocumentationElement;
import com.pie.tlatoani.Util.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.bukkit.event.Cancellable;

public interface DocumentationBuilder<D extends DocumentationElement, B extends DocumentationBuilder<D, B>> {
    public D build();

    public B document(String var1, String var2, String ... var3);

    public B requiredPlugins(String ... var1);

    public static class Scope
    extends Abstract<DocumentationElement.Scope, Scope> {
        public Scope(String category, String[] syntaxes) {
            super(category, syntaxes);
        }

        @Override
        public DocumentationElement.Scope build() {
            return new DocumentationElement.Scope(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins);
        }
    }

    public static class EventValue {
        private Class type;
        private String description = null;
        private String originVersion = null;

        public EventValue(Class type, String originVersion, String description) {
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public DocumentationElement.EventValue build(DocumentationElement.Event parent) {
            return new DocumentationElement.EventValue(parent, Classes.getExactClassInfo((Class)this.type), this.description, this.originVersion);
        }
    }

    public static class Event
    extends Abstract<DocumentationElement.Event, Event> {
        public final Class<? extends org.bukkit.event.Event> event;
        private Collection<EventValue> eventValueBuilders = new LinkedList<EventValue>();

        public Event(String category, String[] syntaxes, Class<? extends org.bukkit.event.Event> event) {
            super(category, syntaxes);
            this.event = event;
        }

        @Override
        public DocumentationElement.Event build() {
            return new DocumentationElement.Event(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins, Cancellable.class.isAssignableFrom(this.event), this.eventValueBuilders);
        }

        public Event eventValue(Class type, String originVersion, String description) {
            this.eventValueBuilders.add(new EventValue(type, originVersion, description));
            return this;
        }
    }

    public static class Changer {
        private Changer.ChangeMode mode;
        private Class type;
        private String description = null;
        private String originVersion = null;

        public Changer(Changer.ChangeMode mode, Class type, String originVersion, String description) {
            this.mode = mode;
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public DocumentationElement.Changer build(DocumentationElement.Expression parent) {
            boolean single;
            ClassInfo classInfo;
            if (this.type == null) {
                classInfo = null;
                single = false;
            } else if (this.type.getComponentType() != null) {
                classInfo = Classes.getExactClassInfo(this.type.getComponentType());
                single = false;
            } else {
                classInfo = Classes.getExactClassInfo((Class)this.type);
                single = true;
            }
            Optional<Pair<ClassInfo, Boolean>> typeDoc = classInfo == null ? Optional.empty() : Optional.of(new Pair((Object)classInfo, (Object)single));
            return new DocumentationElement.Changer(parent, this.mode, typeDoc, this.description, this.originVersion);
        }
    }

    public static class Expression
    extends Abstract<DocumentationElement.Expression, Expression> {
        private ClassInfo returnType;
        private Class<? extends ch.njol.skript.lang.Expression> exprClass;
        private List<Changer> changerBuilders = new ArrayList<Changer>();

        public Expression(String category, String[] syntaxes, Class returnType, Class<? extends ch.njol.skript.lang.Expression> exprClass) {
            super(category, syntaxes);
            this.returnType = Classes.getExactClassInfo((Class)returnType);
            this.exprClass = exprClass;
        }

        private void addChangers(Class<? extends ch.njol.skript.lang.Expression> exprClass) {
            try {
                ch.njol.skript.lang.Expression expr = exprClass.newInstance();
                for (Changer.ChangeMode mode : Changer.ChangeMode.values()) {
                    Class[] changeTypes = expr.acceptChange(mode);
                    if (changeTypes == null) continue;
                    if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                        if (this.containsChanger(mode, null)) continue;
                        this.changerBuilders.add(new Changer(mode, null, this.originVersion, ""));
                        continue;
                    }
                    for (Class changeType : changeTypes) {
                        if (changeType == null || this.containsChanger(mode, changeType)) continue;
                        this.changerBuilders.add(new Changer(mode, changeType, this.originVersion, ""));
                    }
                }
            }
            catch (Exception e) {
                Logging.debug((Object)this, e);
            }
        }

        private boolean containsChanger(Changer.ChangeMode mode, Class type) {
            for (Changer changer : this.changerBuilders) {
                if (changer.mode != mode || changer.type != type) continue;
                return true;
            }
            return false;
        }

        @Override
        public DocumentationElement.Expression build() {
            if (this.exprClass != null) {
                this.addChangers(this.exprClass);
            }
            return new DocumentationElement.Expression(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.returnType, this.requiredPlugins, this.changerBuilders);
        }

        public Expression changer(Changer.ChangeMode mode, Class type, String originVersion, String description) {
            this.changerBuilders.add(new Changer(mode, type, originVersion, description));
            return this;
        }
    }

    public static class Condition
    extends Abstract<DocumentationElement.Condition, Condition> {
        public Condition(String category, String[] syntaxes) {
            super(category, syntaxes);
        }

        @Override
        public DocumentationElement.Condition build() {
            return new DocumentationElement.Condition(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins);
        }
    }

    public static class Effect
    extends Abstract<DocumentationElement.Effect, Effect> {
        public Effect(String category, String[] syntaxes) {
            super(category, syntaxes);
        }

        @Override
        public DocumentationElement.Effect build() {
            return new DocumentationElement.Effect(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins);
        }
    }

    public static abstract class Abstract<D extends DocumentationElement, B extends Abstract<D, B>>
    implements DocumentationBuilder<D, B> {
        protected String name = null;
        protected String category = null;
        protected String[] syntaxes = null;
        protected String[] description = null;
        protected String originVersion = null;
        protected String[] requiredPlugins = null;

        Abstract(String category, String[] syntaxes) {
            this.category = category;
            this.syntaxes = syntaxes;
        }

        @Override
        public B document(String name, String originVersion, String ... description) {
            Documentation.addBuilder(this);
            this.name = name;
            this.description = description;
            this.originVersion = originVersion;
            return (B)this;
        }

        @Override
        public B requiredPlugins(String ... plugins) {
            this.requiredPlugins = plugins;
            return (B)this;
        }
    }
}

