/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldManagement;

import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.registrations.Converters;
import com.pie.tlatoani.Util.Registration;
import com.pie.tlatoani.WorldCreator.WorldCreatorData;
import com.pie.tlatoani.WorldManagement.EffCreateWorld;
import com.pie.tlatoani.WorldManagement.EffCreateWorldUsingCreator;
import com.pie.tlatoani.WorldManagement.EffDeleteWorld;
import com.pie.tlatoani.WorldManagement.EffDuplicateWorld;
import com.pie.tlatoani.WorldManagement.EffUnloadWorld;
import com.pie.tlatoani.WorldManagement.ExprCurrentWorlds;
import com.pie.tlatoani.WorldManagement.WorldLoader.EffLoadWorldAutomatically;
import com.pie.tlatoani.WorldManagement.WorldLoader.ExprAllAutomaticCreators;
import com.pie.tlatoani.WorldManagement.WorldLoader.ExprAutomaticCreator;
import org.bukkit.World;
import org.bukkit.WorldCreator;

public class WorldManagementMundo {
    public static void load() {
        Converters.registerConverter(World.class, WorldCreator.class, (Converter)new Converter<World, WorldCreator>(){

            public WorldCreator convert(World world) {
                WorldCreator worldCreator = new WorldCreator(world.getName());
                worldCreator.copy(world);
                worldCreator.type(world.getWorldType());
                worldCreator.generateStructures(world.canGenerateStructures());
                worldCreator.generatorSettings("");
                return worldCreator;
            }
        });
        Registration.registerEffect(EffCreateWorld.class, "create [new] world named %string%[( with|,)] [(dim[ension]|env[ironment]) %-dimension%][,] [seed %-string%][,] [type %-worldtype%][,] [gen[erator] %-string%][,] [gen[erator] settings %-string%][,] [struct[ures] %-boolean%]");
        Registration.registerEffect(EffCreateWorldUsingCreator.class, "create [new] world [named %-string%] using %creator%");
        Registration.registerEffect(EffUnloadWorld.class, "unload %world% [save %-boolean%]");
        Registration.registerEffect(EffDeleteWorld.class, "delete %world%");
        Registration.registerEffect(EffDuplicateWorld.class, "duplicate %world% (with|using) name %string%");
        Registration.registerExpression(ExprCurrentWorlds.class, World.class, ExpressionType.SIMPLE, "[all] current worlds");
        WorldManagementMundo.loadWorldLoader();
    }

    private static void loadWorldLoader() {
        Registration.registerEffect(EffLoadWorldAutomatically.class, "[(1\u00a6don't|1\u00a6do not)] load %world% automatically");
        Registration.registerExpression(ExprAllAutomaticCreators.class, WorldCreatorData.class, ExpressionType.SIMPLE, "[all] automatic creators");
        Registration.registerPropertyExpression(ExprAutomaticCreator.class, WorldCreatorData.class, "string", "automatic creator %", "automatic creator for world %", "automatic creator for world named %");
    }
}

