/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldBorder;

import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.util.Timespan;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.Reflection;
import com.pie.tlatoani.Util.Registration;
import com.pie.tlatoani.WorldBorder.BorderEvent.BorderStabilizeEvent;
import com.pie.tlatoani.WorldBorder.BorderEvent.CondBorderMoving;
import com.pie.tlatoani.WorldBorder.BorderEvent.EvtBorderStabilize;
import com.pie.tlatoani.WorldBorder.BorderEvent.ExprBorderMovingValue;
import com.pie.tlatoani.WorldBorder.BorderEvent.ExprTimeRemainingUntilBorderStabilize;
import com.pie.tlatoani.WorldBorder.BorderEvent.WorldBorderImpl;
import com.pie.tlatoani.WorldBorder.BorderEvent.WorldBorderImplExt;
import com.pie.tlatoani.WorldBorder.CondBeyondBorder;
import com.pie.tlatoani.WorldBorder.EffChangeBorderSize;
import com.pie.tlatoani.WorldBorder.EffResetBorder;
import com.pie.tlatoani.WorldBorder.ExprCenterOfBorder;
import com.pie.tlatoani.WorldBorder.ExprPropertyOfBorder;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;

public class WorldBorderMundo {
    public static final String DIAMETER_SYNTAX = "(diameter|size)";
    private static Function<World, WorldBorder> BORDER_REPLACER = null;
    private static Reflection.FieldAccessor<WorldBorder> CRAFT_WORLD_WORLD_BORDER = null;

    public static void load() {
        Registration.registerEffect(EffResetBorder.class, "reset %world%");
        Registration.registerEffect(EffChangeBorderSize.class, "set (diameter|size) of %world% to %number% over %timespan%", "set %world%'s (diameter|size) to %number% over %timespan%", "set (diameter|size) of %world% over %timespan% to %number%", "set %world%'s (diameter|size) over %timespan% to %number%", "add %number% to (diameter|size) of %world% over %timespan%", "add %number% to %world%'s (diameter|size) over %timespan%", "(remove|subtract) %number% from (diameter|size) of %world% over %timespan%", "(remove|subtract) %number% from %world%'s (diameter|size) over %timespan%");
        Registration.registerExpression(ExprPropertyOfBorder.class, Number.class, ExpressionType.PROPERTY, "(0\u00a6(diameter|size)|1\u00a6damage amount|2\u00a6damage buffer|3\u00a6warning distance|4\u00a6warning time) of %world%", "%world%'s (0\u00a6(diameter|size)|1\u00a6damage amount|2\u00a6damage buffer|3\u00a6warning distance|4\u00a6warning time)");
        Registration.registerPropertyExpression(ExprCenterOfBorder.class, Location.class, "world", "center");
        Registration.registerExpression(CondBeyondBorder.class, Boolean.class, ExpressionType.PROPERTY, "%locations% (is|are) (0\u00a6within|1\u00a6beyond) border");
        WorldBorderMundo.loadBorderEvent();
    }

    private static void loadBorderEvent() {
        Bukkit.getWorlds().forEach(WorldBorderMundo::replaceBorderForWorld);
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onWorldLoad(WorldLoadEvent event) {
                WorldBorderMundo.replaceBorderForWorld(event.getWorld());
            }
        }, (Plugin)Mundo.INSTANCE);
        Registration.registerEvent("Border Stabilize", EvtBorderStabilize.class, BorderStabilizeEvent.class, "border stabilize [in %-worlds%]");
        Registration.registerExpression(ExprBorderMovingValue.class, Number.class, ExpressionType.PROPERTY, "(0\u00a6original (diameter|size)|1\u00a6(eventual|final) (diameter|size)|2\u00a6remaining distance until [the] border stabilize[s]) of %world%", "%world%'s (0\u00a6original (diameter|size)|1\u00a6(eventual|final) (diameter|size)|2\u00a6remaining distance until [the] border stabilize[s])");
        Registration.registerExpression(CondBorderMoving.class, Boolean.class, ExpressionType.PROPERTY, "border of %world% is (0\u00a6moving|1\u00a6stable)", "%world%'s border is (0\u00a6moving|1\u00a6stable)");
        Registration.registerExpression(ExprTimeRemainingUntilBorderStabilize.class, Timespan.class, ExpressionType.PROPERTY, "(time remaining|remaining time) until [the] border stabilize[s] (of|in) %world%", "%world%'s (time remaining|remaining time) until [the] border stabilize[s]");
    }

    private static WorldBorder getBorderReplacement(World world) {
        if (BORDER_REPLACER == null) {
            BORDER_REPLACER = Reflection.methodExists(WorldBorder.class, "isInside", Location.class) ? WorldBorderImplExt::new : WorldBorderImpl::new;
        }
        return BORDER_REPLACER.apply(world);
    }

    private static void setWorldBorderField(World world, WorldBorder value) {
        if (CRAFT_WORLD_WORLD_BORDER == null) {
            CRAFT_WORLD_WORLD_BORDER = Reflection.getField(Reflection.getCraftBukkitClass("CraftWorld"), "worldBorder", WorldBorder.class);
        }
        CRAFT_WORLD_WORLD_BORDER.set(world, value);
    }

    public static void replaceBorderForWorld(World world) {
        if (world.getWorldBorder() instanceof WorldBorderImpl) {
            return;
        }
        WorldBorderMundo.setWorldBorderField(world, WorldBorderMundo.getBorderReplacement(world));
        Logging.debug(WorldBorderMundo.class, "Replaced the border for world: " + world);
    }
}

