/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ListUtil;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import com.pie.tlatoani.ListUtil.EffInsertElements;
import com.pie.tlatoani.ListUtil.EffMoveElements;
import com.pie.tlatoani.ListUtil.ExprElement;
import com.pie.tlatoani.ListUtil.ExprElementCount;
import com.pie.tlatoani.ListUtil.ExprElements;
import com.pie.tlatoani.ListUtil.ExprSomeElements;
import com.pie.tlatoani.ListUtil.TransDefault;
import com.pie.tlatoani.ListUtil.Transformer;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.MathUtil;
import com.pie.tlatoani.Util.ModifiableSyntaxElementInfo;
import com.pie.tlatoani.Util.Registration;
import java.util.ArrayList;
import java.util.List;

public final class ListUtil {
    public static final String TRANSFORMER_PATTERN_ID = "%listutil%";
    public static final String POSSESSOR_CLASS_CODE_NAME_ID = "%possessor%";
    private static final List<TransformerUserInfo> TRANSFORMER_USER_INFOS = new ArrayList<TransformerUserInfo>();
    private static final List<TransformerInfo> transformerInfos = new ArrayList<TransformerInfo>();

    public static void load() {
        Registration.registerEffect(EffMoveElements.class, "move %objects% (-1\u00a6front|-1\u00a6forward[s]|1\u00a6back[ward[s]]) %number%");
        ListUtil.registerTransformer(TransDefault.class, "objects", "elem", "element");
        ListUtil.registerTransformerUser(new ModifiableSyntaxElementInfo.Effect<EffInsertElements>(EffInsertElements.class, new String[0]), "(add|insert) %objects% (1\u00a6before|0\u00a6after) (%listutil% %-number%|last %listutil%) (of|in) %possessor%");
        ListUtil.registerTransformerUser(new ModifiableSyntaxElementInfo.Expression<ExprElement, Object>(ExprElement.class, Object.class, ExpressionType.PROPERTY, new String[0]), "(%listutil% %-number%|last %listutil%) (of|in) %possessor%");
        ListUtil.registerTransformerUser(new ModifiableSyntaxElementInfo.Expression<ExprElements, Object>(ExprElements.class, Object.class, ExpressionType.PROPERTY, new String[0]), "%listutil%s (of|in) %possessor%");
        ListUtil.registerTransformerUser(new ModifiableSyntaxElementInfo.Expression<ExprSomeElements, Object>(ExprSomeElements.class, Object.class, ExpressionType.PROPERTY, new String[0]), "%listutil%s %number% to (%-number%|last) (of|in) %possessor%");
        ListUtil.registerTransformerUser(new ModifiableSyntaxElementInfo.Expression<ExprElementCount, Object>(ExprElementCount.class, Object.class, ExpressionType.PROPERTY, new String[0]), "(%listutil% count|amount of %listutil%s) (of|in) %possessor%");
    }

    public static String getApplicablePattern(int index) {
        if (!MathUtil.isInRange(0.0, index, transformerInfos.size() - 1)) {
            throw new IllegalArgumentException("The index " + index + " is out of range");
        }
        TransformerInfo transformerInfo = transformerInfos.get(index);
        return transformerInfo.patterns[0];
    }

    public static Transformer getTransformer(int index, Expression possessor) {
        if (!MathUtil.isInRange(0.0, index, transformerInfos.size() - 1)) {
            throw new IllegalArgumentException("The index " + index + " is out of range");
        }
        TransformerInfo transformerInfo = transformerInfos.get(index);
        try {
            Transformer transformer = transformerInfo.transformerClass.newInstance();
            return transformer.init(possessor) != false ? transformer : null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logging.reportException(ListUtil.class, e);
            return null;
        }
    }

    public static void registerTransformer(Class<? extends Transformer> transformerClass, String possessorClassCodeName, String ... patterns) {
        if (patterns.length == 0) {
            throw new IllegalArgumentException("Every transformer must have at least one pattern!");
        }
        TransformerInfo transformerInfo = new TransformerInfo(transformerClass, patterns, possessorClassCodeName);
        transformerInfos.add(transformerInfo);
        for (TransformerUserInfo userInfo : TRANSFORMER_USER_INFOS) {
            String formattedWrapperPattern = userInfo.formatPrototypePattern(transformerInfo);
            userInfo.syntaxElementInfo.addPattern(formattedWrapperPattern);
        }
    }

    public static void registerTransformerUser(ModifiableSyntaxElementInfo syntaxElementInfo, String prototypePattern) {
        TransformerUserInfo userInfo = new TransformerUserInfo(syntaxElementInfo, prototypePattern);
        TRANSFORMER_USER_INFOS.add(userInfo);
        String[] patterns = new String[transformerInfos.size()];
        for (int i = 0; i < patterns.length; ++i) {
            String formattedWrapperPattern;
            patterns[i] = formattedWrapperPattern = userInfo.formatPrototypePattern(transformerInfos.get(i));
        }
        userInfo.syntaxElementInfo.setPatterns(patterns);
        userInfo.syntaxElementInfo.register();
    }

    public static class TransformerUserInfo {
        public final ModifiableSyntaxElementInfo syntaxElementInfo;
        public final String prototypePattern;

        public TransformerUserInfo(ModifiableSyntaxElementInfo syntaxElementInfo, String prototypePattern) {
            this.syntaxElementInfo = syntaxElementInfo;
            this.prototypePattern = prototypePattern;
        }

        public String formatPrototypePattern(TransformerInfo transformerInfo) {
            return this.prototypePattern.replace(ListUtil.TRANSFORMER_PATTERN_ID, transformerInfo.unifiedPattern).replace(ListUtil.POSSESSOR_CLASS_CODE_NAME_ID, "%" + transformerInfo.possessorClassCodeName + "%");
        }
    }

    public static class TransformerInfo {
        public final Class<? extends Transformer> transformerClass;
        public final String possessorClassCodeName;
        public final String[] patterns;
        public final String unifiedPattern;

        public TransformerInfo(Class<? extends Transformer> transformerClass, String[] patterns, String possessorClassCodeName) {
            this.transformerClass = transformerClass;
            this.patterns = patterns;
            this.possessorClassCodeName = possessorClassCodeName;
            this.unifiedPattern = patterns.length == 1 ? patterns[0] : "(" + String.join((CharSequence)"|", patterns) + ")";
        }
    }
}

