/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldBorder;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pie.tlatoani.Util.Config;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;

public class ExprPropertyOfBorder
extends SimpleExpression<Number> {
    private BorderProperty borderProperty;
    private Expression<World> worldExpression;

    public static Number getProperty(WorldBorder border, BorderProperty borderProperty) {
        switch (borderProperty) {
            case DIAMETER: {
                return border.getSize();
            }
            case DAMAGE_AMOUNT: {
                return border.getDamageAmount();
            }
            case DAMAGE_BUFFER: {
                return border.getDamageBuffer();
            }
            case WARNING_DISTANCE: {
                return border.getWarningDistance();
            }
            case WARNING_TIME: {
                return border.getWarningTime();
            }
        }
        throw new IllegalArgumentException("Illegal BorderProperty: " + (Object)((Object)borderProperty));
    }

    public static void setProperty(WorldBorder border, BorderProperty borderProperty, Number value) {
        switch (borderProperty) {
            case DIAMETER: {
                border.setSize(value.doubleValue());
                return;
            }
            case DAMAGE_AMOUNT: {
                border.setDamageAmount(value.doubleValue());
                return;
            }
            case DAMAGE_BUFFER: {
                border.setDamageBuffer(value.doubleValue());
                return;
            }
            case WARNING_DISTANCE: {
                border.setWarningDistance(value.intValue());
                return;
            }
            case WARNING_TIME: {
                border.setWarningTime(value.intValue());
                return;
            }
        }
        throw new IllegalArgumentException("Illegal BorderProperty: " + (Object)((Object)borderProperty));
    }

    public static void resetProperty(WorldBorder border, BorderProperty borderProperty) {
        switch (borderProperty) {
            case DIAMETER: {
                border.setSize(6.0E7);
                return;
            }
            case DAMAGE_AMOUNT: {
                border.setDamageAmount(0.2);
                return;
            }
            case DAMAGE_BUFFER: {
                border.setDamageBuffer(5.0);
                return;
            }
            case WARNING_DISTANCE: {
                border.setWarningDistance(5);
                return;
            }
            case WARNING_TIME: {
                border.setWarningTime(15);
                return;
            }
        }
        throw new IllegalArgumentException("Illegal BorderProperty: " + (Object)((Object)borderProperty));
    }

    protected Number[] get(Event event) {
        WorldBorder border = ((World)this.worldExpression.getSingle(event)).getWorldBorder();
        return new Number[]{ExprPropertyOfBorder.getProperty(border, this.borderProperty)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return this.borderProperty.syntaxName + " of " + this.worldExpression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.worldExpression = expressions[0];
        if ((parseResult.mark & 8) == 8) {
            if (Config.DISABLE_SIZE_SYNTAX.getCurrentValue().booleanValue()) {
                return false;
            }
            Skript.warning((String)"The 'size' alias for border diameter will be removed in a future version. Please use 'diameter' instead. If you were not trying to use a border fullSyntax here, go to MundoSK's config and set the 'border_disable_size_syntax' option to true. Make sure any uses of 'size' for border diameter are changed to 'diameter' before you do this.");
        }
        this.borderProperty = BorderProperty.values()[parseResult.mark & 7];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode changeMode) {
        WorldBorder border = ((World)this.worldExpression.getSingle(event)).getWorldBorder();
        if (changeMode == Changer.ChangeMode.SET || changeMode == Changer.ChangeMode.ADD || changeMode == Changer.ChangeMode.REMOVE) {
            Number value = (Number)delta[0];
            if (changeMode == Changer.ChangeMode.ADD) {
                Number original = ExprPropertyOfBorder.getProperty(border, this.borderProperty);
                value = original instanceof Integer ? (Number)((Integer)original + value.intValue()) : (Number)((Double)original + value.doubleValue());
            } else if (changeMode == Changer.ChangeMode.REMOVE) {
                Number original = ExprPropertyOfBorder.getProperty(border, this.borderProperty);
                value = original instanceof Integer ? (Number)((Integer)original - value.intValue()) : (Number)((Double)original - value.doubleValue());
            }
            ExprPropertyOfBorder.setProperty(border, this.borderProperty, value);
        } else if (changeMode == Changer.ChangeMode.RESET) {
            ExprPropertyOfBorder.resetProperty(border, this.borderProperty);
        } else {
            throw new IllegalArgumentException("Illegal ChangeMode: " + changeMode);
        }
    }

    public Class[] acceptChange(Changer.ChangeMode changeMode) {
        switch (changeMode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case RESET: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            }
        }
        return null;
    }

    public static enum BorderProperty {
        DIAMETER("diameter"),
        DAMAGE_AMOUNT("damage amount"),
        DAMAGE_BUFFER("damage buffer"),
        WARNING_DISTANCE("warning distance"),
        WARNING_TIME("warning time");

        public final String syntaxName;

        private BorderProperty(String syntaxName) {
            this.syntaxName = syntaxName;
        }
    }
}

