/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.DocumentationElement;
import com.pie.tlatoani.Util.ImmutableGroupedList;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.MundoUtil;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public final class Documentation {
    public static final Comparator<DocumentationElement> DOCUMENTATION_ELEMENT_COMPARATOR = Comparator.comparing(docElem -> docElem.name.toLowerCase());
    public static final int ELEMENTS_PER_PAGE = 12;
    private static List<DocumentationBuilder> builders = new LinkedList<DocumentationBuilder>();
    private static boolean built = false;
    private static List<String> categories = null;
    private static ImmutableGroupedList<DocumentationElement, String> allElements = null;
    private static ImmutableGroupedList<DocumentationElement.Effect, String> effects = null;
    private static ImmutableGroupedList<DocumentationElement.Condition, String> conditions = null;
    private static ImmutableGroupedList<DocumentationElement.Expression, String> expressions = null;
    private static ImmutableGroupedList<DocumentationElement.Event, String> events = null;
    private static ImmutableGroupedList<DocumentationElement.Type, String> types = null;
    private static ImmutableGroupedList<DocumentationElement.Scope, String> scopes = null;

    static void addBuilder(DocumentationBuilder builder) {
        builders.add(builder);
    }

    public static void buildDocumentation() {
        if (built) {
            throw new IllegalStateException("The documentation has already been built");
        }
        ImmutableGroupedList.OrderedBuilder allElementsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder effectsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder expressionsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder conditionsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder eventsBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder typesBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        ImmutableGroupedList.OrderedBuilder scopesBuilder = new ImmutableGroupedList.OrderedBuilder(DOCUMENTATION_ELEMENT_COMPARATOR, Comparator.naturalOrder());
        for (DocumentationBuilder builder : builders) {
            Object docElem = builder.build();
            allElementsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement)docElem);
            if (docElem instanceof DocumentationElement.Effect) {
                effectsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Effect)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Condition) {
                conditionsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Condition)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Expression) {
                expressionsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Expression)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Event) {
                eventsBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Event)docElem);
                continue;
            }
            if (docElem instanceof DocumentationElement.Type) {
                typesBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Type)docElem);
                continue;
            }
            if (!(docElem instanceof DocumentationElement.Scope)) continue;
            scopesBuilder.add(((DocumentationElement)docElem).category, (DocumentationElement.Scope)docElem);
        }
        allElements = allElementsBuilder.build();
        effects = effectsBuilder.build();
        conditions = conditionsBuilder.build();
        expressions = expressionsBuilder.build();
        events = eventsBuilder.build();
        types = typesBuilder.build();
        scopes = scopesBuilder.build();
        categories = allElements.getGroupKeys();
        built = true;
        Logging.debug(Documentation.class, "All DocElems: " + allElements);
    }

    public static void accessDocumentation(CommandSender sender, String[] args) {
        if (Documentation.listDocumentation(sender, args)) {
            return;
        }
        String docElemName = String.join((CharSequence)" ", args).substring(args[0].length() + 1).toLowerCase();
        Logging.debug(Documentation.class, "Searching for a DocElem named '" + docElemName + "'");
        for (List<DocumentationElement> docElems : allElements.getAllGroups()) {
            Logging.debug(Documentation.class, "Searching through " + docElems);
            Optional<DocumentationElement> docElemOptional = MundoUtil.binarySearchCeiling(docElems, docElemName, (name, docElem) -> name.compareToIgnoreCase(docElem.name));
            if (!docElemOptional.filter(docElem -> docElem.name.toLowerCase().startsWith(docElemName)).isPresent()) continue;
            docElemOptional.get().display(sender);
            return;
        }
        sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Invalid command. Do " + Mundo.ALT_CHAT_COLOR + "/mundosk doc help" + Mundo.PRIMARY_CHAT_COLOR + " for help");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean listDocumentation(CommandSender sender, String[] args) {
        int page;
        if (args.length == 1 || args[1].equalsIgnoreCase("help")) {
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "MundoSK Documentation Command Help");
            sender.sendMessage(Mundo.formatCommandDescription("doc[s] [help]", "Prints this list of commands"));
            sender.sendMessage(Mundo.formatCommandDescription("doc[s] cat[[egorie]s]", "Prints a list of the documentation categories"));
            sender.sendMessage(Mundo.formatCommandDescription("doc[s] all [page]", "Lists a page of all fullSyntax elements"));
            sender.sendMessage(Mundo.formatCommandDescription("doc[s] <elem type> [page]", "Lists a page of all fullSyntax elements of a certain type"));
            sender.sendMessage(Mundo.formatCommandDescription("doc[s] <category> [elem type] [page]", "Lists a page of fullSyntax elements in that category, either all of them or of a specific type"));
            sender.sendMessage(Mundo.formatCommandDescription("doc[s] <elem name>", "Lists the documentation for a specific fullSyntax element"));
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Accepted Element Types: " + Mundo.ALT_CHAT_COLOR + "Effect Condition Expression Event Type Scope");
            return true;
        }
        if (args[1].equalsIgnoreCase("cat") || args[1].equalsIgnoreCase("cats") || args[1].equalsIgnoreCase("categories")) {
            if (args.length > 2) {
                return false;
            }
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Documentation Categories");
            for (String category : categories) {
                sender.sendMessage(Mundo.ALT_CHAT_COLOR + category);
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("all")) {
            if (args.length == 2) {
                Documentation.displayElems(sender, allElements, "All Syntax Elements", 1, true, true);
                return true;
            }
            if (args.length != 3) return false;
            Optional<Integer> pageOptional = MundoUtil.parseIntOptional(args[2]);
            if (!pageOptional.isPresent()) return false;
            Documentation.displayElems(sender, allElements, "All Syntax Elements", pageOptional.get(), true, true);
            return true;
        }
        Optional<ImmutableGroupedList<? extends DocumentationElement, String>> docElemGroupedListOptional = Documentation.getDocElemGroupedList(args[1]);
        if (docElemGroupedListOptional.isPresent()) {
            ImmutableGroupedList<? extends DocumentationElement, String> docElemGroupedList = docElemGroupedListOptional.get();
            if (args.length == 2) {
                Documentation.displayElems(sender, docElemGroupedList, "All " + MundoUtil.capitalize(args[1]), 1, true, false);
                return true;
            }
            if (args.length != 3) return false;
            Optional<Integer> pageOptional = MundoUtil.parseIntOptional(args[2]);
            if (!pageOptional.isPresent()) return false;
            Documentation.displayElems(sender, docElemGroupedList, "All " + MundoUtil.capitalize(args[1]), pageOptional.get(), true, false);
            return true;
        }
        Optional<String> categoryOptional = MundoUtil.binarySearchList(categories, args[1].toLowerCase(), (s, s2) -> s.compareTo(s2.toLowerCase()));
        if (!categoryOptional.isPresent()) return false;
        String category = categoryOptional.get();
        if (args.length == 2) {
            Documentation.displayElems(sender, allElements.getGroup(category), category + " Syntax Elements", 1, false, true);
            return true;
        }
        if (args.length == 3) {
            Optional<Integer> pageOptional = MundoUtil.parseIntOptional(args[2]);
            if (pageOptional.isPresent()) {
                Documentation.displayElems(sender, allElements.getGroup(category), category + " Syntax Elements", pageOptional.get(), false, true);
                return true;
            }
        } else if (args.length > 4) {
            return false;
        }
        if (args.length == 4) {
            Optional<Integer> pageOptional = MundoUtil.parseIntOptional(args[3]);
            if (!pageOptional.isPresent()) return false;
            page = pageOptional.get();
            return MundoUtil.mapOptional(Documentation.getDocElemGroupedList(args[2]), docElemMultimap -> {
                Documentation.displayElems(sender, docElemMultimap.getGroup(category), category + " " + MundoUtil.capitalize(args[2]) + "s", page, false, false);
                return true;
            }, () -> false);
        } else {
            page = 1;
        }
        return MundoUtil.mapOptional(Documentation.getDocElemGroupedList(args[2]), docElemMultimap -> {
            Documentation.displayElems(sender, docElemMultimap.getGroup(category), category + " " + MundoUtil.capitalize(args[2]) + "s", page, false, false);
            return true;
        }, () -> false);
    }

    private static Optional<ImmutableGroupedList<? extends DocumentationElement, String>> getDocElemGroupedList(String elemType) {
        if (Character.toLowerCase(elemType.charAt(elemType.length() - 1)) == 's') {
            elemType = elemType.substring(0, elemType.length() - 1);
        }
        switch (elemType.toLowerCase()) {
            case "effect": {
                return Optional.of(effects);
            }
            case "condition": {
                return Optional.of(conditions);
            }
            case "expression": {
                return Optional.of(expressions);
            }
            case "event": {
                return Optional.of(events);
            }
            case "type": {
                return Optional.of(types);
            }
            case "scope": {
                return Optional.of(scopes);
            }
        }
        return Optional.empty();
    }

    private static void displayElems(CommandSender sender, List<? extends DocumentationElement> docElems, String header, int page, boolean displayCategory, boolean displayType) {
        int pages = 1 + (docElems.size() - 1) / 12;
        if (page > pages || page < 1) {
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Invalid page number " + Mundo.ALT_CHAT_COLOR + page + Mundo.PRIMARY_CHAT_COLOR + ", there are " + Mundo.ALT_CHAT_COLOR + pages + Mundo.PRIMARY_CHAT_COLOR + " pages of " + header);
            return;
        }
        sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Page " + page + " of " + pages + " of " + header);
        int max = page * 12;
        int min = max - 12;
        max = Math.min(max, docElems.size());
        for (int i = min; i < max; ++i) {
            DocumentationElement docElem = docElems.get(i);
            sender.sendMessage(Mundo.TRI_CHAT_COLOR + (displayCategory ? docElem.category + " " : "") + (displayType ? (Object)((Object)docElem.getType()) + " " : "") + Mundo.ALT_CHAT_COLOR + docElem.name);
        }
    }
}

