/*
 * Decompiled with CFR 0.152.
 */
package mundosk_libraries.java_websocket;

import java.net.InetSocketAddress;
import mundosk_libraries.java_websocket.WebSocket;
import mundosk_libraries.java_websocket.WebSocketListener;
import mundosk_libraries.java_websocket.drafts.Draft;
import mundosk_libraries.java_websocket.exceptions.InvalidDataException;
import mundosk_libraries.java_websocket.exceptions.InvalidHandshakeException;
import mundosk_libraries.java_websocket.framing.Framedata;
import mundosk_libraries.java_websocket.framing.FramedataImpl1;
import mundosk_libraries.java_websocket.handshake.ClientHandshake;
import mundosk_libraries.java_websocket.handshake.HandshakeImpl1Server;
import mundosk_libraries.java_websocket.handshake.ServerHandshake;
import mundosk_libraries.java_websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket conn, Framedata frame) {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        FramedataImpl1 resp = new FramedataImpl1(f);
        resp.setOptcode(Framedata.Opcode.PONG);
        conn.sendFrame(resp);
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public String getFlashPolicy(WebSocket conn) throws InvalidDataException {
        InetSocketAddress adr = conn.getLocalSocketAddress();
        if (null == adr) {
            throw new InvalidHandshakeException("socket not bound");
        }
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + adr.getPort() + "\" /></cross-domain-policy>\u0000";
    }
}

