/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.EnumClassInfo;
import com.pie.tlatoani.Registration.ExprEnumValues;
import com.pie.tlatoani.Registration.MundoClassInfo;
import com.pie.tlatoani.Util.CustomScope;
import com.pie.tlatoani.Util.EventSpecificExpression;
import com.pie.tlatoani.Util.Logging;
import com.pie.tlatoani.Util.MundoPropertyExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.event.Event;

public final class Registration {
    private static String currentCategory = null;
    private static String[] currentRequiredPlugins = new String[0];

    public static void register(String category, Runnable registerer, String ... requiredPlugins) {
        String prevCategory = currentCategory;
        String[] prevPlugins = currentRequiredPlugins;
        currentCategory = category;
        currentRequiredPlugins = requiredPlugins;
        registerer.run();
        currentCategory = prevCategory;
        currentRequiredPlugins = prevPlugins;
    }

    public static DocumentationBuilder.Effect registerEffect(Class<? extends Effect> effectClass, String ... patterns) {
        Skript.registerEffect(effectClass, (String[])patterns);
        return (DocumentationBuilder.Effect)new DocumentationBuilder.Effect(currentCategory, patterns).requiredPlugins(currentRequiredPlugins);
    }

    public static <T> DocumentationBuilder registerExpression(Class<? extends Expression<T>> expressionClass, Class<T> type, ExpressionType expressionType, String ... patterns) {
        Skript.registerExpression(expressionClass, type, (ExpressionType)expressionType, (String[])patterns);
        if (type == Boolean.class) {
            return new DocumentationBuilder.Condition(currentCategory, patterns).requiredPlugins(currentRequiredPlugins);
        }
        return new DocumentationBuilder.Expression(currentCategory, patterns, type).requiredPlugins(currentRequiredPlugins);
    }

    public static <T> DocumentationBuilder registerPropertyExpression(Class<? extends Expression<T>> expressionClass, Class<T> type, String possessorType, String ... properties) {
        ArrayList<String> patternList = new ArrayList<String>(properties.length);
        ArrayList<String> propertyList = new ArrayList<String>(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (property.contains("%")) {
                patternList.add(property.replace("%", "%" + possessorType + "%"));
                propertyList.add(property);
                continue;
            }
            patternList.add("[the] " + property + " of %" + possessorType + "%");
            patternList.add("%" + possessorType + "%'[s] " + property);
            propertyList.add(property);
            propertyList.add(property);
        }
        String[] patterns = patternList.toArray(new String[0]);
        Skript.registerExpression(expressionClass, type, (ExpressionType)ExpressionType.PROPERTY, (String[])patterns);
        if (MundoPropertyExpression.class.isAssignableFrom(expressionClass)) {
            MundoPropertyExpression.registerPropertyExpressionInfo(expressionClass, type, propertyList);
        }
        if (type == Boolean.class) {
            return new DocumentationBuilder.Condition(currentCategory, patterns).requiredPlugins(currentRequiredPlugins);
        }
        return new DocumentationBuilder.Expression(currentCategory, patterns, type).requiredPlugins(currentRequiredPlugins);
    }

    public static <T, E extends Event> DocumentationBuilder registerEventSpecificExpression(Class<? extends EventSpecificExpression<T, E>> expressionClass, Class<T> type, Class<E> event, String invalidEventError, String ... patterns) {
        Skript.registerExpression(expressionClass, type, (ExpressionType)ExpressionType.SIMPLE, (String[])patterns);
        EventSpecificExpression.registerEventSpecificExpression(expressionClass, type, event, patterns[0], invalidEventError);
        if (type == Boolean.class) {
            return new DocumentationBuilder.Condition(currentCategory, patterns).requiredPlugins(currentRequiredPlugins);
        }
        return new DocumentationBuilder.Expression(currentCategory, patterns, type).requiredPlugins(currentRequiredPlugins);
    }

    public static void registerCondition(Class<? extends Condition> conditionClass, String ... patterns) {
        Skript.registerCondition(conditionClass, (String[])patterns);
    }

    public static DocumentationBuilder.Event registerEvent(String name, Class<? extends SkriptEvent> eventClass, Class<? extends Event> eventType, String ... patterns) {
        Skript.registerEvent((String)name, eventClass, eventType, (String[])patterns);
        return (DocumentationBuilder.Event)new DocumentationBuilder.Event(currentCategory, patterns, eventType).requiredPlugins(currentRequiredPlugins);
    }

    public static DocumentationBuilder.Scope registerScope(Class<? extends CustomScope> conditionClass, String ... patterns) {
        Skript.registerCondition(conditionClass, (String[])patterns);
        return (DocumentationBuilder.Scope)new DocumentationBuilder.Scope(currentCategory, patterns).requiredPlugins(currentRequiredPlugins);
    }

    public static <E extends Event, R> void registerEventValue(final Class<E> tClass, final Class<R> rClass, final Function<E, R> function) {
        EventValues.registerEventValue(tClass, rClass, (Getter)new Getter<R, E>(){

            public R get(E event) {
                try {
                    return function.apply(event);
                }
                catch (ClassCastException e) {
                    Logging.debug(Registration.class, "tClass = " + tClass + ", rClass = " + rClass + ", function = " + function);
                    Logging.debug(Registration.class, e);
                    return null;
                }
            }
        }, (int)0);
    }

    public static <A, B> void registerComparator(Class<A> aClass, Class<B> bClass, final boolean supportsOrdering, final BiFunction<A, B, Comparator.Relation> comparator) {
        Comparators.registerComparator(aClass, bClass, (Comparator)new Comparator<A, B>(){

            public Comparator.Relation compare(A a, B b) {
                return (Comparator.Relation)comparator.apply(a, b);
            }

            public boolean supportsOrdering() {
                return supportsOrdering;
            }
        });
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Function<F, T> function) {
        Converters.registerConverter(from, to, function::apply);
    }

    public static Boolean classInfoSafe(Class c, String name) {
        return Classes.getExactClassInfo((Class)c) == null && Classes.getClassInfoNoError((String)name) == null;
    }

    public static <T> MundoClassInfo<T> registerType(Class<T> type, String name, String ... alternateNames) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(alternateNames));
        names.add(0, name);
        MundoClassInfo<T> result = new MundoClassInfo<T>(type, names.toArray(new String[0]), currentCategory);
        result.parser(new SimpleParser<T>(){

            public T parse(String s, ParseContext parseContext) {
                return null;
            }
        });
        if (Registration.classInfoSafe(type, name).booleanValue()) {
            Classes.registerClass(result);
        }
        return result.requiredPlugins(currentRequiredPlugins);
    }

    public static <E> EnumClassInfo<E> registerEnum(Class<E> enumClass, String name, E ... values) {
        EnumClassInfo<E> enumClassInfo = new EnumClassInfo<E>(enumClass, new String[]{name}, currentCategory, values);
        if (Registration.classInfoSafe(enumClass, name).booleanValue()) {
            Classes.registerClass(enumClassInfo);
            ExprEnumValues.addEnumClassInfo(enumClassInfo);
        }
        return enumClassInfo.requiredPlugins(currentRequiredPlugins);
    }

    public static <E> EnumClassInfo<E> registerEnum(Class<E> enumClass, String name, Map<String, E> valueMap) {
        EnumClassInfo<E> enumClassInfo = new EnumClassInfo<E>(enumClass, new String[]{name}, currentCategory, valueMap);
        if (Registration.classInfoSafe(enumClass, name).booleanValue()) {
            Classes.registerClass(enumClassInfo);
            ExprEnumValues.addEnumClassInfo(enumClassInfo);
        }
        return enumClassInfo.requiredPlugins(currentRequiredPlugins);
    }

    public static abstract class SimpleParser<T>
    extends Parser<T> {
        public String toString(T t, int flags) {
            Logging.debug(Registration.class, "toString() for " + t + "; flags: " + flags);
            return t.toString();
        }

        public String toVariableNameString(T t) {
            return this.toString(t, 0);
        }

        public String getVariableNamePattern() {
            return ".+";
        }
    }
}

