/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import ch.njol.skript.classes.ClassInfo;
import com.pie.tlatoani.Mundo;
import org.bukkit.command.CommandSender;

public abstract class DocumentationElement {
    public final String name;
    public final String category;
    public final String[] syntaxes;
    public final String description;
    public final String originVersion;
    public final String[] requiredPlugins;

    public abstract ElementType getType();

    public abstract void display(CommandSender var1);

    private DocumentationElement(String name, String category, String[] syntaxes, String description, String originVersion, String[] requiredPlugins) {
        this.name = name;
        this.category = category;
        this.syntaxes = syntaxes;
        this.description = description;
        this.originVersion = originVersion;
        this.requiredPlugins = requiredPlugins;
    }

    public static class Type
    extends DocumentationElement {
        public final String[] usages;

        public Type(String name, String category, String[] syntaxes, String[] usages, String description, String originVersion, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
            this.usages = usages;
        }

        @Override
        public ElementType getType() {
            return ElementType.TYPE;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Type", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Introduced", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Usages", this.syntaxes.length == 0 ? "Cannot be written in scripts" : String.join((CharSequence)", ", this.usages)));
            sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description));
        }
    }

    public static class Event
    extends DocumentationElement {
        @Override
        public ElementType getType() {
            return ElementType.EVENT;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Event", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Introduced", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description));
        }

        public Event(String name, String category, String[] syntaxes, String description, String originVersion, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
        }
    }

    public static class Expression
    extends DocumentationElement {
        public final ClassInfo type;

        public Expression(String name, String category, String[] syntaxes, String description, String originVersion, ClassInfo type, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
            this.type = type;
        }

        @Override
        public ElementType getType() {
            return ElementType.EXPRESSION;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Expression", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Introduced", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Type", this.type.getCodeName()));
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description));
        }
    }

    public static class Effect
    extends DocumentationElement {
        @Override
        public ElementType getType() {
            return ElementType.EFFECT;
        }

        @Override
        public void display(CommandSender sender) {
            sender.sendMessage(Mundo.formatMundoSKInfo(this.category + " Effect", this.name));
            sender.sendMessage(Mundo.formatMundoSKInfo("Introduced", "MundoSK " + this.originVersion));
            if (this.requiredPlugins.length > 0) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
            }
            if (this.syntaxes.length == 1) {
                sender.sendMessage(Mundo.formatMundoSKInfo("Syntax", this.syntaxes[0]));
            } else {
                sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Syntaxes");
                for (String syntax : this.syntaxes) {
                    sender.sendMessage(Mundo.ALT_CHAT_COLOR + syntax);
                }
            }
            sender.sendMessage(Mundo.formatMundoSKInfo("Description", this.description));
        }

        public Effect(String name, String category, String[] syntaxes, String description, String originVersion, String[] requiredPlugins) {
            super(name, category, syntaxes, description, originVersion, requiredPlugins);
        }
    }

    public static enum ElementType {
        EFFECT("Effect"),
        EXPRESSION("Expression"),
        EVENT("Event"),
        TYPE("Type");

        public final String toString;

        private ElementType(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

