/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util;

import com.pie.tlatoani.Util.Logging;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class TreeIterator
implements Iterator {
    private Iterator<Map.Entry<String, Object>> baseIterator;
    private TreeIterator subIterator = null;
    private String currentIndex;
    private String currentPrefix;
    private String nextIndex = null;
    private Object next = null;

    public TreeIterator(Map<String, Object> treeMap) {
        this.baseIterator = treeMap.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            Logging.debug((Object)this, "Next was not null");
            Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
            return true;
        }
        if (this.subIterator != null) {
            if (this.subIterator.hasNext()) {
                this.next = this.subIterator.next();
                this.nextIndex = this.currentPrefix + "::" + this.subIterator.currentIndex();
                Logging.debug((Object)this, "The sub iterator had another one!");
                Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
                return true;
            }
            this.subIterator = null;
            this.currentPrefix = null;
            Logging.debug((Object)this, "End of sub iterator");
        }
        if (this.baseIterator.hasNext()) {
            Map.Entry<String, Object> entry = this.baseIterator.next();
            if (entry.getValue() instanceof TreeMap) {
                this.currentPrefix = entry.getKey();
                this.subIterator = new TreeIterator((TreeMap)entry.getValue());
                Logging.debug((Object)this, "Found a new sub iterator!");
                Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
                return this.hasNext();
            }
            this.nextIndex = entry.getKey();
            this.next = entry.getValue();
            Logging.debug((Object)this, "Found a non-iterator value");
            Logging.debug((Object)this, "Next: " + this.next + ", nextIndex: " + this.nextIndex);
            return true;
        }
        return false;
    }

    public Object next() {
        if (this.hasNext()) {
            Object tempcurrent = this.next;
            this.currentIndex = this.nextIndex;
            this.next = null;
            this.nextIndex = null;
            return tempcurrent;
        }
        throw new NoSuchElementException("Called next() on a TreeIterator without a next element");
    }

    public String currentIndex() {
        Logging.debug((Object)this, "Current index: " + this.currentIndex);
        Logging.debug((Object)this, "Next index: " + this.nextIndex);
        return this.currentIndex;
    }
}

