/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.Alias.ExprPacketInfoAlias;
import com.pie.tlatoani.ProtocolLib.EffPacketInfo;
import com.pie.tlatoani.ProtocolLib.EffReceivePacket;
import com.pie.tlatoani.ProtocolLib.EffSendPacket;
import com.pie.tlatoani.ProtocolLib.EvtPacketEvent;
import com.pie.tlatoani.ProtocolLib.ExprEntityOfPacket;
import com.pie.tlatoani.ProtocolLib.ExprEnumOfPacket;
import com.pie.tlatoani.ProtocolLib.ExprJSONObjectOfPacket;
import com.pie.tlatoani.ProtocolLib.ExprNewPacket;
import com.pie.tlatoani.ProtocolLib.ExprObjectOfPacket;
import com.pie.tlatoani.ProtocolLib.ExprPrimitiveArrayOfPacket;
import com.pie.tlatoani.ProtocolLib.ExprPrimitiveOfPacket;
import com.pie.tlatoani.ProtocolLib.ExprTypeOfPacket;
import com.pie.tlatoani.ProtocolLib.MundoPacketEvent;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.Registration;
import com.pie.tlatoani.Util.Logging;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;

public class PacketManager {
    private static Map<String, PacketType> packetTypesByName;
    private static List<ExpressionInfo<?, ?>> packetInfoExpressionInfos;

    public static void load() {
        Logging.info("You've discovered the amazing realm of ProtocolLib packet syntaxes!");
        String pLibVersion = Bukkit.getPluginManager().getPlugin("ProtocolLib").getDescription().getVersion();
        if (!pLibVersion.substring(0, 1).equals("4") || pLibVersion.substring(0, 3).equals("4.0")) {
            Logging.info("Your version of ProtocolLib is " + pLibVersion);
            Logging.info("MundoSK requires that you run at least version 4.1 of ProtocolLib");
            Logging.info("If you are running at least version 4.1 of ProtocolLib, please post a message on MundoSK's thread on forums.skunity.com");
        }
        packetTypesByName = PacketManager.createNameToPacketTypeMap();
        Registration.registerEnum(PacketType.class, "packettype", packetTypesByName);
        Registration.registerType(PacketContainer.class, "packet", new String[0]);
        Registration.registerEffect(EffSendPacket.class, "send packet[s] %packets% to %players%", "send %players% packet[s] %packets%");
        Registration.registerEffect(EffReceivePacket.class, "rec(ei|ie)ve packet[s] %packets% from %players%");
        Registration.registerEffect(EffPacketInfo.class, "packet info %packet%");
        Registration.registerEvent("Packet Event", EvtPacketEvent.class, MundoPacketEvent.class, "packet event %packettypes%");
        Registration.registerEventValue(MundoPacketEvent.class, PacketContainer.class, MundoPacketEvent::getPacket);
        Registration.registerEventValue(MundoPacketEvent.class, PacketType.class, MundoPacketEvent::getPacketType);
        Registration.registerEventValue(MundoPacketEvent.class, Player.class, MundoPacketEvent::getPlayer);
        Registration.registerPropertyExpression(ExprTypeOfPacket.class, PacketType.class, "packet", "packettype");
        PacketManager.registerPacketInfoExpression(ExprNewPacket.class, PacketContainer.class, "new %packettype% packet");
        PacketManager.registerPacketInfoExpression(ExprJSONObjectOfPacket.class, JSONObject.class, "(%-string%" + ExprJSONObjectOfPacket.getConverterNamesPattern(true) + ") pjson %number% of %packet%", "(%-string%" + ExprJSONObjectOfPacket.getConverterNamesPattern(false) + ") array pjson %number% of %packet%");
        PacketManager.registerPacketInfoExpression(ExprObjectOfPacket.class, Object.class, "(0\u00a6%-classinfo/string%" + ExprObjectOfPacket.getConverterNamesPattern(true) + ") pinfo %number% of %packet%", "(0\u00a6%-classinfo/string%" + ExprObjectOfPacket.getConverterNamesPattern(false) + ") array pinfo %number% of %packet%");
        PacketManager.registerPacketInfoExpression(ExprPrimitiveOfPacket.class, Number.class, "(0\u00a6byte|1\u00a6short|2\u00a6int|3\u00a6long|4\u00a6float|5\u00a6double) pnum %number% of %packet%");
        PacketManager.registerPacketInfoExpression(ExprPrimitiveArrayOfPacket.class, Number.class, "(0\u00a6int|1\u00a6byte) array pnum %number% of %packet%");
        PacketManager.registerPacketInfoExpression(ExprEntityOfPacket.class, Entity.class, "%world% pentity %number% of %packet%", "%world% pentity array %number% of %packet%");
        PacketManager.registerPacketInfoExpression(ExprEnumOfPacket.class, String.class, "%string% penum %number% of %packet%");
        ExprPacketInfoAlias.registerNecessaryElements();
    }

    private static <E extends Expression<T>, T> DocumentationBuilder.Expression registerPacketInfoExpression(Class<E> exprClass, Class<T> returnType, String ... patterns) {
        packetInfoExpressionInfos.add(new ExpressionInfo(patterns, returnType, exprClass));
        return Registration.registerExpression(exprClass, returnType, ExpressionType.COMBINED, patterns);
    }

    public static Iterator<ExpressionInfo<?, ?>> packetInfoExpressionInfoIterator() {
        return packetInfoExpressionInfos.iterator();
    }

    public PacketType getPacketTypeFromName(String name) {
        return packetTypesByName.get(name.toLowerCase());
    }

    public static void onPacketEvent(PacketType packetType, Consumer<PacketEvent> handler) {
        PacketManager.onPacketEvent(packetType, ListenerPriority.NORMAL, handler);
    }

    public static void onPacketEvent(PacketType packetType, ListenerPriority priority, final Consumer<PacketEvent> handler) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.INSTANCE, priority, new PacketType[]{packetType}){

            public void onPacketReceiving(PacketEvent event) {
                handler.accept(event);
            }

            public void onPacketSending(PacketEvent event) {
                handler.accept(event);
            }
        });
    }

    public static void onPacketEvent(PacketType[] packetTypes, Consumer<PacketEvent> handler) {
        PacketManager.onPacketEvent(packetTypes, ListenerPriority.NORMAL, handler);
    }

    public static void onPacketEvent(PacketType[] packetTypes, ListenerPriority priority, final Consumer<PacketEvent> handler) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.INSTANCE, priority, packetTypes){

            public void onPacketReceiving(PacketEvent event) {
                handler.accept(event);
            }

            public void onPacketSending(PacketEvent event) {
                handler.accept(event);
            }
        });
    }

    public static void sendPacket(PacketContainer packet, Object exceptLoc, Player player) {
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            Logging.reportException(exceptLoc, e);
        }
    }

    public static void sendPacket(PacketContainer packet, Object exceptLoc, Player[] players) {
        try {
            for (Player player : players) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
            }
        }
        catch (InvocationTargetException e) {
            Logging.reportException(exceptLoc, e);
        }
    }

    public static void sendPacket(PacketContainer packet, Object exceptLoc, Iterable<Player> players) {
        try {
            for (Player player : players) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
            }
        }
        catch (InvocationTargetException e) {
            Logging.reportException(exceptLoc, e);
        }
    }

    public static Map<String, PacketType> createNameToPacketTypeMap() {
        HashMap<String, PacketType> packetTypesByName = new HashMap<String, PacketType>();
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Play.Server.getInstance().iterator(), "PLAY", true);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Play.Client.getInstance().iterator(), "PLAY", false);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Handshake.Server.getInstance().iterator(), "HANDSHAKE", true);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Handshake.Client.getInstance().iterator(), "HANDSHAKE", false);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Login.Server.getInstance().iterator(), "LOGIN", true);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Login.Client.getInstance().iterator(), "LOGIN", false);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Status.Server.getInstance().iterator(), "STATUS", true);
        PacketManager.addPacketTypes(packetTypesByName, PacketType.Status.Client.getInstance().iterator(), "STATUS", false);
        return packetTypesByName;
    }

    public static void addPacketTypes(Map<String, PacketType> map, Iterator<PacketType> packetTypeIterator, String prefix, Boolean isServer) {
        while (packetTypeIterator.hasNext()) {
            PacketType current = packetTypeIterator.next();
            String fullname = prefix + "_" + (isServer != false ? "SERVER" : "CLIENT") + "_" + current.name().toUpperCase();
            map.put(fullname, current);
        }
    }

    static {
        packetInfoExpressionInfos = new ArrayList();
    }
}

