/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.DocumentationElement;
import com.pie.tlatoani.Util.MundoUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bukkit.command.CommandSender;

public final class Documentation {
    public static final Comparator<DocumentationElement> DOCUMENTATION_ELEMENT_COMPARATOR = Comparator.comparing(docElem -> docElem.category);
    public static final int ELEMENTS_PER_PAGE = 8;
    private static List<DocumentationBuilder> builders = new ArrayList<DocumentationBuilder>();
    private static boolean built = false;
    private static SortedSet<String> categories = null;
    private static ListMultimap<String, DocumentationElement> allElements = null;
    private static ListMultimap<String, DocumentationElement.Effect> effects = null;
    private static ListMultimap<String, DocumentationElement.Expression> expressions = null;
    private static ListMultimap<String, DocumentationElement.Event> events = null;
    private static ListMultimap<String, DocumentationElement.Type> types = null;

    static void addBuilder(DocumentationBuilder builder) {
        builders.add(builder);
    }

    public static void buildDocumentation() {
        if (built) {
            throw new IllegalStateException("The documentation has already been built");
        }
        categories = new TreeSet<String>();
        allElements = ArrayListMultimap.create();
        effects = ArrayListMultimap.create();
        expressions = ArrayListMultimap.create();
        events = ArrayListMultimap.create();
        types = ArrayListMultimap.create();
        for (DocumentationBuilder builder : builders) {
            Object docElem = builder.build();
            categories.add(((DocumentationElement)docElem).category);
            allElements.put((Object)((DocumentationElement)docElem).category, docElem);
            if (docElem instanceof DocumentationElement.Effect) {
                effects.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Effect)docElem));
                continue;
            }
            if (docElem instanceof DocumentationElement.Expression) {
                expressions.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Expression)docElem));
                continue;
            }
            if (docElem instanceof DocumentationElement.Event) {
                events.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Event)docElem));
                continue;
            }
            if (!(docElem instanceof DocumentationElement.Type)) continue;
            types.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Type)docElem));
        }
        MundoUtil.sortListMultimap(allElements, DOCUMENTATION_ELEMENT_COMPARATOR);
        MundoUtil.sortListMultimap(effects, DOCUMENTATION_ELEMENT_COMPARATOR);
        MundoUtil.sortListMultimap(expressions, DOCUMENTATION_ELEMENT_COMPARATOR);
        MundoUtil.sortListMultimap(events, DOCUMENTATION_ELEMENT_COMPARATOR);
        MundoUtil.sortListMultimap(types, DOCUMENTATION_ELEMENT_COMPARATOR);
        built = true;
    }

    public static List<DocumentationElement> getAll(ListMultimap<String, ? extends DocumentationElement> docElemListMultimap, CommandSender sender, int page) {
        ArrayList<DocumentationElement> result = new ArrayList<DocumentationElement>(8);
        int lastElemIndex = page * 8;
        int lastPrecedingElemIndex = lastElemIndex - 8;
        int prevElems = 0;
        for (String category : categories) {
            List docElems = docElemListMultimap.get((Object)category);
            if (prevElems + docElems.size() > lastPrecedingElemIndex) {
                int skippedElems = Math.max(0, lastPrecedingElemIndex - prevElems);
                prevElems += skippedElems;
                while (skippedElems < docElems.size()) {
                    result.add((DocumentationElement)docElems.get(skippedElems));
                    if (++prevElems == lastElemIndex) {
                        return result;
                    }
                    ++skippedElems;
                }
                continue;
            }
            prevElems += docElems.size();
        }
        return result;
    }

    public static List<DocumentationElement> getCategory(List<? extends DocumentationElement> docElems, CommandSender sender, int page) {
        ArrayList<DocumentationElement> result = new ArrayList<DocumentationElement>();
        int max = page * 8;
        int min = max - 8;
        max = Math.min(max, docElems.size());
        for (int i = min; i < max; ++i) {
            result.add(docElems.get(i));
        }
        return result;
    }

    public static void accessDocumentation(CommandSender sender, List<String> args) {
        if (args.size() == 0) {
            sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Documentation Categories");
            for (String category : categories) {
                sender.sendMessage(Mundo.ALT_CHAT_COLOR + category);
            }
            return;
        }
        if (args.size() > 1) {
            try {
                int page = Integer.parseInt(args.get(args.size() - 1));
                if (page < 1) {
                    page = 1;
                }
                args.remove(args.size() - 1);
            }
            catch (NumberFormatException e) {
                boolean bl = true;
            }
        }
    }

    public static void displayElems(CommandSender sender, List<? extends DocumentationElement> docElems, String header, int page, int pages, boolean displayType) {
        sender.sendMessage(Mundo.PRIMARY_CHAT_COLOR + "Page " + page + " of " + pages + " of " + header);
        for (DocumentationElement documentationElement : docElems) {
            sender.sendMessage((displayType ? Mundo.TRI_CHAT_COLOR + "" + (Object)((Object)documentationElement.getType()) + "" : "") + Mundo.ALT_CHAT_COLOR + documentationElement.name);
        }
    }
}

