/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.WorldCreator;

import com.pie.tlatoani.Generator.ChunkGeneratorWithID;
import com.pie.tlatoani.Util.MundoUtil;
import com.pie.tlatoani.WorldCreator.Dimension;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.ChunkGenerator;
import org.json.simple.JSONObject;

public class WorldCreatorData {
    public final Optional<String> name;
    public final Dimension dimension;
    public final WorldType type;
    public final Optional<Long> seed;
    public final Optional<ChunkGenerator> generator;
    public final String generatorSettings;
    public final boolean structures;

    public WorldCreatorData(Optional<String> name, @Nullable Dimension dimension, Optional<Long> seed, @Nullable WorldType type, Optional<ChunkGenerator> generator, @Nullable String generatorSettings, @Nullable Boolean structures) {
        if (name == null) {
            throw new IllegalArgumentException("The name of a creator cannot be null!");
        }
        this.name = name;
        this.dimension = Optional.ofNullable(dimension).orElse(Dimension.NORMAL);
        this.type = Optional.ofNullable(type).orElse(WorldType.NORMAL);
        this.seed = seed;
        this.generator = generator;
        this.generatorSettings = Optional.ofNullable(generatorSettings).orElse("");
        this.structures = Optional.ofNullable(structures).orElse(true);
    }

    public static WorldCreatorData withGeneratorID(Optional<String> name, @Nullable Dimension dimension, Optional<Long> seed, @Nullable WorldType type, String generatorID, @Nullable String generatorSettings, @Nullable Boolean structures) {
        return new WorldCreatorData(name, dimension, seed, type, Optional.ofNullable(generatorID).map(ChunkGeneratorWithID::getGenerator), generatorSettings, structures);
    }

    public static WorldCreatorData fromWorld(World world) {
        return new WorldCreatorData(Optional.of(world.getName()), Dimension.fromEnvironment(world.getEnvironment()), Optional.of(world.getSeed()), world.getWorldType(), Optional.ofNullable(world.getGenerator()), null, world.canGenerateStructures());
    }

    public void createWorld() {
        if (!this.name.isPresent()) {
            throw new UnsupportedOperationException("You must supply a name if you want to create a world using a nameless creator: " + this);
        }
        WorldCreator creator = new WorldCreator(this.name.get());
        creator.environment(this.dimension.toEnvironment());
        creator.type(this.type);
        creator.seed(this.seed.orElseGet(() -> new Random().nextLong()).longValue());
        this.generator.ifPresent(arg_0 -> ((WorldCreator)creator).generator(arg_0));
        creator.generatorSettings(this.generatorSettings);
        creator.generateStructures(this.structures);
        creator.createWorld();
    }

    public void createWorld(String name) {
        WorldCreator creator = new WorldCreator(name);
        creator.environment(this.dimension.toEnvironment());
        creator.type(this.type);
        creator.seed(this.seed.orElseGet(() -> new Random().nextLong()).longValue());
        this.generator.ifPresent(arg_0 -> ((WorldCreator)creator).generator(arg_0));
        creator.generatorSettings(this.generatorSettings);
        creator.generateStructures(this.structures);
        creator.createWorld();
    }

    public Optional<String> getGeneratorID() {
        return this.generator.flatMap(chunkGenerator -> MundoUtil.cast(chunkGenerator, ChunkGeneratorWithID.class)).map(generatorWIthID -> generatorWIthID.id);
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"environment", (Object)this.dimension.toString());
        this.seed.ifPresent(seedLong -> jsonObject.put((Object)"seed", (Object)Long.toString(seedLong)));
        jsonObject.put((Object)"worldtype", (Object)this.type.toString());
        this.getGeneratorID().ifPresent(generator -> jsonObject.put((Object)"generator", generator));
        jsonObject.put((Object)"generatorsettings", (Object)this.generatorSettings);
        jsonObject.put((Object)"structures", (Object)this.structures);
        return jsonObject;
    }

    public static Optional<WorldCreatorData> fromJSON(Optional<String> worldName, JSONObject jsonObject) {
        try {
            Dimension dimension = Dimension.valueOf((String)jsonObject.get((Object)"environment"));
            Optional<Long> seed = Optional.ofNullable((String)jsonObject.get((Object)"seed")).map(Long::parseLong);
            WorldType type = WorldType.valueOf((String)((String)jsonObject.get((Object)"worldtype")));
            String generatorID = (String)jsonObject.get((Object)"generator");
            String generatorSettings = (String)jsonObject.get((Object)"generatorsettings");
            Boolean structures = (Boolean)jsonObject.get((Object)"structures");
            return Optional.of(WorldCreatorData.withGeneratorID(worldName, dimension, seed, type, generatorID, generatorSettings, structures));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    public WorldCreatorData setName(Optional<String> name) {
        return new WorldCreatorData(name, this.dimension, this.seed, this.type, this.generator, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setDimension(Dimension dimension) {
        return new WorldCreatorData(this.name, dimension, this.seed, this.type, this.generator, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setSeed(Optional<Long> seed) {
        return new WorldCreatorData(this.name, this.dimension, seed, this.type, this.generator, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setType(WorldType type) {
        return new WorldCreatorData(this.name, this.dimension, this.seed, type, this.generator, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setGenerator(Optional<ChunkGenerator> generator) {
        return new WorldCreatorData(this.name, this.dimension, this.seed, this.type, generator, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setGeneratorID(String id) {
        return WorldCreatorData.withGeneratorID(this.name, this.dimension, this.seed, this.type, id, this.generatorSettings, this.structures);
    }

    public WorldCreatorData setGeneratorSettings(String generatorSettings) {
        return new WorldCreatorData(this.name, this.dimension, this.seed, this.type, this.generator, generatorSettings, this.structures);
    }

    public WorldCreatorData setStructures(Boolean structures) {
        return new WorldCreatorData(this.name, this.dimension, this.seed, this.type, this.generator, this.generatorSettings, structures);
    }

    public String toString() {
        return MundoUtil.mapOptional(this.name, str -> str + ":", () -> "") + this.toJSON();
    }
}

