/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Util;

import java.util.ArrayList;
import java.util.ListIterator;

public class CircularIterator<E>
implements ListIterator<E> {
    private ArrayList<E> list;
    private Integer index = 0;

    public CircularIterator(ArrayList<E> list) {
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public E next() {
        this.index = this.nextIndex();
        return this.list.get(this.index);
    }

    @Override
    public boolean hasPrevious() {
        return true;
    }

    @Override
    public E previous() {
        this.index = this.previousIndex();
        return this.list.get(this.index);
    }

    @Override
    public int nextIndex() {
        return (this.index + 1) % this.list.size();
    }

    @Override
    public int previousIndex() {
        return (this.index + this.list.size() - 1) % this.list.size();
    }

    @Override
    public void remove() {
        this.list.remove(this.index);
    }

    @Override
    public void set(E o) {
        this.list.set(this.index, o);
    }

    @Override
    public void add(E o) {
        this.list.add(this.index, o);
    }
}

