/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Registration;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.pie.tlatoani.Registration.DocumentationBuilder;
import com.pie.tlatoani.Registration.DocumentationElement;
import java.util.ArrayList;
import java.util.List;

public final class Documentation {
    private static List<DocumentationBuilder> builders = new ArrayList<DocumentationBuilder>();
    private static boolean built = false;
    private static Multimap<String, DocumentationElement.Effect> effects = null;
    private static Multimap<String, DocumentationElement.Expression> expressions = null;
    private static Multimap<String, DocumentationElement.Event> events = null;
    private static Multimap<String, DocumentationElement.Type> types = null;

    static void addBuilder(DocumentationBuilder builder) {
        builders.add(builder);
    }

    public static void buildDocumentation() {
        if (built) {
            throw new IllegalStateException("The documentation has already been built");
        }
        effects = ArrayListMultimap.create();
        expressions = ArrayListMultimap.create();
        events = ArrayListMultimap.create();
        types = ArrayListMultimap.create();
        for (DocumentationBuilder builder : builders) {
            Object docElem = builder.build();
            if (docElem instanceof DocumentationElement.Effect) {
                effects.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Effect)docElem));
                continue;
            }
            if (docElem instanceof DocumentationElement.Expression) {
                expressions.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Expression)docElem));
                continue;
            }
            if (docElem instanceof DocumentationElement.Event) {
                events.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Event)docElem));
                continue;
            }
            if (!(docElem instanceof DocumentationElement.Type)) continue;
            types.put((Object)((DocumentationElement)docElem).category, (Object)((DocumentationElement.Type)docElem));
        }
        built = true;
    }
}

