/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.SkinTexture.SkinTexture;
import com.pie.tlatoani.Tablist.Array.ArrayTabList;
import com.pie.tlatoani.Tablist.Simple.SimpleTabList;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TabListManager
implements Listener {
    private static final HashMap<UUID, SimpleTabList> simpleTabLists = new HashMap();
    private static final HashMap<UUID, ArrayTabList> arrayTabLists = new HashMap();
    private static final HashMap<UUID, ArrayList<UUID>> hiddenPlayerLists = new HashMap();
    private static final ArrayList<UUID> playerFreeTablists = new ArrayList();
    public static final PacketType packetType = PacketType.Play.Server.PLAYER_INFO;
    public static final Charset utf8 = Charset.forName("UTF-8");
    public static final SkinTexture DEFAULT_SKIN_TEXTURE = new SkinTexture.Simple("eyJ0aW1lc3RhbXAiOjE0NzAwMjgwNDU3MzUsInByb2ZpbGVJZCI6IjQzYTgzNzNkNjQyOTQ1MTBhOWFhYjMwZjViM2NlYmIzIiwicHJvZmlsZU5hbWUiOiJTa3VsbENsaWVudFNraW42Iiwic2lnbmF0dXJlUmVxdWlyZWQiOnRydWUsInRleHR1cmVzIjp7IlNLSU4iOnsidXJsIjoiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9iNTg3OTM1YzdmYmVjYzJmYWMxMDY0OWZjZGZiODM1YjQ2NTA3MzZiOWJmMWQ0NGVhZjc2ZDNiOWVmN2UwIn19fQ==", "eTy8+/waBl22GpAyTHx+QY40J3DY57F2FSkVupjJxAuuUfstvX/DxmJANKtIcYCYP9LUHh9DkP1T2bXUobHcx8GAICi8S/uEWXx96PHHjSr7wQ9uBC4NMCkV7dHHMKdVqEJ9jDpMvSax9vs1tOc2NWaeMbzc/345K95JaYVD+AV4W1+IuppXlMgDmCatUCgGDbzTuQKO8An9zFPciCRq1VSGaOPCj4PoIDQyMhSPqb1cPML/wH26Wtl4DEjnyVIyemk7oDBK29DXxtBLmzX6Ni1C8VM3UmG2StDC7dSwxJNLBHQ/aqXwupK4j0bZghiRbiaq4kAlPcpMeL+TTHac7oYFGihj/s/OVWaL0Fo2KgFZgKuZ26kDepCLEEOOoj2Zq8ohtxufPdTDqw032AyA/HbldnBIsCnQCDiq3XXdZHz0R+pvuf73BSHc7CiG2pwjSdSQ8XetlP70A9SddJu+iFuKGwzh/cvQ2H+sqoUYmIYIXcl2xJTy+Y/shxJDZZVxGCSHmj+4SYzJCg+nsNlEJ9HBG//LfeY+WhacbC9pPPy8wKnDqvIx0QX2YakyBFy659DEBEhSSNRQjOm78Zd9K7pP1QOrS2RDwsDSIXaR0gxT69Bv+Z/r+w8GJY6tHvT8aqTNQHpmv+kwMVdGOWMj3wMErW2aqjH9ffc1nuWht/E=");
    private static final Map<String, UUID> uuidSaver = new HashMap<String, UUID>();
    private static final String uuidbeginning = "62960000-6296-3000-8000-6296";
    private static int uuidKeyCounter = 0;
    public static final HashMap<UUID, String> tabNames = new HashMap();

    public static void onJoin(Player player) {
        simpleTabLists.put(player.getUniqueId(), new SimpleTabList(player));
        hiddenPlayerLists.put(player.getUniqueId(), new ArrayList());
        if (!playerFreeTablists.isEmpty()) {
            for (UUID targetUUID : playerFreeTablists.toArray(new UUID[0])) {
                TabListManager.hidePlayer(player, Bukkit.getPlayer((UUID)targetUUID));
            }
        }
    }

    public static void onQuit(final Player player) {
        TabListManager.getSimpleTabListForPlayer(player).clear();
        simpleTabLists.remove(player.getUniqueId());
        hiddenPlayerLists.remove(player.getUniqueId());
        hiddenPlayerLists.forEach(new BiConsumer<UUID, ArrayList<UUID>>(){

            @Override
            public void accept(UUID uuid, ArrayList<UUID> uuids) {
                uuids.remove(player.getUniqueId());
            }
        });
        playerFreeTablists.remove(player.getUniqueId());
        TabListManager.deactivateArrayTabList(player);
    }

    public static void activateArrayTabList(Player player, int columns, int rows, SkinTexture initialIcon) {
        Mundo.debug(TabListManager.class, "setARrayTagList");
        TabListManager.deactivateArrayTabList(player);
        arrayTabLists.put(player.getUniqueId(), new ArrayTabList(player, columns, rows, initialIcon));
    }

    public static void deactivateArrayTabList(Player player) {
        if (arrayTabLists.containsKey(player.getUniqueId())) {
            TabListManager.getArrayTabListForPlayer(player).clear();
            arrayTabLists.remove(player.getUniqueId());
        }
    }

    public static boolean tablistContainsPlayers(Player player) {
        return !playerFreeTablists.contains(player.getUniqueId());
    }

    public static void setTablistContainsPlayers(Player player, boolean whether) {
        if (whether != TabListManager.tablistContainsPlayers(player)) {
            ArrayList<UUID> hiddenPlayers = hiddenPlayerLists.get(player.getUniqueId());
            if (whether) {
                for (Player playerItem : Bukkit.getOnlinePlayers().toArray(new Player[0])) {
                    TabListManager.showPlayer(playerItem, player);
                }
                playerFreeTablists.remove(player.getUniqueId());
            } else {
                for (Player playerItem : Bukkit.getOnlinePlayers().toArray(new Player[0])) {
                    TabListManager.hidePlayer(playerItem, player);
                }
                playerFreeTablists.add(player.getUniqueId());
            }
        }
    }

    public static void showPlayer(Player player, Player to) {
        playerFreeTablists.remove(to.getUniqueId());
        ArrayList<UUID> hiddenPlayers = hiddenPlayerLists.get(to.getUniqueId());
        if (hiddenPlayers.contains(player.getUniqueId())) {
            hiddenPlayers.remove(player.getUniqueId());
            PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)TabListManager.colorStringToJson(player.getPlayerListName())));
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
            packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(to, packet);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void hidePlayer(Player player, Player from) {
        ArrayList<UUID> hiddenPlayers = hiddenPlayerLists.get(from.getUniqueId());
        if (!hiddenPlayers.contains(player.getUniqueId())) {
            hiddenPlayers.add(player.getUniqueId());
            PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)TabListManager.colorStringToJson(player.getPlayerListName())));
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
            packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(from, packet);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static SimpleTabList getSimpleTabListForPlayer(Player player) {
        return simpleTabLists.get(player.getUniqueId());
    }

    public static ArrayTabList getArrayTabListForPlayer(Player player) {
        return arrayTabLists.get(player.getUniqueId());
    }

    public static String colorStringToJson(String original) {
        char colorChar = '\u00a7';
        String template = "{text:\"TEXT\",color:COLOR,bold:BOLD,underlined:UNDERLINED,italic:ITALIC,strikethrough:STRIKETHROUGH,obfuscated:OBFUSCATED,extra:[EXTRA]}";
        String json = "";
        ArrayList<String> parts = new ArrayList<String>();
        int first = 0;
        int last = 0;
        while ((first = original.indexOf(colorChar, last)) != -1) {
            int offset = 2;
            while ((last = original.indexOf(colorChar, first + offset)) - 2 == first) {
                offset += 2;
            }
            if (last == -1) {
                parts.add(original.substring(first));
                break;
            }
            parts.add(original.substring(first, last));
        }
        if (parts.isEmpty()) {
            parts.add(original);
        }
        Pattern colorFinder = Pattern.compile("(" + colorChar + "([a-f0-9]))");
        for (String part : parts) {
            json = json.isEmpty() ? template : json.replace("EXTRA", template);
            Matcher matcher = colorFinder.matcher(part);
            ChatColor color = matcher.find() ? ChatColor.getByChar((char)matcher.group().charAt(1)) : ChatColor.WHITE;
            json = json.replace("COLOR", color.name().toLowerCase());
            json = json.replace("BOLD", String.valueOf(part.contains(ChatColor.BOLD.toString())));
            json = json.replace("ITALIC", String.valueOf(part.contains(ChatColor.ITALIC.toString())));
            json = json.replace("UNDERLINED", String.valueOf(part.contains(ChatColor.UNDERLINE.toString())));
            json = json.replace("STRIKETHROUGH", String.valueOf(part.contains(ChatColor.STRIKETHROUGH.toString())));
            json = json.replace("OBFUSCATED", String.valueOf(part.contains(ChatColor.MAGIC.toString())));
            json = json.replace("TEXT", part.replaceAll("(" + colorChar + "([a-z0-9]))", ""));
        }
        json = json.replace(",extra:[EXTRA]", "");
        return json;
    }

    static {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.NAMED_ENTITY_SPAWN}){

            public void onPacketSending(PacketEvent event) {
                Player player = Bukkit.getPlayer((UUID)((UUID)event.getPacket().getUUIDs().read(0)));
                Mundo.debug(TabListManager.class, "Received spawn packet of " + player.getDisplayName() + " sending to " + event.getPlayer().getDisplayName());
                if (((ArrayList)hiddenPlayerLists.get(event.getPlayer().getUniqueId())).contains(player.getUniqueId()) && !event.isCancelled()) {
                    Mundo.debug(TabListManager.class, "Player is hidden");
                    PlayerInfoData playerInfoData = new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player), 5, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode()), WrappedChatComponent.fromJson((String)TabListManager.colorStringToJson(player.getPlayerListName())));
                    PacketContainer packet = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    packet.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
                    packet.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    try {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(event.getPlayer(), packet);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    PacketContainer removePacket = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                    removePacket.getPlayerInfoDataLists().writeSafely(0, Arrays.asList(playerInfoData));
                    removePacket.getPlayerInfoAction().writeSafely(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    Mundo.scheduler.runTask((Plugin)Mundo.instance, (Runnable)new PacketSender(removePacket, event.getPlayer()));
                }
            }
        });
    }

    public static class PacketSender
    implements Runnable {
        private PacketContainer packet;
        private Player[] players;

        public PacketSender(PacketContainer packet, Player ... players) {
            this.packet = packet;
            this.players = players;
        }

        @Override
        public void run() {
            for (Player player : this.players) {
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, this.packet);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

