/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.SkinTexture;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.Multimap;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.SkinTexture.SkinTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SkinManager {
    private static HashMap<UUID, SkinTexture> actualSkins = new HashMap();
    private static HashMap<UUID, SkinTexture> displayedSkins = new HashMap();
    private static HashMap<UUID, String> nameTags = new HashMap();

    private SkinManager() {
    }

    public static void onJoin(Player player) {
    }

    public static void onQuit(Player player) {
        actualSkins.remove(player.getUniqueId());
        displayedSkins.remove(player.getUniqueId());
        nameTags.remove(player.getUniqueId());
    }

    public static SkinTexture getActualSkin(Player player) {
        return actualSkins.get(player.getUniqueId());
    }

    public static SkinTexture getDisplayedSkin(Player player) {
        return displayedSkins.get(player.getUniqueId());
    }

    public static void setDisplayedSkin(Player player, SkinTexture skinTexture) {
        Mundo.debug(SkinManager.class, "SKINTEXTURE: " + skinTexture);
        if (skinTexture != null) {
            displayedSkins.put(player.getUniqueId(), skinTexture);
        } else {
            displayedSkins.put(player.getUniqueId(), SkinManager.getActualSkin(player));
        }
        SkinManager.refreshPlayer(player);
    }

    public static String getNameTag(Player player) {
        return nameTags.get(player.getUniqueId());
    }

    public static void setNameTag(Player player, String nameTag) {
        Mundo.debug(SkinManager.class, "Setting nametag of " + player.getName() + " to " + nameTag);
        if (nameTag != null) {
            nameTags.put(player.getUniqueId(), nameTag);
        } else {
            nameTags.put(player.getUniqueId(), player.getName());
        }
        SkinManager.refreshPlayer(player);
    }

    private static void refreshPlayer(final Player player) {
        for (Player target : Bukkit.getOnlinePlayers()) {
            target.hidePlayer(player);
        }
        Mundo.scheduler.scheduleSyncDelayedTask((Plugin)Mundo.instance, new Runnable(){

            @Override
            public void run() {
                for (Player target : Bukkit.getOnlinePlayers()) {
                    target.showPlayer(player);
                }
            }
        }, 1L);
    }

    static {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)Mundo.instance, new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

            public void onPacketSending(PacketEvent event) {
                if (!event.isCancelled() && event.getPacket().getPlayerInfoAction().read(0) == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
                    List playerInfoDatas = (List)event.getPacket().getPlayerInfoDataLists().readSafely(0);
                    ArrayList<PlayerInfoData> newPlayerInfoDatas = new ArrayList<PlayerInfoData>();
                    for (PlayerInfoData playerInfoData : playerInfoDatas) {
                        if (!actualSkins.containsKey(playerInfoData.getProfile().getUUID()) && playerInfoData.getProfile().getUUID().toString().substring(14, 15).equals("4")) {
                            Mundo.debug(SkinManager.class, "NEW PLAYER !");
                            SkinTexture.Collected skinTexture = new SkinTexture.Collected(playerInfoData.getProfile().getProperties().get((Object)"textures"));
                            actualSkins.put(playerInfoData.getProfile().getUUID(), skinTexture);
                            displayedSkins.put(playerInfoData.getProfile().getUUID(), skinTexture);
                            nameTags.put(playerInfoData.getProfile().getUUID(), playerInfoData.getProfile().getName());
                        }
                        PlayerInfoData newPlayerInfoData = new PlayerInfoData(playerInfoData.getProfile().withName((String)nameTags.get(playerInfoData.getProfile().getUUID())), playerInfoData.getLatency(), playerInfoData.getGameMode(), playerInfoData.getDisplayName());
                        newPlayerInfoDatas.add(newPlayerInfoData);
                        SkinTexture skinTexture = (SkinTexture)displayedSkins.get(newPlayerInfoData.getProfile().getUUID());
                        Mundo.debug(SkinManager.class, "PLAYER DISPLAY NAME: " + newPlayerInfoData.getProfile().getName());
                        Mundo.debug(SkinManager.class, "PLAYER INFO DATA NAME: " + newPlayerInfoData.getDisplayName());
                        Mundo.debug(SkinManager.class, "PLAYER UUID: " + newPlayerInfoData.getProfile().getUUID());
                        Mundo.debug(SkinManager.class, "SKINTEXTURE FOUND IN PACKET: " + newPlayerInfoData.getProfile().getProperties().get((Object)"textures"));
                        Mundo.debug(SkinManager.class, "SKINTEXTURE REPLACEMENT (MAY OR MAY NOT EXIST): " + skinTexture);
                        if (skinTexture == null) continue;
                        skinTexture.retrieveSkinTextures((Multimap<String, WrappedSignedProperty>)newPlayerInfoData.getProfile().getProperties());
                    }
                    event.getPacket().getPlayerInfoDataLists().writeSafely(0, newPlayerInfoDatas);
                }
            }
        });
    }
}

