/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ListUtil;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pie.tlatoani.ListUtil.ListUtil;
import com.pie.tlatoani.ListUtil.Transformer;
import org.bukkit.event.Event;

public class ExprItemCount
extends SimpleExpression<Number> {
    private String pattern;
    private Transformer transformer;
    private Expression expression;
    private Boolean isSettable;
    private Boolean usedAsLast;

    public ExprItemCount() {
    }

    public ExprItemCount(Transformer transformer, Expression expression) {
        this.usedAsLast = true;
        this.transformer = transformer;
        this.expression = expression;
        this.pattern = null;
        this.isSettable = false;
    }

    protected Number[] get(Event event) {
        return new Number[]{this.transformer.get(event).length};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return this.usedAsLast != false ? "last" : this.pattern + " count of " + this.expression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.usedAsLast = false;
        this.expression = expressions[0];
        this.pattern = ListUtil.retrievePattern(i);
        this.transformer = ListUtil.retrieveTransformer(this.pattern, this.expression);
        if (this.transformer == null) {
            return false;
        }
        this.isSettable = this.transformer.isSettable();
        return true;
    }

    public void change(Event arg0, Object[] delta, Changer.ChangeMode mode) {
        T[] original = this.transformer.get(arg0);
        Integer newcount = 0;
        if (mode == Changer.ChangeMode.SET) {
            newcount = ((Number)delta[0]).intValue();
        } else if (mode == Changer.ChangeMode.ADD) {
            newcount = original.length + ((Number)delta[0]).intValue();
        } else if (mode == Changer.ChangeMode.REMOVE) {
            newcount = original.length - ((Number)delta[0]).intValue();
        }
        if (newcount < 0) {
            newcount = 0;
        }
        Object[] finalarray = new Object[newcount.intValue()];
        if (newcount <= original.length) {
            System.arraycopy(original, 0, finalarray, 0, newcount);
        } else {
            System.arraycopy(original, 0, finalarray, 0, original.length);
            if (this.transformer instanceof Transformer.Resettable) {
                for (int i = original.length; i < newcount; ++i) {
                    finalarray[i] = ((Transformer.Resettable)this.transformer).reset();
                }
            } else {
                for (int i = original.length; i < newcount; ++i) {
                    finalarray[i] = null;
                }
            }
        }
        this.transformer.setSafely(arg0, finalarray);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.isSettable.booleanValue()) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        if (mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }
}

