/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.Array;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.Multimap;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.UtilPacketEvent;
import com.pie.tlatoani.SkinTexture.SkinTexture;
import com.pie.tlatoani.Tablist.TabListManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class ArrayTabList {
    private final Player player;
    private final String[][] displayNames = new String[4][20];
    private final Integer[][] latencies = new Integer[4][20];
    private final SkinTexture[][] heads = new SkinTexture[4][20];
    private static final String uuidbeginning = "10001000-1000-3000-8000-10001000";
    private int columns;
    private int rows;
    public SkinTexture initialIcon;

    public ArrayTabList(Player player, int columns, int rows, SkinTexture initialIcon) {
        Mundo.debug((Object)this, "constructor " + columns + " " + rows);
        this.player = player;
        this.columns = Mundo.limitToRange(1, columns, 4);
        this.rows = 0;
        rows = columns == 1 ? Mundo.limitToRange(1, rows, 20) : (columns == 2 ? Mundo.limitToRange(11, rows, 20) : (columns == 3 ? Mundo.limitToRange(14, rows, 20) : Mundo.limitToRange(16, rows, 20)));
        this.initialIcon = initialIcon;
        this.setRows(rows);
    }

    private void sendPacket(int column, int row, EnumWrappers.PlayerInfoAction action) {
        int ping = this.latencies[column - 1][row - 1];
        String displayName = this.displayNames[column - 1][row - 1];
        SkinTexture icon = this.heads[column - 1][row - 1];
        WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)TabListManager.colorStringToJson(displayName));
        int identifier = (column - 1) * 20 + row;
        if (identifier % 2 == 0) {
            identifier += 79;
        }
        UUID uuid = UUID.fromString("10001000-1000-3000-8000-1000100010" + Mundo.toHexDigit(Mundo.divideNoRemainder(identifier, 10)) + identifier % 10);
        WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, "");
        if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
            icon.retrieveSkinTextures((Multimap<String, WrappedSignedProperty>)gameProfile.getProperties());
        }
        PlayerInfoData playerInfoData = new PlayerInfoData(gameProfile, ping, EnumWrappers.NativeGameMode.NOT_SET, chatComponent);
        List<PlayerInfoData> playerInfoDatas = Arrays.asList(playerInfoData);
        PacketContainer packetContainer = new PacketContainer(TabListManager.packetType);
        packetContainer.getPlayerInfoDataLists().writeSafely(0, playerInfoDatas);
        packetContainer.getPlayerInfoAction().writeSafely(0, (Object)action);
        try {
            UtilPacketEvent.protocolManager.sendServerPacket(this.player, packetContainer);
        }
        catch (InvocationTargetException e) {
            Mundo.reportException(this, e);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int columns) {
        if ((columns = Mundo.limitToRange(1, columns, 4)) > this.columns) {
            this.setRows(columns == 1 ? Mundo.limitToRange(1, this.rows, 20) : (columns == 2 ? Mundo.limitToRange(11, this.rows, 20) : (columns == 3 ? Mundo.limitToRange(14, this.rows, 20) : Mundo.limitToRange(16, this.rows, 20))));
        }
        if (columns > this.columns) {
            for (int column = this.columns + 1; column <= columns; ++column) {
                for (int row = 1; row <= this.rows; ++row) {
                    this.displayNames[column - 1][row - 1] = "";
                    this.latencies[column - 1][row - 1] = 5;
                    this.heads[column - 1][row - 1] = this.initialIcon;
                    this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                }
            }
        } else if (columns < this.columns) {
            for (int column = columns + 1; column <= this.columns; ++column) {
                for (int row = 1; row <= this.rows; ++row) {
                    this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    this.displayNames[column - 1][row - 1] = null;
                    this.latencies[column - 1][row - 1] = null;
                    this.heads[column - 1][row - 1] = null;
                }
            }
        }
        this.columns = columns;
    }

    public void setRows(int rows) {
        Mundo.debug((Object)this, "Got here, this.columns " + this.columns + ", this.rows " + this.rows + ", rows " + rows);
        int n = this.columns == 1 ? Mundo.limitToRange(1, rows, 20) : (this.columns == 2 ? Mundo.limitToRange(11, rows, 20) : (rows = this.columns == 3 ? Mundo.limitToRange(14, rows, 20) : Mundo.limitToRange(16, rows, 20)));
        if (rows > this.rows) {
            for (int column = 1; column <= this.columns; ++column) {
                for (int row = this.rows + 1; row <= rows; ++row) {
                    this.displayNames[column - 1][row - 1] = "";
                    this.latencies[column - 1][row - 1] = 5;
                    this.heads[column - 1][row - 1] = this.initialIcon;
                    this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                }
            }
        } else if (rows < this.rows) {
            for (int column = 1; column <= this.columns; ++column) {
                for (int row = rows + 1; row <= this.rows; ++row) {
                    this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    this.displayNames[column - 1][row - 1] = null;
                    this.latencies[column - 1][row - 1] = null;
                    this.heads[column - 1][row - 1] = null;
                }
            }
        }
        this.rows = rows;
    }

    public void clear() {
        for (int column = 1; column <= this.columns; ++column) {
            for (int row = 1; row <= this.rows; ++row) {
                this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            }
        }
    }

    public String getDisplayName(int column, int row) {
        return Mundo.isInRange(1, column, this.columns) && Mundo.isInRange(1, row, this.rows) ? this.displayNames[column - 1][row - 1] : null;
    }

    public Integer getLatency(int column, int row) {
        return Mundo.isInRange(1, column, this.columns) && Mundo.isInRange(1, row, this.rows) ? this.latencies[column - 1][row - 1] : null;
    }

    public SkinTexture getHead(int column, int row) {
        return Mundo.isInRange(1, column, this.columns) && Mundo.isInRange(1, row, this.rows) ? this.heads[column - 1][row - 1] : null;
    }

    public void setDisplayName(int column, int row, String displayName) {
        if (Mundo.isInRange(1, column, this.columns) && Mundo.isInRange(1, row, this.rows)) {
            this.displayNames[column - 1][row - 1] = displayName;
            this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
        }
    }

    public void setLatency(int column, int row, Integer ping) {
        if (Mundo.isInRange(1, column, this.columns) && Mundo.isInRange(1, row, this.rows)) {
            this.latencies[column - 1][row - 1] = ping;
            this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.UPDATE_LATENCY);
        }
    }

    public void setHead(int column, int row, SkinTexture head) {
        if (Mundo.isInRange(1, column, this.columns) && Mundo.isInRange(1, row, this.rows)) {
            this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            this.heads[column - 1][row - 1] = head;
            this.sendPacket(column, row, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        }
    }
}

