/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.pie.tlatoani.Mundo;
import com.pie.tlatoani.ProtocolLib.PacketInfoConverter;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ExprJsonObjectOfPacket
extends SimpleExpression<JSONObject> {
    private PacketInfoConverter<JSONObject> converter;
    private Expression<Number> index;
    private Expression<PacketContainer> packetContainerExpression;
    public static Map<String, PacketInfoConverter<JSONObject>> converterMap = new HashMap<String, PacketInfoConverter<JSONObject>>();

    public static void registerConverter(String name, PacketInfoConverter<JSONObject> converter) {
        converterMap.put(name, converter);
    }

    public static PacketInfoConverter<JSONObject> getConverter(String name) {
        return converterMap.get(name);
    }

    protected JSONObject[] get(Event event) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        Mundo.debug((Object)this, "Packet before calling function :" + packet);
        JSONObject result = this.converter.get(packet, ((Number)this.index.getSingle(event)).intValue());
        return new JSONObject[]{result};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<JSONObject> getReturnType() {
        return JSONObject.class;
    }

    public String toString(Event event, boolean b) {
        return "%string% pjson %number% of %packet%";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        String string;
        if (expressions[0] instanceof Literal) {
            string = (String)((Literal)expressions[0]).getSingle();
        } else if (expressions[0] instanceof VariableString) {
            String fullstring = ((VariableString)expressions[0]).toString();
            string = fullstring.substring(1, fullstring.length() - 1);
        } else {
            Skript.error((String)("The string '" + expressions[0] + "' is not a literal string! Only literal strings can be used in the pjson expression!"));
            return false;
        }
        this.index = expressions[1];
        this.packetContainerExpression = expressions[2];
        this.converter = ExprJsonObjectOfPacket.getConverter(string.toLowerCase());
        if (this.converter == null) {
            Skript.error((String)("The string " + string + " is not a valid packetinfo!"));
            return false;
        }
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        PacketContainer packet = (PacketContainer)this.packetContainerExpression.getSingle(event);
        Mundo.debug((Object)this, "Packet before calling function :" + packet);
        this.converter.set(packet, ((Number)this.index.getSingle(event)).intValue(), (JSONObject)delta[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{JSONObject.class});
        }
        return null;
    }

    static {
        ExprJsonObjectOfPacket.registerConverter("chatcomponent", new PacketInfoConverter<JSONObject>(){

            @Override
            public JSONObject get(PacketContainer packet, Integer index) {
                Mundo.debug((Object)this, "Packet :" + packet);
                Mundo.debug((Object)this, "ChatComponents :" + packet.getChatComponents());
                WrappedChatComponent chatComponent = (WrappedChatComponent)packet.getChatComponents().readSafely(index.intValue());
                String fromjson = chatComponent.getJson();
                Mundo.debug((Object)this, "Fromjson: " + fromjson);
                JSONParser parser = new JSONParser();
                JSONObject tojson = null;
                try {
                    tojson = (JSONObject)parser.parse(fromjson);
                }
                catch (ClassCastException | ParseException e) {
                    Mundo.debug(ExprJsonObjectOfPacket.class, (Exception)e);
                }
                Mundo.debug((Object)this, "Tojson " + tojson);
                return tojson;
            }

            @Override
            public void set(PacketContainer packet, Integer index, JSONObject value) {
                WrappedChatComponent chatComponent = WrappedChatComponent.fromJson((String)value.toString());
                packet.getChatComponents().writeSafely(index.intValue(), (Object)chatComponent);
            }
        });
    }
}

