/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.ListUtil;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.pie.tlatoani.ListUtil.ListUtil;
import com.pie.tlatoani.ListUtil.Transformer;
import org.bukkit.event.Event;

public class ExprItem
extends SimpleExpression
implements ListUtil.Moveable {
    private String pattern;
    private Transformer transformer;
    private Expression expression;
    private Expression<Number> index;
    private Class returnType;
    private Boolean isSettable;
    private Boolean isResettable;
    private Class typeToAdd;
    private Class typeToSubtract;
    private Boolean isLastIndex;

    protected Object[] get(Event event) {
        Integer index = ((Number)this.index.getSingle(event)).intValue() - 1;
        T[] original = this.transformer.get(event);
        if (index < 0) {
            index = 0;
        }
        return new Object[]{index < original.length ? original[index] : null};
    }

    public boolean isSingle() {
        return true;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String toString(Event event, boolean b) {
        return this.isLastIndex != false ? "last " + this.pattern + " of " + this.expression : this.pattern + " " + this.index + " of " + this.expression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expression = expressions[1];
        this.pattern = ListUtil.retrievePattern(i);
        this.transformer = ListUtil.retrieveTransformer(this.pattern, this.expression);
        this.isLastIndex = expressions[0] == null;
        Object object = this.index = this.isLastIndex == false ? expressions[0] : new Expression(this.transformer, this.expression);
        if (this.transformer == null) {
            return false;
        }
        this.returnType = this.transformer.getType();
        this.isSettable = this.transformer.isSettable();
        this.isResettable = this.transformer instanceof Transformer.Resettable;
        this.typeToAdd = this.transformer instanceof Transformer.Addable ? ((Transformer.Addable)this.transformer).getAddendType() : null;
        this.typeToSubtract = this.transformer instanceof Transformer.Removeable ? ((Transformer.Removeable)this.transformer).getSubtrahendType() : null;
        return true;
    }

    public void change(Event arg0, Object[] delta, Changer.ChangeMode mode) {
        Object[] original = this.transformer.get(arg0);
        Integer index = ((Number)this.index.getSingle(arg0)).intValue() - 1;
        if (index < original.length && index >= 0) {
            if (mode == Changer.ChangeMode.SET) {
                original[index.intValue()] = delta[0];
                this.transformer.setSafely(arg0, original);
            } else if (mode == Changer.ChangeMode.ADD) {
                original[index.intValue()] = ((Transformer.Addable)this.transformer).add(original[index], delta[0]);
                this.transformer.setSafely(arg0, original);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                original[index.intValue()] = ((Transformer.Removeable)this.transformer).remove(original[index], delta[0]);
                this.transformer.setSafely(arg0, original);
            } else if (mode == Changer.ChangeMode.DELETE) {
                Object[] finalarray = new Object[original.length - 1];
                System.arraycopy(original, 0, finalarray, 0, index);
                System.arraycopy(original, index + 1, finalarray, index, original.length - index - 1);
                this.transformer.setSafely(arg0, finalarray);
            } else if (mode == Changer.ChangeMode.RESET) {
                original[index.intValue()] = ((Transformer.Resettable)this.transformer).reset();
                this.transformer.setSafely(arg0, original);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.isSettable.booleanValue()) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.returnType});
        }
        if (mode == Changer.ChangeMode.RESET && this.isResettable.booleanValue()) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        if (mode == Changer.ChangeMode.ADD && this.typeToAdd != null) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.typeToAdd});
        }
        if (mode == Changer.ChangeMode.REMOVE && this.typeToSubtract != null) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.typeToSubtract});
        }
        return null;
    }

    @Override
    public void move(Event event, Integer movement) {
        Integer index1 = ((Number)this.index.getSingle(event)).intValue() - 1;
        T[] original = this.transformer.get(event);
        if (index1 >= original.length || index1 < 0) {
            return;
        }
        Object[] secondarray = new Object[original.length - 1];
        System.arraycopy(original, 0, secondarray, 0, index1);
        System.arraycopy(original, index1 + 1, secondarray, index1, original.length - index1 - 1);
        Object insertion = original[index1];
        Integer index = index1 + movement;
        if (index < 0) {
            index = 0;
        }
        if (index > secondarray.length) {
            Object[] neworiginal = new Object[index.intValue()];
            System.arraycopy(secondarray, 0, neworiginal, 0, secondarray.length);
            if (this.transformer instanceof Transformer.Resettable) {
                for (int i = secondarray.length; i < index; ++i) {
                    neworiginal[i] = ((Transformer.Resettable)this.transformer).reset();
                }
            } else {
                for (int i = secondarray.length; i < index; ++i) {
                    neworiginal[i] = null;
                }
            }
            secondarray = neworiginal;
        }
        Object[] result = new Object[secondarray.length + 1];
        System.arraycopy(secondarray, 0, result, 0, index);
        result[index.intValue()] = insertion;
        System.arraycopy(secondarray, index, result, index + 1, secondarray.length - index);
        this.transformer.setSafely(event, result);
    }

    @Override
    public Boolean isMoveable() {
        return this.transformer.isSettable();
    }
}

