/*
 * Decompiled with CFR 0.152.
 */
package com.pie.tlatoani.Tablist.SkinTexture;

import ch.njol.util.Pair;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.Multimap;
import com.pie.tlatoani.Mundo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class SkinTexture {
    private List<Pair<String, String>> textures;
    private Collection<WrappedSignedProperty> altTextures;

    public SkinTexture(String value, String signature) {
        this.textures = Arrays.asList(new Pair((Object)value, (Object)signature));
    }

    public SkinTexture(Player player) {
        this.textures = null;
        this.altTextures = WrappedGameProfile.fromPlayer((Player)player).getProperties().get((Object)"textures");
    }

    public SkinTexture(JSONArray jsonArray) {
        Pair[] pairs = new Pair[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            pairs[i] = new Pair((Object)((String)jsonObject.get((Object)"value")), (Object)((String)jsonObject.get((Object)"signature")));
        }
        this.textures = Arrays.asList(pairs);
    }

    public void retrieveSkinTextures(final Multimap<String, WrappedSignedProperty> multimap) {
        multimap.removeAll((Object)"textures");
        if (this.textures != null) {
            this.textures.forEach(new Consumer<Pair<String, String>>(){

                @Override
                public void accept(Pair<String, String> pair) {
                    Mundo.debug(SkinTexture.class, "PAIR: " + (String)pair.getFirst() + "=second=" + (String)pair.getSecond());
                    WrappedSignedProperty property = new WrappedSignedProperty("textures", (String)pair.getFirst(), (String)pair.getSecond());
                    multimap.put((Object)"textures", (Object)property);
                }
            });
        } else {
            multimap.putAll((Object)"textures", this.altTextures);
        }
    }

    public JSONArray toJSONArray() {
        final JSONArray jsonArray = new JSONArray();
        if (this.textures != null) {
            this.textures.forEach(new Consumer<Pair<String, String>>(){

                @Override
                public void accept(Pair<String, String> pair) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"value", pair.getFirst());
                    jsonObject.put((Object)"signature", pair.getSecond());
                    jsonArray.add((Object)jsonObject);
                }
            });
        } else {
            this.altTextures.forEach(new Consumer<WrappedSignedProperty>(){

                @Override
                public void accept(WrappedSignedProperty wrappedSignedProperty) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put((Object)"value", (Object)wrappedSignedProperty.getValue());
                    jsonObject.put((Object)"signature", (Object)wrappedSignedProperty.getSignature());
                    jsonArray.add((Object)jsonObject);
                }
            });
        }
        return jsonArray;
    }

    public String toString() {
        return this.toJSONArray().toJSONString();
    }

    public boolean equals(Object other) {
        return other instanceof SkinTexture && this.toString().equals(other.toString());
    }
}

